/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.diet.common.data.group;

import com.illusivesoulworks.diet.DietCommonMod;
import com.illusivesoulworks.diet.api.type.IDietGroup;
import com.illusivesoulworks.diet.api.util.DietColor;
import com.illusivesoulworks.diet.platform.Services;
import java.util.Objects;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;

public final class DietGroup
implements IDietGroup {
    private final String name;
    private final class_1792 icon;
    private final DietColor color;
    private final float defaultValue;
    private final int order;
    private final double gainMultiplier;
    private final double decayMultiplier;
    private final boolean beneficial;
    private final class_6862<class_1792> tag;

    private DietGroup(Builder builder) {
        this.name = builder.name;
        this.icon = builder.icon;
        this.color = builder.color;
        this.defaultValue = builder.defaultValue;
        this.order = builder.order;
        this.gainMultiplier = builder.gainMultiplier;
        this.decayMultiplier = builder.decayMultiplier;
        this.beneficial = builder.beneficial;
        this.tag = class_6862.method_40092((class_5321)class_2378.field_25108, (class_2960)DietCommonMod.resource(this.name));
    }

    public static IDietGroup load(class_2487 tag) {
        String name = tag.method_10558("Name");
        String icon = tag.method_10558("Icon");
        class_1792 item = Services.REGISTRY.getItem(new class_2960(icon)).orElse(null);
        int order = tag.method_10550("Order");
        boolean beneficial = tag.method_10577("Beneficial");
        int color = tag.method_10550("Color");
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        Builder builder = new Builder(name);
        builder.icon(item);
        builder.order(order);
        builder.beneficial(beneficial);
        builder.color(new DietColor(r, g, b));
        builder.gainMultiplier((float)tag.method_10574("Gain"));
        builder.decayMultiplier((float)tag.method_10574("Decay"));
        return builder.build();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public class_1792 getIcon() {
        return this.icon;
    }

    @Override
    public DietColor getColor() {
        return this.color;
    }

    @Override
    public float getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public double getGainMultiplier() {
        return this.gainMultiplier;
    }

    @Override
    public double getDecayMultiplier() {
        return this.decayMultiplier;
    }

    @Override
    public boolean isBeneficial() {
        return this.beneficial;
    }

    @Override
    public class_6862<class_1792> getTag() {
        return this.tag;
    }

    @Override
    public boolean contains(class_1799 stack) {
        return stack.method_31573(this.tag);
    }

    @Override
    public class_2487 save() {
        class_2487 tag = new class_2487();
        tag.method_10582("Name", this.name);
        tag.method_10582("Icon", Services.REGISTRY.getItemKey(this.icon).toString());
        tag.method_10569("Order", this.order);
        tag.method_10556("Beneficial", this.beneficial);
        tag.method_10569("Color", this.color.getRGB());
        tag.method_10549("Gain", this.gainMultiplier);
        tag.method_10549("Decay", this.decayMultiplier);
        return tag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DietGroup dietGroup = (DietGroup)o;
        return this.name.equals(dietGroup.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public static class Builder {
        private final String name;
        private class_1792 icon = class_1802.field_8162;
        private DietColor color = new DietColor(255, 255, 255);
        private float defaultValue = 0.0f;
        private int order = 1;
        private float gainMultiplier = 1.0f;
        private float decayMultiplier = 1.0f;
        private boolean beneficial = true;

        public Builder(String name) {
            this.name = name;
        }

        public Builder icon(class_1792 icon) {
            this.icon = icon;
            return this;
        }

        public Builder color(DietColor color) {
            this.color = color;
            return this;
        }

        public Builder defaultValue(float defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder order(int order) {
            this.order = order;
            return this;
        }

        public Builder gainMultiplier(float gainMultiplier) {
            this.gainMultiplier = gainMultiplier;
            return this;
        }

        public Builder decayMultiplier(float decayMultiplier) {
            this.decayMultiplier = decayMultiplier;
            return this;
        }

        public Builder beneficial(boolean beneficial) {
            this.beneficial = beneficial;
            return this;
        }

        public IDietGroup build() {
            return new DietGroup(this);
        }
    }
}

