/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.ai;

import com.dainxt.dungeonsmod.interfaces.IMultiTargetEntity;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.AxisAlignedBB;

public class AIMultipleTargetGoal<T extends LivingEntity>
extends Goal {
    protected final MobEntity goalOwner;
    protected final Class<T> targetClass;
    protected List<LivingEntity> nearestTargets;
    protected final boolean shouldCheckSight;
    protected int unseenMemoryTicks = 60;
    private int targetUnseenTicks;

    public <A extends MobEntity> AIMultipleTargetGoal(A goalOwnerIn, Class<T> targetClassIn) {
        this(goalOwnerIn, targetClassIn, false);
    }

    public <A extends MobEntity> AIMultipleTargetGoal(A goalOwnerIn, Class<T> targetClassIn, boolean checkSight) {
        this.goalOwner = goalOwnerIn;
        this.shouldCheckSight = checkSight;
        this.targetClass = targetClassIn;
        this.func_220684_a(EnumSet.of(Goal.Flag.TARGET));
    }

    public boolean func_75250_a() {
        this.findNearestTarget();
        return !this.nearestTargets.isEmpty();
    }

    public void func_75249_e() {
        super.func_75249_e();
        if (this.goalOwner instanceof IMultiTargetEntity) {
            IMultiTargetEntity multiTargeter = (IMultiTargetEntity)this.goalOwner;
            multiTargeter.setAttackTargets(new ArrayList<LivingEntity>(this.nearestTargets));
        }
    }

    public boolean func_75253_b() {
        boolean shouldContinue = false;
        if (this.goalOwner instanceof IMultiTargetEntity) {
            IMultiTargetEntity multiTargeter = (IMultiTargetEntity)this.goalOwner;
            for (LivingEntity livingentity : multiTargeter.getAttackTargets()) {
                if (livingentity == null || !livingentity.func_70089_S()) continue;
                Team team = this.goalOwner.func_96124_cp();
                Team team1 = livingentity.func_96124_cp();
                if (team != null && team1 == team) continue;
                double d0 = this.getTargetDistance();
                if (this.goalOwner.func_70068_e((Entity)livingentity) > d0 * d0) continue;
                if (this.shouldCheckSight) {
                    if (this.goalOwner.func_70635_at().func_75522_a((Entity)livingentity)) {
                        this.targetUnseenTicks = 0;
                    } else if (++this.targetUnseenTicks > this.unseenMemoryTicks) continue;
                }
                if (livingentity instanceof PlayerEntity && ((PlayerEntity)livingentity).field_71075_bZ.field_75102_a) continue;
                shouldContinue = true;
            }
        }
        return shouldContinue;
    }

    public void func_75251_c() {
        if (this.goalOwner instanceof IMultiTargetEntity) {
            IMultiTargetEntity multiTargeter = (IMultiTargetEntity)this.goalOwner;
            multiTargeter.setAttackTargets(new ArrayList<LivingEntity>());
        }
        this.nearestTargets.clear();
    }

    protected void findNearestTarget() {
        this.nearestTargets = this.goalOwner.field_70170_p.func_225316_b(this.targetClass, this.getTargetableArea(this.getTargetDistance()), EntityPredicates.field_188444_d);
    }

    protected double getTargetDistance() {
        return this.goalOwner.func_233637_b_(Attributes.field_233819_b_);
    }

    protected AxisAlignedBB getTargetableArea(double targetDistance) {
        return this.goalOwner.func_174813_aQ().func_72314_b(targetDistance, 4.0, targetDistance);
    }
}

