/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.block;

import com.dainxt.dungeonsmod.block.BlockBase;
import com.dainxt.dungeonsmod.tileentity.WardshiperTileEntity;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.item.LeashKnotEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class WardshiperBlock
extends BlockBase
implements ITileEntityProvider {
    public static final IntegerProperty PROPERTY_STAGE = BlockStateProperties.field_208137_al;

    public WardshiperBlock(String name) {
        super(name, AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_151663_o).func_226896_b_().func_200947_a(SoundType.field_185848_a).func_200944_c().func_200948_a(1.5f, 6.0f));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)PROPERTY_STAGE, (Comparable)Integer.valueOf(0)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{PROPERTY_STAGE});
    }

    public boolean func_149653_t(BlockState state) {
        return true;
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        TileEntity te;
        super.func_225534_a_(state, worldIn, pos, rand);
        if (!worldIn.field_72995_K && (te = worldIn.func_175625_s(pos)) instanceof WardshiperTileEntity && WardshiperBlock.isTotemBuilded((World)worldIn, pos)) {
            if ((Integer)state.func_177229_b((Property)PROPERTY_STAGE) == 0) {
                List leashes = worldIn.func_217357_a(LeashKnotEntity.class, new AxisAlignedBB(pos).func_72314_b(1.0, 0.0, 1.0));
                List nearMobs = worldIn.func_217357_a(MobEntity.class, new AxisAlignedBB(pos).func_72314_b(7.0, 7.0, 7.0));
                Optional<MobEntity> target2 = nearMobs.stream().filter(nearMob -> nearMob.func_233580_cy_().equals((Object)pos.func_177984_a())).findAny();
                if (target2.isPresent() && target2.get() != null) {
                    nearMobs.removeIf(leashedMob -> !leashes.contains(leashedMob.func_110166_bE()));
                    double resultHealth = 0.0;
                    if (nearMobs.size() == 4) {
                        resultHealth = nearMobs.stream().mapToDouble(sacrifice -> sacrifice.func_110143_aJ()).sum();
                    }
                    resultHealth /= 2.0;
                    if ((double)target2.get().func_110138_aP() <= resultHealth) {
                        ((WardshiperTileEntity)te).setTarget(target2.get().func_200600_R());
                        ((WardshiperTileEntity)te).setUsesLeft(1000);
                        worldIn.func_175690_a(pos, te);
                        nearMobs.forEach(sacrifice -> sacrifice.func_70097_a(DamageSource.field_76376_m, sacrifice.func_110138_aP()));
                        target2.get().func_70097_a(DamageSource.field_76376_m, target2.get().func_110138_aP());
                        worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)PROPERTY_STAGE, (Comparable)Integer.valueOf(1)));
                    }
                }
            } else if (((WardshiperTileEntity)te).getUsesLeft() > 0) {
                List nearMobs = worldIn.func_217357_a(MobEntity.class, new AxisAlignedBB(pos).func_72314_b(16.0, 16.0, 16.0));
                nearMobs.forEach(target -> {
                    if (target.func_200600_R() == ((WardshiperTileEntity)te).getTarget()) {
                        target.func_70097_a(DamageSource.field_76376_m, target.func_110138_aP());
                        ((WardshiperTileEntity)te).setUsesLeft(((WardshiperTileEntity)te).getUsesLeft() - 1);
                    }
                });
            }
            if (((WardshiperTileEntity)te).getUsesLeft() <= 0) {
                worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)PROPERTY_STAGE, (Comparable)Integer.valueOf(0)));
            }
        }
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        super.func_176199_a(worldIn, pos, entityIn);
        if (!worldIn.field_72995_K && WardshiperBlock.isTotemBuilded(worldIn, pos) && entityIn instanceof LivingEntity) {
            BlockState state = worldIn.func_180495_p(pos);
            if (entityIn.field_70173_aa % 20 == 0 && (Integer)state.func_177229_b((Property)PROPERTY_STAGE) == 0) {
                ((ServerWorld)worldIn).func_195598_a((IParticleData)ParticleTypes.field_239812_C_, entityIn.func_226277_ct_(), entityIn.func_226278_cu_() - 0.5, entityIn.func_226281_cx_(), 8, (worldIn.field_73012_v.nextDouble() - 0.5) * 2.0, -worldIn.field_73012_v.nextDouble(), (worldIn.field_73012_v.nextDouble() - 0.5) * 2.0, (double)0.05f);
            }
        }
    }

    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        super.func_180655_c(stateIn, worldIn, pos, rand);
        if ((Integer)stateIn.func_177229_b((Property)PROPERTY_STAGE) == 1) {
            for (int i = 0; i < 2; ++i) {
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197607_R, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, (worldIn.field_73012_v.nextDouble() - 0.5) * 8.0, -worldIn.field_73012_v.nextDouble(), (worldIn.field_73012_v.nextDouble() - 0.5) * 8.0);
            }
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    public static boolean isTotemBuilded(World world, BlockPos pos) {
        boolean isBuilded = true;
        isBuilded = world.func_180495_p(pos.func_177978_c()).func_177230_c().equals(Blocks.field_235351_mJ_) && isBuilded;
        isBuilded = world.func_180495_p(pos.func_177968_d()).func_177230_c().equals(Blocks.field_235351_mJ_) && isBuilded;
        isBuilded = world.func_180495_p(pos.func_177976_e()).func_177230_c().equals(Blocks.field_235351_mJ_) && isBuilded;
        isBuilded = world.func_180495_p(pos.func_177974_f()).func_177230_c().equals(Blocks.field_235351_mJ_) && isBuilded;
        isBuilded = world.func_180495_p(pos.func_177977_b()).func_177230_c().equals(Blocks.field_235392_nF_) && isBuilded;
        isBuilded = world.func_180495_p(pos.func_177979_c(2)).func_177230_c().equals(Blocks.field_235392_nF_) && isBuilded;
        isBuilded = world.func_180495_p(pos.func_177979_c(3)).func_177230_c().equals(Blocks.field_235410_nt_) && isBuilded;
        return isBuilded;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return super.func_220053_a(state, worldIn, pos, context);
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new WardshiperTileEntity();
    }
}

