/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.entity;

import com.dainxt.dungeonsmod.ai.AITimedAction;
import com.dainxt.dungeonsmod.config.DungeonsModConfig;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class EntityAnthermite
extends MonsterEntity {
    public EntityAnthermite(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_98053_h(true);
        this.field_70728_aV = 1;
    }

    protected ResourceLocation func_184647_J() {
        return DungeonsModConfig.COMMON.anthermite.getLootTable();
    }

    public static boolean canSpawn(EntityType<? extends MonsterEntity> type, IWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return MonsterEntity.func_223324_d(type, (IWorld)worldIn, (SpawnReason)reason, (BlockPos)pos, (Random)randomIn);
    }

    public boolean haveSugar() {
        return this.func_184582_a(EquipmentSlotType.MAINHAND).func_77973_b() == Items.field_151102_aT;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new AIDoNothing(this, 120, 20));
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
    }

    public static AttributeModifierMap.MutableAttribute createMobAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 2.0).func_233815_a_(Attributes.field_233823_f_, 0.2).func_233815_a_(Attributes.field_233821_d_, 0.3).func_233815_a_(Attributes.field_233819_b_, 40.0).func_233815_a_(Attributes.field_233826_i_, 1.0);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = super.func_70652_k(entityIn);
        if (flag) {
            if (this.func_70681_au().nextInt(10) == 0) {
                entityIn.func_70015_d(1);
            }
            if (entityIn instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)entityIn;
                ItemStack stackOnHand = player.field_71071_by.func_70448_g();
                if (!stackOnHand.func_190926_b() && !this.haveSugar() && stackOnHand.func_77973_b() == Items.field_151102_aT) {
                    ItemStack robbedStack = stackOnHand.func_77946_l();
                    robbedStack.func_190920_e(1);
                    this.func_184201_a(EquipmentSlotType.MAINHAND, robbedStack);
                    stackOnHand.func_190918_g(1);
                }
            }
        }
        return flag;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K && this.func_70681_au().nextInt(20) == 0) {
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197617_j, this.func_226282_d_(0.5), this.func_226279_cv_() - 0.25, this.func_226287_g_(0.5), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
            }
        }
        if (this.func_70090_H()) {
            this.func_70097_a(DamageSource.field_76369_e, (float)this.func_110148_a(Attributes.field_233818_a_).func_111126_e());
        }
    }

    protected void func_175445_a(ItemEntity itemEntity) {
        ItemStack itemstack = itemEntity.func_92059_d();
        if (!this.haveSugar() && itemstack.func_77973_b() == Items.field_151102_aT) {
            this.func_71001_a((Entity)itemEntity, itemstack.func_190916_E());
            this.func_184201_a(EquipmentSlotType.MAINHAND, itemstack);
            itemEntity.func_70106_y();
            ItemStack excessStack = itemstack.func_77946_l();
            if (excessStack.func_190916_E() > 1) {
                excessStack.func_190918_g(1);
                this.func_70099_a(excessStack, 0.0f);
            }
        }
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * 0.7f;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187646_bt;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187646_bt;
    }

    public float func_205022_a(BlockPos pos, IWorldReader worldIn) {
        return 0.0f;
    }

    class AIDoNothing
    extends AITimedAction {
        EntityAnthermite anthermite;

        public AIDoNothing(EntityAnthermite entity, int maxDuration, int maxCooldown) {
            super((LivingEntity)entity, maxDuration, maxCooldown);
            this.anthermite = entity;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        @Override
        public boolean func_75250_a() {
            return this.anthermite.haveSugar();
        }

        @Override
        public boolean func_75253_b() {
            boolean flag;
            boolean bl = flag = !super.func_75253_b();
            if (flag) {
                this.attacker.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
            }
            return this.anthermite.haveSugar();
        }
    }
}

