/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.entity;

import com.dainxt.dungeonsmod.handlers.EntityRegistries;
import com.dainxt.dungeonsmod.interfaces.IEntityExtraPart;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class EntityExtraPart
extends MobEntity {
    private static final DataParameter<Integer> PARTTYPE = EntityDataManager.func_187226_a(EntityExtraPart.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<String> NAME = EntityDataManager.func_187226_a(EntityExtraPart.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Integer> PARENT_ID = EntityDataManager.func_187226_a(EntityExtraPart.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> ATTACKTARGET_ID = EntityDataManager.func_187226_a(EntityExtraPart.class, (IDataSerializer)DataSerializers.field_187192_b);
    private String cachedUniqueIdParent = null;

    public EntityExtraPart(EntityType<? extends MobEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_110163_bv();
    }

    public EntityExtraPart(MobEntity parent, String name, float p_i50232_3_, float p_i50232_4_) {
        super(EntityRegistries.EXTRAPART, parent.field_70170_p);
        this.setParentID(parent.func_145782_y());
        this.cachedUniqueIdParent = parent.func_110124_au().toString();
        this.setPartName(name);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PARTTYPE, (Object)-1);
        this.field_70180_af.func_187214_a(NAME, (Object)String.valueOf("None"));
        this.field_70180_af.func_187214_a(PARENT_ID, (Object)-1);
        this.field_70180_af.func_187214_a(ATTACKTARGET_ID, (Object)-1);
    }

    public void setPartType(ExtraPartType type) {
        this.func_184212_Q().func_187227_b(PARTTYPE, (Object)type.getIndex());
    }

    public ExtraPartType getPartType() {
        return ExtraPartType.byIndex((Integer)this.func_184212_Q().func_187225_a(PARTTYPE));
    }

    public EntityExtraPart setParentID(int bindedPlayer) {
        if (!this.field_70170_p.field_72995_K && bindedPlayer < 0) {
            this.cachedUniqueIdParent = null;
        }
        this.func_184212_Q().func_187227_b(PARENT_ID, (Object)bindedPlayer);
        return this;
    }

    public int getParentID() {
        return (Integer)this.func_184212_Q().func_187225_a(PARENT_ID);
    }

    public void func_70624_b(LivingEntity entitylivingbaseIn) {
        super.func_70624_b(entitylivingbaseIn);
        this.func_184212_Q().func_187227_b(ATTACKTARGET_ID, (Object)(entitylivingbaseIn == null ? -1 : entitylivingbaseIn.func_145782_y()));
    }

    public LivingEntity func_70638_az() {
        return (LivingEntity)this.field_70170_p.func_73045_a(((Integer)this.func_184212_Q().func_187225_a(ATTACKTARGET_ID)).intValue());
    }

    public EntityExtraPart setPartName(String bindedPlayer) {
        this.func_184212_Q().func_187227_b(NAME, (Object)String.valueOf(bindedPlayer));
        return this;
    }

    public String getPartName() {
        return ((String)this.func_184212_Q().func_187225_a(NAME)).toString();
    }

    public boolean isAlivePart() {
        return this.func_110143_aJ() > 1.0f;
    }

    public static AttributeModifierMap.MutableAttribute createMobAttributes() {
        return MobEntity.func_233666_p_();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.equals(DamageSource.field_76368_d)) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        ILivingEntityData data = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        if (data != null) {
            this.setPartType(((GroupData)data).partType);
            if (((GroupData)data).partType == ExtraPartType.TENTACLE) {
                this.func_110148_a(Attributes.field_233818_a_).func_111128_a(40.0);
                this.func_110148_a(Attributes.field_233826_i_).func_111128_a(10.0);
                this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.0);
                this.func_110148_a(Attributes.field_233820_c_).func_111128_a(1.0);
                this.func_70606_j(this.func_110138_aP());
            }
            if (((GroupData)data).partType == ExtraPartType.VOIDHAND) {
                this.field_70759_as = 270.0f;
            }
        }
        return data;
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setPartType(ExtraPartType.byIndex(compound.func_74762_e("PartType")));
        this.setPartName(compound.func_74779_i("PartName"));
        if (!this.field_70170_p.field_72995_K) {
            this.cachedUniqueIdParent = !compound.func_74779_i("BindedEntityUUID").isEmpty() ? compound.func_74779_i("BindedEntityUUID") : null;
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("PartType", this.getPartType().getIndex());
        compound.func_74778_a("PartName", this.getPartName());
        if (!this.field_70170_p.field_72995_K && this.cachedUniqueIdParent != null) {
            compound.func_74778_a("BindedEntityUUID", this.cachedUniqueIdParent);
        }
    }

    public boolean func_70648_aU() {
        return true;
    }

    public void func_70636_d() {
        Entity parent;
        super.func_70636_d();
        if (this.getParentID() != -1 && (parent = this.field_70170_p.func_73045_a(this.getParentID())) instanceof IEntityExtraPart && !((IEntityExtraPart)parent).getParts().contains((Object)this) && this.func_70089_S()) {
            ((IEntityExtraPart)parent).getParts().add(this);
        }
    }

    public void func_70645_a(DamageSource cause) {
        Entity parent;
        if (this.getParentID() != -1 && (parent = this.field_70170_p.func_73045_a(this.getParentID())) instanceof IEntityExtraPart) {
            this.func_70606_j(1.0f);
            return;
        }
        super.func_70645_a(cause);
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.updateParentUUID();
    }

    public void updateParentUUID() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.cachedUniqueIdParent == null) {
                this.cachedUniqueIdParent = this.field_70170_p.func_73045_a(this.getParentID()) != null ? this.field_70170_p.func_73045_a(this.getParentID()).func_189512_bd() : null;
            } else if (((ServerWorld)this.field_70170_p).func_217461_a(UUID.fromString(this.cachedUniqueIdParent)) != null) {
                this.setParentID(((ServerWorld)this.field_70170_p).func_217461_a(UUID.fromString(this.cachedUniqueIdParent)).func_145782_y());
            }
        }
    }

    public boolean func_70028_i(Entity entityIn) {
        return this == entityIn || this.field_70170_p.func_73045_a(this.getParentID()) == entityIn;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected void func_82167_n(Entity entityIn) {
    }

    public boolean func_70104_M() {
        return false;
    }

    public void func_70623_bb() {
    }

    public static class GroupData
    implements ILivingEntityData {
        ExtraPartType partType;

        public GroupData(ExtraPartType partType) {
            this.partType = partType;
        }
    }

    public static enum ExtraPartType {
        NONE(-1),
        TENTACLE(0),
        VOIDHAND(1);

        private int index;

        private ExtraPartType(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public static ExtraPartType byIndex(int index) {
            for (ExtraPartType equipmentslottype : ExtraPartType.values()) {
                if (equipmentslottype.getIndex() != index) continue;
                return equipmentslottype;
            }
            return NONE;
        }
    }
}

