/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.entity;

import com.dainxt.dungeonsmod.config.DungeonsModConfig;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class EntityHaunter
extends MonsterEntity {
    public EntityHaunter(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70765_h = new MoveHelperController(this);
        this.field_70145_X = true;
    }

    protected ResourceLocation func_184647_J() {
        return DungeonsModConfig.COMMON.haunter.getLootTable();
    }

    public static boolean canSpawn(EntityType<? extends MonsterEntity> type, IWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        if (worldIn.func_226691_t_(pos).func_201856_r() == Biome.Category.SWAMP) {
            return MonsterEntity.func_223324_d(type, (IWorld)worldIn, (SpawnReason)reason, (BlockPos)pos, (Random)randomIn);
        }
        return false;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(2, (Goal)new AIAttack(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new RandomFlyGoal(this));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAroundGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 0, true, true, null));
    }

    public static AttributeModifierMap.MutableAttribute createMobAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 15.0).func_233815_a_(Attributes.field_233823_f_, 1.0).func_233815_a_(Attributes.field_233821_d_, 0.1).func_233815_a_(Attributes.field_233819_b_, 40.0).func_233815_a_(Attributes.field_233826_i_, 1.0);
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223223_b_;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public void func_70108_f(Entity entityIn) {
        super.func_70108_f(entityIn);
        if (entityIn instanceof LivingEntity && !(entityIn instanceof EntityHaunter)) {
            entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_110148_a(Attributes.field_233823_f_).func_111126_e());
        }
    }

    public void func_70100_b_(PlayerEntity entityIn) {
        super.func_70100_b_(entityIn);
        if (entityIn instanceof LivingEntity) {
            entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_110148_a(Attributes.field_233823_f_).func_111126_e());
        }
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void func_213352_e(Vector3d travelVector) {
        BlockPos ground = new BlockPos(this.func_226277_ct_(), this.func_226278_cu_() - 1.0, this.func_226281_cx_());
        float f = 0.65f;
        if (this.field_70122_E) {
            f = this.field_70170_p.func_180495_p(ground).getSlipperiness((IWorldReader)this.field_70170_p, ground, (Entity)this) * 0.91f;
        }
        float f1 = 0.16277137f / (f * f * f);
        f = 0.65f;
        if (this.field_70122_E) {
            f = this.field_70170_p.func_180495_p(ground).getSlipperiness((IWorldReader)this.field_70170_p, ground, (Entity)this) * 0.91f;
        }
        this.func_213309_a(this.field_70122_E ? 0.1f * f1 : 0.02f, travelVector);
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        this.func_213317_d(this.func_213322_ci().func_186678_a((double)f));
        this.func_233629_a_((LivingEntity)this, false);
    }

    static class MoveHelperController
    extends MovementController {
        private final EntityHaunter parentEntity;
        private int courseChangeCooldown;

        public MoveHelperController(EntityHaunter ghast) {
            super((MobEntity)ghast);
            this.parentEntity = ghast;
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.MOVE_TO && this.courseChangeCooldown-- <= 0) {
                this.courseChangeCooldown += this.parentEntity.func_70681_au().nextInt(5) + 2;
                Vector3d vector3d = new Vector3d(this.field_75646_b - this.parentEntity.func_226277_ct_(), this.field_75647_c - this.parentEntity.func_226278_cu_(), this.field_75644_d - this.parentEntity.func_226281_cx_());
                double d0 = vector3d.func_72433_c();
                vector3d = vector3d.func_72432_b();
                this.parentEntity.func_213317_d(this.parentEntity.func_213322_ci().func_178787_e(vector3d.func_186678_a(0.1)));
            }
        }
    }

    static class LookAroundGoal
    extends Goal {
        private final EntityHaunter parentEntity;

        public LookAroundGoal(EntityHaunter ghast) {
            this.parentEntity = ghast;
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            if (this.parentEntity.func_70638_az() == null) {
                Vector3d vector3d = this.parentEntity.func_213322_ci();
                this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)vector3d.field_72450_a, (double)vector3d.field_72449_c)) * 57.295776f;
            } else {
                LivingEntity livingentity = this.parentEntity.func_70638_az();
                double d0 = 64.0;
                if (livingentity.func_70068_e((Entity)this.parentEntity) < 4096.0) {
                    double d1 = livingentity.func_226277_ct_() - this.parentEntity.func_226277_ct_();
                    double d2 = livingentity.func_226281_cx_() - this.parentEntity.func_226281_cx_();
                    this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)d1, (double)d2)) * 57.295776f;
                }
            }
        }
    }

    static class RandomFlyGoal
    extends Goal {
        private final EntityHaunter parentEntity;

        public RandomFlyGoal(EntityHaunter ghast) {
            this.parentEntity = ghast;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            double d2;
            double d1;
            MovementController movementcontroller = this.parentEntity.func_70605_aq();
            if (!movementcontroller.func_75640_a()) {
                return true;
            }
            double d0 = movementcontroller.func_179917_d() - this.parentEntity.func_226277_ct_();
            double d3 = d0 * d0 + (d1 = movementcontroller.func_179919_e() - this.parentEntity.func_226278_cu_()) * d1 + (d2 = movementcontroller.func_179918_f() - this.parentEntity.func_226281_cx_()) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            Random random = this.parentEntity.func_70681_au();
            double d0 = this.parentEntity.func_226277_ct_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d1 = this.parentEntity.func_226278_cu_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 2.0f);
            double d2 = this.parentEntity.func_226281_cx_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.parentEntity.func_70605_aq().func_75642_a(d0, d1, d2, 1.0);
        }
    }

    static class AIAttack
    extends Goal {
        private final EntityHaunter parentEntity;
        public int attackTimer;

        public AIAttack(EntityHaunter Sun) {
            this.parentEntity = Sun;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return this.parentEntity.func_70638_az() != null;
        }

        public void func_75249_e() {
            this.attackTimer = 0;
        }

        public void func_75251_c() {
        }

        public void func_75246_d() {
            LivingEntity LivingEntity2 = this.parentEntity.func_70638_az();
            double d0 = 64.0;
            if (LivingEntity2.func_70068_e((Entity)this.parentEntity) < 4096.0 && this.parentEntity.func_70685_l((Entity)LivingEntity2)) {
                World world = this.parentEntity.field_70170_p;
                double d2 = LivingEntity2.func_226277_ct_();
                double d3 = LivingEntity2.func_226278_cu_();
                double d4 = LivingEntity2.func_226281_cx_();
                this.parentEntity.func_70605_aq().func_75642_a(d2, d3, d4, 0.5);
            }
        }
    }
}

