/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.entity;

import com.dainxt.dungeonsmod.block.WardshiperBlock;
import com.dainxt.dungeonsmod.config.DungeonsModConfig;
import com.dainxt.dungeonsmod.difficulty.DifficultyManager;
import com.dainxt.dungeonsmod.entity.EntityDeadhound;
import com.dainxt.dungeonsmod.entity.EntityHaunter;
import com.dainxt.dungeonsmod.handlers.EntityRegistries;
import com.dainxt.dungeonsmod.interfaces.IMultiTargetEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.BossInfo;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraft.world.server.ServerWorld;

public class EntityLordSkeleton
extends MonsterEntity
implements IMultiTargetEntity {
    DifficultyManager difficultyManager = new DifficultyManager();
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.GREEN, BossInfo.Overlay.PROGRESS).func_186741_a(true);
    public ArrayList<LivingEntity> otherAttackTargets = new ArrayList();

    public EntityLordSkeleton(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70728_aV = 500;
    }

    protected ResourceLocation func_184647_J() {
        return DungeonsModConfig.COMMON.lordskeleton.getLootTable();
    }

    public ItemEntity func_70099_a(ItemStack stack, float offsetY) {
        if (stack.func_77973_b() instanceof BlockItem && ((BlockItem)stack.func_77973_b()).func_179223_d() instanceof WardshiperBlock) {
            long totalPlayers = this.bossInfo.func_186757_c().stream().filter(EntityPredicates.field_188444_d).count();
            float totalChance = MathHelper.func_76131_a((float)((float)((Double)DungeonsModConfig.COMMON.legendaryLootChance.get() * (double)totalPlayers)), (float)0.0f, (float)100.0f);
            if (this.field_70170_p.func_201674_k().nextFloat() < totalChance / 100.0f) {
                return super.func_70099_a(stack, offsetY);
            }
            return super.func_70099_a(ItemStack.field_190927_a, offsetY);
        }
        return super.func_70099_a(stack, offsetY);
    }

    public static boolean canSpawn(EntityType<? extends MonsterEntity> type, IWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        if (worldIn.func_226691_t_(pos).func_201856_r() == Biome.Category.SWAMP) {
            return MonsterEntity.func_223324_d(type, (IWorld)worldIn, (SpawnReason)reason, (BlockPos)pos, (Random)randomIn);
        }
        if (randomIn.nextInt(30) == 0) {
            return MonsterEntity.func_223324_d(type, (IWorld)worldIn, (SpawnReason)reason, (BlockPos)pos, (Random)randomIn);
        }
        return false;
    }

    public static AttributeModifierMap.MutableAttribute createMobAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 195.0).func_233815_a_(Attributes.field_233823_f_, 18.0).func_233815_a_(Attributes.field_233821_d_, 0.3).func_233815_a_(Attributes.field_233819_b_, 40.0).func_233815_a_(Attributes.field_233826_i_, 20.0);
    }

    public boolean func_70648_aU() {
        return true;
    }

    @Override
    public void setAttackTargets(ArrayList<LivingEntity> players) {
        this.otherAttackTargets = players;
    }

    @Override
    public ArrayList<LivingEntity> getAttackTargets() {
        return this.otherAttackTargets;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 0, true, true, (Predicate)((com.google.common.base.Predicate)null)));
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223223_b_;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    public boolean func_184222_aU() {
        return false;
    }

    protected void func_70619_bc() {
        ServerWorld serverworld;
        MonsterEntity traveler;
        super.func_70619_bc();
        if (((Boolean)DungeonsModConfig.COMMON.scalingDifficulty.get()).booleanValue()) {
            this.difficultyManager.adjustDifficulty((LivingEntity)this, 0.5f, 0.5f, 0.5f, 0.5f, this.bossInfo.func_186757_c());
        }
        if (this.field_70173_aa % 300 == 0 && !this.field_70170_p.field_72995_K) {
            for (PlayerEntity player : this.bossInfo.func_186757_c()) {
                if (player.func_184812_l_() || player.func_175149_v()) continue;
                traveler = new EntityHaunter(EntityRegistries.HAUNTER, this.field_70170_p);
                serverworld = (ServerWorld)this.field_70170_p;
                traveler.func_70012_b(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0f, 0.0f);
                traveler.func_213386_a((IServerWorld)serverworld, this.field_70170_p.func_175649_E(traveler.func_233580_cy_()), SpawnReason.MOB_SUMMONED, (ILivingEntityData)null, (CompoundNBT)null);
                traveler.func_70624_b((LivingEntity)player);
                this.field_70170_p.func_217376_c((Entity)traveler);
            }
        }
        if (this.field_70173_aa % 400 == 0 && !this.field_70170_p.field_72995_K) {
            for (PlayerEntity player : this.bossInfo.func_186757_c()) {
                if (player.func_184812_l_() || player.func_175149_v()) continue;
                traveler = new EntityDeadhound(EntityRegistries.DEADHOUND, this.field_70170_p);
                serverworld = (ServerWorld)this.field_70170_p;
                traveler.func_70012_b(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0f, 0.0f);
                traveler.func_213386_a((IServerWorld)serverworld, this.field_70170_p.func_175649_E(traveler.func_233580_cy_()), SpawnReason.MOB_SUMMONED, (ILivingEntityData)null, (CompoundNBT)null);
                this.field_70170_p.func_217376_c((Entity)traveler);
                traveler.func_70624_b((LivingEntity)player);
                this.field_70170_p.func_184134_a(traveler.func_226277_ct_(), traveler.func_226278_cu_(), traveler.func_226281_cx_(), SoundEvents.field_189111_gN, SoundCategory.HOSTILE, 1.0f, 5.0f, false);
            }
        }
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
        if (this.bossInfo.func_186757_c().isEmpty()) {
            this.func_70606_j((float)this.func_110148_a(Attributes.field_233818_a_).func_111125_b());
        }
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public List<ServerPlayerEntity> getPlayers() {
        return this.bossInfo.func_186757_c().stream().filter(EntityPredicates.field_188444_d).collect(Collectors.toList());
    }

    public boolean func_104002_bU() {
        return !this.bossInfo.func_186757_c().isEmpty();
    }

    public void func_70623_bb() {
        if (this.bossInfo.func_186757_c().isEmpty()) {
            super.func_70623_bb();
        }
    }
}

