/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.entity;

import com.dainxt.dungeonsmod.config.DungeonsModConfig;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.loot.LootTables;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class EntityMimic
extends MonsterEntity {
    private static final DataParameter<Boolean> WAITING = EntityDataManager.func_187226_a(EntityMimic.class, (IDataSerializer)DataSerializers.field_187198_h);

    public EntityMimic(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70728_aV = 7;
        this.field_70765_h = new MoveHelperController(this);
    }

    protected ResourceLocation func_184647_J() {
        return this.func_70681_au().nextInt(20) == 0 ? LootTables.field_186422_d : DungeonsModConfig.COMMON.mimic.getLootTable();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(WAITING, (Object)false);
    }

    public void setWaiting(boolean isWaiting) {
        this.func_184212_Q().func_187227_b(WAITING, (Object)isWaiting);
    }

    public boolean isWaiting() {
        return (Boolean)this.func_184212_Q().func_187225_a(WAITING);
    }

    public static boolean canSpawn(EntityType<? extends MonsterEntity> type, IWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return randomIn.nextInt(20) == 0 && MonsterEntity.func_223324_d(type, (IWorld)worldIn, (SpawnReason)reason, (BlockPos)pos, (Random)randomIn);
    }

    public boolean func_241845_aY() {
        return this.func_70089_S();
    }

    public void func_70100_b_(PlayerEntity entityIn) {
        super.func_70100_b_(entityIn);
        if (!this.isWaiting()) {
            this.func_70652_k((Entity)entityIn);
        }
    }

    public void func_70108_f(Entity entityIn) {
        super.func_70108_f(entityIn);
        if (!this.isWaiting()) {
            this.func_70652_k(entityIn);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        PlayerEntity player;
        if (source.func_76346_g() instanceof PlayerEntity && (player = (PlayerEntity)source.func_76346_g()).func_184614_ca().getToolTypes().contains(ToolType.AXE)) {
            return super.func_70097_a(source, amount * 1.25f);
        }
        return super.func_70097_a(source, amount);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new WaitGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new HideGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new AttackGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new FaceRandomGoal(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new HopGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
    }

    public static AttributeModifierMap.MutableAttribute createMobAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 10.0).func_233815_a_(Attributes.field_233823_f_, 20.0).func_233815_a_(Attributes.field_233821_d_, 0.5).func_233815_a_(Attributes.field_233819_b_, 5.0).func_233815_a_(Attributes.field_233826_i_, 30.0);
    }

    public void func_70020_e(CompoundNBT compound) {
        super.func_70020_e(compound);
        this.setWaiting(compound.func_74767_n("Waiting"));
    }

    public CompoundNBT func_189511_e(CompoundNBT compound) {
        compound.func_74757_a("Waiting", this.isWaiting());
        return super.func_189511_e(compound);
    }

    private void faceBlockPos(BlockPos pos) {
        float f1;
        double d0 = (double)pos.func_177958_n() - this.func_226277_ct_();
        double d2 = (double)pos.func_177952_p() - this.func_226281_cx_();
        double d1 = (double)pos.func_177956_o() - this.func_226278_cu_();
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
        this.field_70125_A = f1 = (float)(-(MathHelper.func_181159_b((double)d1, (double)d3) * 57.29577951308232));
        this.field_70177_z = f;
    }

    public ActionResultType func_184199_a(PlayerEntity player, Vector3d vec, Hand hand) {
        this.func_70624_b((LivingEntity)player);
        return super.func_184199_a(player, vec, hand);
    }

    public int getJumpDelay() {
        return 10;
    }

    public boolean makesSoundOnJump() {
        return true;
    }

    public boolean canDamagePlayer() {
        return true;
    }

    protected float func_175134_bD() {
        return 0.3f;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187889_gU;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187887_gT;
    }

    protected SoundEvent getJumpSound() {
        return SoundEvents.field_187657_V;
    }

    static class MoveHelperController
    extends MovementController {
        private float yRot;
        private int jumpDelay;
        private final EntityMimic slime;
        private boolean isAggressive;

        public MoveHelperController(EntityMimic slimeIn) {
            super((MobEntity)slimeIn);
            this.slime = slimeIn;
            this.yRot = 180.0f * slimeIn.field_70177_z / (float)Math.PI;
        }

        public void setDirection(float yRotIn, boolean aggressive) {
            this.yRot = yRotIn;
            this.isAggressive = aggressive;
        }

        public void setSpeed(double speedIn) {
            this.field_75645_e = speedIn;
            this.field_188491_h = MovementController.Action.MOVE_TO;
        }

        public void func_75641_c() {
            this.field_75648_a.field_70759_as = this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, this.yRot, 90.0f);
            this.field_75648_a.field_70761_aq = this.field_75648_a.field_70177_z;
            if (this.field_188491_h != MovementController.Action.MOVE_TO) {
                this.field_75648_a.func_191989_p(0.0f);
            } else {
                this.field_188491_h = MovementController.Action.WAIT;
                if (this.field_75648_a.func_233570_aj_()) {
                    this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_233637_b_(Attributes.field_233821_d_)));
                    if (this.jumpDelay-- <= 0) {
                        this.jumpDelay = this.slime.getJumpDelay();
                        if (this.isAggressive) {
                            this.jumpDelay /= 3;
                        }
                        this.slime.func_70683_ar().func_75660_a();
                        if (this.slime.makesSoundOnJump()) {
                            this.slime.func_184185_a(this.slime.getJumpSound(), this.slime.func_70599_aP() * 0.2f, 1.0f);
                        }
                    } else {
                        this.slime.field_70702_br = 0.0f;
                        this.slime.field_191988_bg = 0.0f;
                        this.field_75648_a.func_70659_e(0.0f);
                    }
                } else {
                    this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_233637_b_(Attributes.field_233821_d_)));
                }
            }
        }
    }

    static class HopGoal
    extends Goal {
        private final EntityMimic slime;

        public HopGoal(EntityMimic slimeIn) {
            this.slime = slimeIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return !this.slime.func_184218_aH();
        }

        public void func_75246_d() {
            if (this.slime.func_70605_aq() instanceof MoveHelperController) {
                ((MoveHelperController)this.slime.func_70605_aq()).setSpeed(1.0);
            }
        }
    }

    static class FaceRandomGoal
    extends Goal {
        private final EntityMimic slime;
        private float chosenDegrees;
        private int nextRandomizeTime;

        public FaceRandomGoal(EntityMimic slimeIn) {
            this.slime = slimeIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return this.slime.func_70638_az() == null && (this.slime.field_70122_E || this.slime.func_70090_H() || this.slime.func_180799_ab() || this.slime.func_70644_a(Effects.field_188424_y)) && this.slime.func_70605_aq() instanceof MoveHelperController;
        }

        public void func_75246_d() {
            if (--this.nextRandomizeTime <= 0) {
                this.nextRandomizeTime = 40 + this.slime.func_70681_au().nextInt(60);
                this.chosenDegrees = this.slime.func_70681_au().nextInt(360);
            }
            if (this.slime.func_70605_aq() instanceof MoveHelperController) {
                ((MoveHelperController)this.slime.func_70605_aq()).setDirection(this.chosenDegrees, false);
            }
        }
    }

    static class AttackGoal
    extends Goal {
        private final EntityMimic slime;
        private int growTieredTimer;

        public AttackGoal(EntityMimic slimeIn) {
            this.slime = slimeIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            LivingEntity livingentity = this.slime.func_70638_az();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.func_70089_S()) {
                return false;
            }
            return livingentity instanceof PlayerEntity && ((PlayerEntity)livingentity).field_71075_bZ.field_75102_a ? false : this.slime.func_70605_aq() instanceof MoveHelperController;
        }

        public void func_75249_e() {
            this.growTieredTimer = 100;
            super.func_75249_e();
        }

        public boolean func_75253_b() {
            LivingEntity livingentity = this.slime.func_70638_az();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.func_70089_S()) {
                return false;
            }
            if (livingentity instanceof PlayerEntity && ((PlayerEntity)livingentity).field_71075_bZ.field_75102_a) {
                return false;
            }
            return --this.growTieredTimer > 0;
        }

        public void func_75246_d() {
            this.slime.func_70625_a((Entity)this.slime.func_70638_az(), 10.0f, 10.0f);
            if (this.slime.func_70605_aq() instanceof MoveHelperController) {
                ((MoveHelperController)this.slime.func_70605_aq()).setDirection(this.slime.field_70177_z, this.slime.canDamagePlayer());
            }
        }
    }

    static class HideGoal
    extends Goal {
        private final EntityMimic slime;
        Direction direction;

        public HideGoal(EntityMimic slimeIn) {
            this.slime = slimeIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return this.slime.func_70638_az() == null;
        }

        public void func_75249_e() {
            super.func_75249_e();
            this.slime.func_70107_b((double)MathHelper.func_76128_c((double)this.slime.func_226277_ct_()) + 0.5, this.slime.func_226278_cu_(), (double)MathHelper.func_76128_c((double)this.slime.func_226281_cx_()) + 0.5);
            this.direction = Direction.func_176731_b((int)this.slime.func_70681_au().nextInt(4));
        }

        public void getNewDirection() {
            this.direction = Direction.func_176731_b((int)this.slime.func_70681_au().nextInt(4));
        }

        public boolean func_75253_b() {
            boolean flag = this.slime.field_70170_p.func_180495_p(this.slime.func_233580_cy_().func_177972_a(this.direction)).func_200132_m();
            if (flag) {
                if (this.slime.func_70605_aq() instanceof MoveHelperController) {
                    ((MoveHelperController)this.slime.func_70605_aq()).setDirection(this.slime.field_70177_z + 180.0f, this.slime.canDamagePlayer());
                }
                this.slime.setWaiting(true);
            }
            return !flag;
        }

        public void func_75246_d() {
            List frontEntities = this.slime.field_70170_p.func_217357_a(LivingEntity.class, new AxisAlignedBB(this.slime.func_233580_cy_().func_177972_a(this.direction)));
            if (!frontEntities.isEmpty()) {
                for (Entity entity : frontEntities) {
                    if (entity.func_70028_i((Entity)this.slime)) continue;
                    this.getNewDirection();
                    break;
                }
            }
            if (this.slime.func_70605_aq() instanceof MoveHelperController) {
                ((MoveHelperController)this.slime.func_70605_aq()).setDirection(this.direction.func_185119_l(), this.slime.canDamagePlayer());
            }
        }
    }

    static class WaitGoal
    extends Goal {
        private final EntityMimic slime;

        public WaitGoal(EntityMimic slimeIn) {
            this.slime = slimeIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public void func_75249_e() {
            super.func_75249_e();
            this.slime.func_70107_b((double)MathHelper.func_76128_c((double)this.slime.func_226277_ct_()) + 0.5, this.slime.func_226278_cu_(), (double)MathHelper.func_76128_c((double)this.slime.func_226281_cx_()) + 0.5);
        }

        public boolean func_75250_a() {
            return this.slime.isWaiting();
        }

        public boolean func_75253_b() {
            boolean flag;
            boolean bl = flag = this.slime.func_70638_az() == null;
            if (!flag) {
                this.slime.setWaiting(false);
            }
            return flag;
        }
    }
}

