/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.entity;

import com.dainxt.dungeonsmod.config.DungeonsModConfig;
import com.google.common.collect.Sets;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityPice
extends TameableEntity {
    private static final Set<Item> TAME_ITEMS = Sets.newHashSet((Object[])new Item[]{Items.field_221770_cu, Items.field_221638_ag});

    public EntityPice(EntityType<? extends TameableEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70728_aV = 5;
    }

    protected ResourceLocation func_184647_J() {
        return DungeonsModConfig.COMMON.pice.getLootTable();
    }

    public static boolean canSpawn(EntityType<? extends TameableEntity> type, IWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return AnimalEntity.func_223316_b(type, (IWorld)worldIn, (SpawnReason)reason, (BlockPos)pos, (Random)randomIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(6, (Goal)new FollowOwnerGoal((TameableEntity)this, 1.0, 10.0f, 2.0f, false));
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    public static AttributeModifierMap.MutableAttribute createMobAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 50.0).func_233815_a_(Attributes.field_233823_f_, 0.2).func_233815_a_(Attributes.field_233821_d_, 0.15).func_233815_a_(Attributes.field_233819_b_, 40.0).func_233815_a_(Attributes.field_233826_i_, 5.0);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76346_g() != null && source.func_76364_f() instanceof LivingEntity) {
            source.func_76364_f().func_70097_a(DamageSource.func_92087_a((Entity)this), 1.0f);
            if (source.func_76346_g() != null) {
                if (this.func_70902_q() instanceof PlayerEntity && source.func_76346_g().func_110124_au() != this.func_184753_b() && this.field_70146_Z.nextInt(3) == 0) {
                    this.func_70902_q().func_195064_c(new EffectInstance(Effects.field_76429_m, 60, 0));
                }
                if (this.func_70902_q() instanceof PlayerEntity) {
                    // empty if block
                }
            }
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = super.func_70652_k(entityIn);
        if (flag) {
            // empty if block
        }
        return flag;
    }

    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        return null;
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.func_110148_a(Attributes.field_233821_d_).func_111128_a((double)0.15f);
        if (this.func_70090_H()) {
            this.func_70097_a(DamageSource.field_76369_e, (float)this.func_110148_a(Attributes.field_233818_a_).func_111126_e());
        }
    }

    public ActionResultType func_230254_b_(PlayerEntity p_230254_1_, Hand p_230254_2_) {
        ItemStack itemstack = p_230254_1_.func_184586_b(p_230254_2_);
        if (!this.func_70909_n() && TAME_ITEMS.contains(itemstack.func_77973_b())) {
            if (!p_230254_1_.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            if (!this.func_174814_R()) {
                this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187561_bM, this.func_184176_by(), 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.field_70146_Z.nextInt(10) == 0 && !ForgeEventFactory.onAnimalTame((AnimalEntity)this, (PlayerEntity)p_230254_1_)) {
                    this.func_193101_c(p_230254_1_);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                } else {
                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                }
            }
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        if (this.func_70909_n() && this.func_152114_e((LivingEntity)p_230254_1_)) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_233687_w_(!this.func_233685_eM_());
                if (TAME_ITEMS.contains(itemstack.func_77973_b()) && this.func_110143_aJ() < this.func_110138_aP()) {
                    if (!this.field_70170_p.field_72995_K) {
                        if (!p_230254_1_.field_71075_bZ.field_75098_d) {
                            itemstack.func_190918_g(1);
                        }
                        this.func_70691_i(10.0f);
                        this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                    }
                    return ActionResultType.SUCCESS;
                }
            }
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return super.func_230254_b_(p_230254_1_, p_230254_2_);
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * 0.7f;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187561_bM;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187661_by;
    }

    public float func_205022_a(BlockPos pos, IWorldReader worldIn) {
        return 0.0f;
    }
}

