/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.entity;

import com.dainxt.dungeonsmod.config.DungeonsModConfig;
import com.dainxt.dungeonsmod.handlers.ItemRegistries;
import java.util.EnumSet;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.LookController;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.fish.AbstractFishEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class EntityPiranha
extends AbstractFishEntity {
    protected RandomWalkingGoal wander;

    public EntityPiranha(EntityType<? extends AbstractFishEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70765_h = new MoveHelperController(this);
    }

    protected ResourceLocation func_184647_J() {
        return DungeonsModConfig.COMMON.piranha.getLootTable();
    }

    public static boolean canSpawn(EntityType<? extends EntityPiranha> p_223329_0_, IWorld p_223329_1_, SpawnReason reason, BlockPos p_223329_3_, Random p_223329_4_) {
        return !(p_223329_4_.nextInt(60) != 0 && p_223329_1_.func_175710_j(p_223329_3_) || p_223329_1_.func_175659_aa() == Difficulty.PEACEFUL || reason != SpawnReason.SPAWNER && !p_223329_1_.func_204610_c(p_223329_3_).func_206884_a((ITag)FluidTags.field_206959_a));
    }

    public static AttributeModifierMap.MutableAttribute createMobAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 3.0).func_233815_a_(Attributes.field_233823_f_, 0.2).func_233815_a_(Attributes.field_233821_d_, 1.0).func_233815_a_(Attributes.field_233819_b_, 10.0);
    }

    protected void func_82167_n(Entity entityIn) {
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.func_70638_az() != null) {
            Vector3d vec = this.func_70638_az().func_213303_ch();
            this.func_70671_ap().func_220674_a(vec);
            this.func_70107_b(vec.field_72450_a, vec.field_72448_b + (double)this.func_70638_az().func_70047_e(), vec.field_72449_c);
        }
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        if (this.func_70638_az() != null) {
            this.func_70691_i(0.8f);
            return super.func_225503_b_(MathHelper.func_76131_a((float)distance, (float)0.0f, (float)4.0f), damageMultiplier);
        }
        return super.func_225503_b_(distance, damageMultiplier);
    }

    protected void func_184651_r() {
        MoveTowardsRestrictionGoal movetowardsrestrictiongoal = new MoveTowardsRestrictionGoal((CreatureEntity)this, 1.0);
        this.wander = new RandomWalkingGoal((CreatureEntity)this, 1.0, 80);
        this.field_70714_bg.func_75776_a(4, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (Goal)movetowardsrestrictiongoal);
        this.field_70714_bg.func_75776_a(7, (Goal)this.wander);
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, EntityPiranha.class, 12.0f, 0.01f));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.wander.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        movetowardsrestrictiongoal.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, LivingEntity.class, 10, true, true, (Predicate)new TargetPredicate(this)));
    }

    protected ItemStack func_203707_dx() {
        return new ItemStack((IItemProvider)ItemRegistries.PIRANHA_BUCKET);
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * 0.3f;
    }

    protected SoundEvent func_203701_dz() {
        return SoundEvents.field_203818_az;
    }

    static class TargetPredicate
    implements Predicate<LivingEntity> {
        private final EntityPiranha parentEntity;

        public TargetPredicate(EntityPiranha EntityPiranha2) {
            this.parentEntity = EntityPiranha2;
        }

        @Override
        public boolean test(@Nullable LivingEntity p_test_1_) {
            return p_test_1_ instanceof PlayerEntity && p_test_1_.func_70068_e((Entity)this.parentEntity) > 9.0;
        }
    }

    static class MoveHelperController
    extends MovementController {
        private final EntityPiranha entityGuardian;

        public MoveHelperController(EntityPiranha EntityPiranha2) {
            super((MobEntity)EntityPiranha2);
            this.entityGuardian = EntityPiranha2;
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.MOVE_TO && !this.entityGuardian.func_70661_as().func_75500_f()) {
                Vector3d vector3d = new Vector3d(this.field_75646_b - this.entityGuardian.func_226277_ct_(), this.field_75647_c - this.entityGuardian.func_226278_cu_(), this.field_75644_d - this.entityGuardian.func_226281_cx_());
                double d0 = vector3d.func_72433_c();
                double d1 = vector3d.field_72450_a / d0;
                double d2 = vector3d.field_72448_b / d0;
                double d3 = vector3d.field_72449_c / d0;
                float f = (float)(MathHelper.func_181159_b((double)vector3d.field_72449_c, (double)vector3d.field_72450_a) * 57.2957763671875) - 90.0f;
                this.entityGuardian.field_70761_aq = this.entityGuardian.field_70177_z = this.func_75639_a(this.entityGuardian.field_70177_z, f, 90.0f);
                float f1 = (float)(this.field_75645_e * this.entityGuardian.func_233637_b_(Attributes.field_233821_d_));
                float f2 = MathHelper.func_219799_g((float)0.125f, (float)this.entityGuardian.func_70689_ay(), (float)f1);
                this.entityGuardian.func_70659_e(f2);
                double d4 = Math.sin((double)(this.entityGuardian.field_70173_aa + this.entityGuardian.func_145782_y()) * 0.5) * 0.05;
                double d5 = Math.cos(this.entityGuardian.field_70177_z * ((float)Math.PI / 180));
                double d6 = Math.sin(this.entityGuardian.field_70177_z * ((float)Math.PI / 180));
                double d7 = Math.sin((double)(this.entityGuardian.field_70173_aa + this.entityGuardian.func_145782_y()) * 0.75) * 0.05;
                this.entityGuardian.func_213317_d(this.entityGuardian.func_213322_ci().func_72441_c(d4 * d5, d7 * (d6 + d5) * 0.25 + (double)f2 * d2 * 0.1, d4 * d6));
                LookController lookcontroller = this.entityGuardian.func_70671_ap();
                double d8 = this.entityGuardian.func_226277_ct_() + d1 * 2.0;
                double d9 = this.entityGuardian.func_226280_cw_() + d2 / d0;
                double d10 = this.entityGuardian.func_226281_cx_() + d3 * 2.0;
                double d11 = lookcontroller.func_180423_e();
                double d12 = lookcontroller.func_180422_f();
                double d13 = lookcontroller.func_180421_g();
                if (!lookcontroller.func_180424_b()) {
                    d11 = d8;
                    d12 = d9;
                    d13 = d10;
                }
                this.entityGuardian.func_70671_ap().func_75650_a(MathHelper.func_219803_d((double)0.125, (double)d11, (double)d8), MathHelper.func_219803_d((double)0.125, (double)d12, (double)d9), MathHelper.func_219803_d((double)0.125, (double)d13, (double)d10), 10.0f, 40.0f);
            } else {
                this.entityGuardian.func_70659_e(0.0f);
            }
        }
    }
}

