/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.entity;

import com.dainxt.dungeonsmod.config.DungeonsModConfig;
import com.dainxt.dungeonsmod.entity.EntityWinterHunter;
import com.dainxt.dungeonsmod.handlers.EntityRegistries;
import com.dainxt.dungeonsmod.handlers.LootTableHandler;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;

public class EntityPitcher
extends MonsterEntity {
    private static final DataParameter<Integer> BINDED_PLAYER = EntityDataManager.func_187226_a(EntityPitcher.class, (IDataSerializer)DataSerializers.field_187192_b);
    private String cachedUniqueIdBinded = null;

    public EntityPitcher(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70728_aV = 10;
        this.func_110163_bv();
    }

    protected ResourceLocation func_184647_J() {
        return LootTableHandler.PITCHER;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(BINDED_PLAYER, (Object)-1);
    }

    public void setEntityBinded(int bindedPlayer) {
        if (!this.field_70170_p.field_72995_K && bindedPlayer < 0) {
            this.cachedUniqueIdBinded = null;
        }
        this.func_184212_Q().func_187227_b(BINDED_PLAYER, (Object)bindedPlayer);
    }

    public int getEntityBinded() {
        return (Integer)this.func_184212_Q().func_187225_a(BINDED_PLAYER);
    }

    public static boolean canSpawn(EntityType<? extends MonsterEntity> type, IWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return MonsterEntity.func_223324_d(type, (IWorld)worldIn, (SpawnReason)reason, (BlockPos)pos, (Random)randomIn);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        PlayerEntity player;
        if (source.func_76346_g() instanceof PlayerEntity && !this.field_70170_p.field_72995_K && ((player = (PlayerEntity)source.func_76346_g()).func_184614_ca().getToolTypes().contains(ToolType.HOE) || player.func_184614_ca().func_77973_b().equals(Items.field_151097_aZ))) {
            this.setEntityBinded(-1);
        }
        return super.func_70097_a(source, amount);
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        this.func_70107_b((int)this.func_226277_ct_(), this.func_226278_cu_(), (int)this.func_226281_cx_());
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, LivingEntity.class, 0, true, true, (Predicate)((Object)new PitcherTargetSelector(this))));
    }

    public static AttributeModifierMap.MutableAttribute createMobAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 16.0).func_233815_a_(Attributes.field_233823_f_, 3.0).func_233815_a_(Attributes.field_233821_d_, 0.0).func_233815_a_(Attributes.field_233819_b_, 2.0).func_233815_a_(Attributes.field_233826_i_, 10.0).func_233815_a_(Attributes.field_233820_c_, 1.0);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (!this.field_70170_p.field_72995_K) {
            this.cachedUniqueIdBinded = !compound.func_74779_i("BindedEntityUUID").isEmpty() ? compound.func_74779_i("BindedEntityUUID") : null;
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (!this.field_70170_p.field_72995_K && this.cachedUniqueIdBinded != null) {
            compound.func_74778_a("BindedEntityUUID", this.cachedUniqueIdBinded);
        }
    }

    public CompoundNBT func_189511_e(CompoundNBT compound) {
        return super.func_189511_e(compound);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = super.func_70652_k(entityIn);
        if (flag && entityIn instanceof LivingEntity && !this.field_70170_p.field_72995_K) {
            AxisAlignedBB box = this.func_174813_aQ().func_186662_g(60.0);
            ServerWorld serverworld = (ServerWorld)this.field_70170_p;
            boolean shouldInvokeHunter = false;
            if (((Boolean)DungeonsModConfig.COMMON.winterHunterInvocation.get()).booleanValue()) {
                if (entityIn instanceof PlayerEntity) {
                    ItemStack armorPiece;
                    boolean haveArmor = false;
                    Iterator iterator = entityIn.func_184193_aE().iterator();
                    while (iterator.hasNext() && !(haveArmor = !(armorPiece = (ItemStack)iterator.next()).func_190926_b())) {
                    }
                    shouldInvokeHunter = !haveArmor;
                } else if (entityIn instanceof LivingEntity) {
                    shouldInvokeHunter = this.func_70681_au().nextInt(60) == 0;
                }
            } else if (entityIn instanceof PlayerEntity) {
                PlayerEntity playerentity = (PlayerEntity)entityIn;
                playerentity.func_146105_b((ITextComponent)new TranslationTextComponent("entity.dungeonsmod.winterhunter.invocation.denied"), true);
            }
            List suns = serverworld.func_217482_a(EntityRegistries.WINTERHUNTER, EntityPredicates.field_180132_d);
            if (suns.isEmpty() && shouldInvokeHunter) {
                EntityWinterHunter traveler = new EntityWinterHunter(EntityRegistries.WINTERHUNTER, this.field_70170_p);
                int finalX = (int)this.func_226277_ct_() + 7 * (this.field_70146_Z.nextBoolean() ? 1 : -1);
                int finalZ = (int)this.func_226281_cx_() + 7 * (this.field_70146_Z.nextBoolean() ? 1 : -1);
                int finalY = this.field_70170_p.func_201676_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, finalX, finalZ);
                traveler.func_70012_b(finalX, finalY, finalZ, 0.0f, 0.0f);
                traveler.func_213386_a((IServerWorld)serverworld, this.field_70170_p.func_175649_E(traveler.func_233580_cy_()), SpawnReason.MOB_SUMMONED, null, null);
                this.field_70170_p.func_217376_c((Entity)traveler);
            }
            this.setEntityBinded(((LivingEntity)entityIn).func_145782_y());
        }
        return flag;
    }

    public void func_70636_d() {
        LivingEntity entity;
        super.func_70636_d();
        if (this.getEntityBinded() != -1 && (entity = (LivingEntity)this.field_70170_p.func_73045_a(this.getEntityBinded())) != null) {
            entity.func_213317_d(Vector3d.field_186680_a);
            entity.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.func_70638_az() == null && this.getEntityBinded() != -1) {
            this.setEntityBinded(-1);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.cachedUniqueIdBinded == null) {
                this.cachedUniqueIdBinded = this.field_70170_p.func_73045_a(this.getEntityBinded()) != null ? this.field_70170_p.func_73045_a(this.getEntityBinded()).func_189512_bd() : null;
            } else if (((ServerWorld)this.field_70170_p).func_217461_a(UUID.fromString(this.cachedUniqueIdBinded)) != null) {
                this.setEntityBinded(((ServerWorld)this.field_70170_p).func_217461_a(UUID.fromString(this.cachedUniqueIdBinded)).func_145782_y());
            }
        }
    }

    protected void func_82167_n(Entity entityIn) {
    }

    public boolean func_70104_M() {
        return false;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * 0.1f;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187577_bU;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187571_bR;
    }

    public void func_70623_bb() {
    }

    public float func_205022_a(BlockPos pos, IWorldReader worldIn) {
        return 0.0f;
    }

    public static class PitcherTargetSelector
    implements com.google.common.base.Predicate<LivingEntity> {
        private final EntityPitcher parentEntity;

        public PitcherTargetSelector(EntityPitcher guardian) {
            this.parentEntity = guardian;
        }

        public boolean apply(@Nullable LivingEntity p_apply_1_) {
            return !(p_apply_1_ instanceof EntityWinterHunter) && !(p_apply_1_ instanceof WolfEntity) && !(p_apply_1_ instanceof EntityPitcher);
        }
    }
}

