/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.entity;

import java.util.Arrays;
import java.util.Random;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.DyeItem;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class EntityRogue
extends MonsterEntity {
    public EntityRogue(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70728_aV = 6;
    }

    public static boolean canSpawn(EntityType<? extends MonsterEntity> type, IWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return MonsterEntity.func_223324_d(type, (IWorld)worldIn, (SpawnReason)reason, (BlockPos)pos, (Random)randomIn);
    }

    public boolean haveRobbedItem() {
        return !this.func_184582_a(EquipmentSlotType.OFFHAND).func_190926_b();
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_151052_q));
        if (this.func_70681_au().nextInt(2) == 0) {
            this.func_184201_a(EquipmentSlotType.CHEST, IDyeableArmorItem.func_219975_a((ItemStack)new ItemStack((IItemProvider)Items.field_151027_R), Arrays.asList((DyeItem)Items.field_222086_lz)));
            this.func_184201_a(EquipmentSlotType.LEGS, IDyeableArmorItem.func_219975_a((ItemStack)new ItemStack((IItemProvider)Items.field_151026_S), Arrays.asList((DyeItem)Items.field_222086_lz)));
            this.func_184201_a(EquipmentSlotType.FEET, IDyeableArmorItem.func_219975_a((ItemStack)new ItemStack((IItemProvider)Items.field_151021_T), Arrays.asList((DyeItem)Items.field_222086_lz)));
        }
        this.func_184642_a(EquipmentSlotType.OFFHAND, 2.0f);
    }

    public static AttributeModifierMap.MutableAttribute createMobAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233823_f_, 0.3).func_233815_a_(Attributes.field_233821_d_, 0.2).func_233815_a_(Attributes.field_233819_b_, 50.0).func_233815_a_(Attributes.field_233826_i_, 4.0);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = super.func_70652_k(entityIn);
        if (flag && entityIn instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entityIn;
            ItemStack stackOnHand = player.field_71071_by.func_70448_g();
            if (!stackOnHand.func_190926_b() && !this.haveRobbedItem()) {
                ItemStack robbedStack = stackOnHand.func_77946_l();
                robbedStack.func_190920_e(1);
                this.func_184201_a(EquipmentSlotType.OFFHAND, robbedStack);
                stackOnHand.func_190918_g(1);
                this.func_110163_bv();
            }
        }
        return flag;
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        this.func_180481_a(difficultyIn);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    private boolean shouldRun(PlayerEntity player) {
        Vector3d Vector3d2 = player.func_70676_i(1.0f).func_72432_b();
        Vector3d Vector3d1 = new Vector3d(this.func_226277_ct_() - player.func_226277_ct_(), this.func_174813_aQ().field_72338_b + (double)this.func_70047_e() - (player.func_226278_cu_() + (double)player.func_70047_e()), this.func_226281_cx_() - player.func_226281_cx_());
        double d0 = Vector3d1.func_72433_c();
        double d1 = Vector3d2.func_72430_b(Vector3d1 = Vector3d1.func_72432_b());
        return d1 > 0.6 ? player.func_70685_l((Entity)this) : false;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new EntityAIEscape(this, 2.25, 16.0f));
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
    }

    protected void func_70619_bc() {
        if (this.func_70605_aq().func_75640_a()) {
            double d0 = this.func_70605_aq().func_75638_b();
            if (d0 == 1.0) {
                this.func_226284_e_(true);
                this.func_70031_b(false);
            } else if (d0 == 2.5) {
                this.func_226284_e_(false);
                this.func_70031_b(true);
            } else {
                this.func_226284_e_(true);
                this.func_70031_b(false);
            }
        } else {
            this.func_226284_e_(true);
            this.func_70031_b(false);
        }
    }

    public float func_205022_a(BlockPos pos, IWorldReader worldIn) {
        return 0.0f;
    }

    static class EntityAIEscape
    extends MoveTowardsTargetGoal {
        EntityRogue rogue;

        public EntityAIEscape(EntityRogue creature, double speedIn, float targetMaxDistance) {
            super((CreatureEntity)creature, speedIn, targetMaxDistance);
            this.rogue = creature;
        }

        public boolean func_75250_a() {
            LivingEntity target = this.rogue.func_70638_az();
            if (target instanceof PlayerEntity && target != null && this.rogue.shouldRun((PlayerEntity)target)) {
                return super.func_75250_a();
            }
            return false;
        }
    }
}

