/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.entity;

import com.dainxt.dungeonsmod.config.DungeonsModConfig;
import com.dainxt.dungeonsmod.difficulty.DifficultyManager;
import com.dainxt.dungeonsmod.entity.EntityPitcher;
import com.dainxt.dungeonsmod.handlers.EntityRegistries;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShootableItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.BossInfo;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraft.world.server.ServerWorld;

public class EntityWinterHunter
extends MonsterEntity
implements IRangedAttackMob {
    DifficultyManager difficultyManager = new DifficultyManager();
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.WHITE, BossInfo.Overlay.PROGRESS).func_186741_a(true);

    public EntityWinterHunter(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70728_aV = 1000;
    }

    protected ResourceLocation func_184647_J() {
        return DungeonsModConfig.COMMON.winterhunter.getLootTable();
    }

    public ItemEntity func_70099_a(ItemStack stack, float offsetY) {
        if (stack.func_77973_b() instanceof BowItem) {
            // empty if block
        }
        return super.func_70099_a(stack, offsetY);
    }

    public static boolean canSpawn(EntityType<? extends MonsterEntity> type, IWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        if (worldIn.func_226691_t_(pos).func_201856_r() == Biome.Category.ICY) {
            return MonsterEntity.func_223324_d(type, (IWorld)worldIn, (SpawnReason)reason, (BlockPos)pos, (Random)randomIn);
        }
        if (randomIn.nextInt(30) == 0) {
            return MonsterEntity.func_223324_d(type, (IWorld)worldIn, (SpawnReason)reason, (BlockPos)pos, (Random)randomIn);
        }
        return false;
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_151031_f));
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficulty, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        ILivingEntityData data = super.func_213386_a(worldIn, difficulty, reason, spawnDataIn, dataTag);
        this.func_180481_a(difficulty);
        return data;
    }

    public static AttributeModifierMap.MutableAttribute createMobAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 220.0).func_233815_a_(Attributes.field_233823_f_, 40.0).func_233815_a_(Attributes.field_233821_d_, 0.6).func_233815_a_(Attributes.field_233819_b_, 40.0).func_233815_a_(Attributes.field_233826_i_, 15.0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(3, (Goal)new RangedBowAttackGoal((MonsterEntity)this, 1.0, 0, 40.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 0, true, true, (Predicate)((com.google.common.base.Predicate)null)));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, LivingEntity.class, 0, true, true, (Predicate)((Object)new WinterHunterTargetSelector(this))));
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    public boolean func_184222_aU() {
        return false;
    }

    protected void func_70619_bc() {
        ServerWorld serverworld;
        EntityPitcher traveler;
        super.func_70619_bc();
        if (((Boolean)DungeonsModConfig.COMMON.scalingDifficulty.get()).booleanValue()) {
            this.difficultyManager.adjustDifficulty((LivingEntity)this, 0.5f, 0.5f, 0.5f, 0.5f, this.bossInfo.func_186757_c());
        }
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        if (this.field_70173_aa % 300 == 0 && !this.field_70170_p.field_72995_K) {
            for (PlayerEntity player : this.bossInfo.func_186757_c()) {
                if (player.func_184812_l_() || player.func_175149_v()) continue;
                traveler = new EntityPitcher(EntityRegistries.PITCHER, this.field_70170_p);
                serverworld = (ServerWorld)this.field_70170_p;
                traveler.func_70012_b(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0f, 0.0f);
                traveler.func_213386_a((IServerWorld)serverworld, this.field_70170_p.func_175649_E(traveler.func_233580_cy_()), SpawnReason.MOB_SUMMONED, null, null);
                this.field_70170_p.func_217376_c((Entity)traveler);
                this.field_70170_p.func_184134_a(traveler.func_226277_ct_(), traveler.func_226278_cu_(), traveler.func_226281_cx_(), SoundEvents.field_187577_bU, SoundCategory.HOSTILE, 1.0f, 5.0f, false);
            }
        }
        if (this.field_70173_aa % 400 == 0 && !this.field_70170_p.field_72995_K) {
            for (PlayerEntity player : this.bossInfo.func_186757_c()) {
                if (player.func_184812_l_() || player.func_175149_v()) continue;
                traveler = new WolfEntity(EntityType.field_200724_aC, this.field_70170_p);
                serverworld = (ServerWorld)this.field_70170_p;
                traveler.func_70012_b(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0f, 0.0f);
                traveler.func_213386_a((IServerWorld)serverworld, this.field_70170_p.func_175649_E(traveler.func_233580_cy_()), SpawnReason.MOB_SUMMONED, null, null);
                this.field_70170_p.func_217376_c((Entity)traveler);
                traveler.func_70624_b((LivingEntity)player);
                this.field_70170_p.func_184134_a(traveler.func_226277_ct_(), traveler.func_226278_cu_(), traveler.func_226281_cx_(), SoundEvents.field_189111_gN, SoundCategory.HOSTILE, 1.0f, 5.0f, false);
            }
        }
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
        if (this.bossInfo.func_186757_c().isEmpty()) {
            this.func_70606_j((float)this.func_110148_a(Attributes.field_233818_a_).func_111125_b());
        }
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        ItemStack itemstack;
        if (distanceFactor <= 0.35f) {
            this.func_70652_k((Entity)target);
            this.func_184609_a(Hand.OFF_HAND);
        }
        if (!(itemstack = this.func_213356_f(this.func_184586_b(ProjectileHelper.func_221274_a((LivingEntity)this, (Item)Items.field_151031_f)))).func_190926_b()) {
            itemstack = Items.field_185167_i.func_190903_i();
        }
        AbstractArrowEntity abstractarrowentity = this.fireArrow(itemstack, distanceFactor);
        if (this.func_184614_ca().func_77973_b() instanceof BowItem) {
            abstractarrowentity = ((BowItem)this.func_184614_ca().func_77973_b()).customArrow(abstractarrowentity);
        }
        double d0 = target.func_226277_ct_() - this.func_226277_ct_();
        double d1 = target.func_226283_e_(0.3333333333) - abstractarrowentity.func_226278_cu_();
        double d2 = target.func_226281_cx_() - this.func_226281_cx_();
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        abstractarrowentity.func_70239_b(this.func_233637_b_(Attributes.field_233823_f_) * (double)0.3f);
        abstractarrowentity.func_70186_c(d0, d1 + d3 * (double)0.05f, d2, 5.0f, 1.0f);
        this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_217376_c((Entity)abstractarrowentity);
    }

    protected AbstractArrowEntity fireArrow(ItemStack arrowStack, float distanceFactor) {
        return ProjectileHelper.func_221272_a((LivingEntity)this, (ItemStack)arrowStack, (float)distanceFactor);
    }

    public boolean func_230280_a_(ShootableItem p_230280_1_) {
        return p_230280_1_ == Items.field_151031_f;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * 0.7f;
    }

    public List<ServerPlayerEntity> getPlayers() {
        return this.bossInfo.func_186757_c().stream().filter(EntityPredicates.field_188444_d).collect(Collectors.toList());
    }

    public boolean func_104002_bU() {
        return !this.bossInfo.func_186757_c().isEmpty();
    }

    public void func_70623_bb() {
        if (this.bossInfo.func_186757_c().isEmpty()) {
            super.func_70623_bb();
        }
    }

    public static class WinterHunterTargetSelector
    implements com.google.common.base.Predicate<LivingEntity> {
        private final EntityWinterHunter parentEntity;

        public WinterHunterTargetSelector(EntityWinterHunter guardian) {
            this.parentEntity = guardian;
        }

        public boolean apply(@Nullable LivingEntity p_apply_1_) {
            return !(p_apply_1_ instanceof EntityWinterHunter) && !(p_apply_1_ instanceof EndermanEntity) && !(p_apply_1_ instanceof EntityPitcher);
        }
    }
}

