/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.entity.boss;

import com.dainxt.dungeonsmod.ai.AIScheduledTimedAction;
import com.dainxt.dungeonsmod.config.DungeonsModConfig;
import com.dainxt.dungeonsmod.difficulty.DifficultyManager;
import com.dainxt.dungeonsmod.items.CrawlerArmorItem;
import com.dainxt.dungeonsmod.util.EntityUtils;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IChargeableMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.BossInfo;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT, _interface=IChargeableMob.class)
public class EntityCrawler
extends MonsterEntity
implements IChargeableMob {
    DifficultyManager difficultyManager = new DifficultyManager();
    int MAX_DISTANCE = 10;
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.RED, BossInfo.Overlay.PROGRESS).func_186741_a(true);
    private static final DataParameter<Boolean> POWERED = EntityDataManager.func_187226_a(EntityCrawler.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> HEAVY_ATTACK = EntityDataManager.func_187226_a(EntityCrawler.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> FINISHER_ATTACK = EntityDataManager.func_187226_a(EntityCrawler.class, (IDataSerializer)DataSerializers.field_187198_h);
    public ArrayList<BlockPos> HEART_PLACES;

    public EntityCrawler(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70728_aV = 1500;
        this.func_110163_bv();
        this.field_70158_ak = true;
        if (!worldIn.field_72995_K) {
            this.HEART_PLACES = new ArrayList();
        }
    }

    protected ResourceLocation func_184647_J() {
        return DungeonsModConfig.COMMON.crawler.getLootTable();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(POWERED, (Object)false);
        this.field_70180_af.func_187214_a(HEAVY_ATTACK, (Object)false);
        this.field_70180_af.func_187214_a(FINISHER_ATTACK, (Object)false);
    }

    public ItemEntity func_70099_a(ItemStack stack, float offsetY) {
        if (stack.func_77973_b() instanceof CrawlerArmorItem) {
            long totalPlayers = this.bossInfo.func_186757_c().stream().filter(EntityPredicates.field_188444_d).count();
            float totalChance = MathHelper.func_76131_a((float)((float)((Double)DungeonsModConfig.COMMON.legendaryLootChance.get() * (double)totalPlayers)), (float)0.0f, (float)100.0f);
            if (this.field_70170_p.func_201674_k().nextFloat() < totalChance / 100.0f) {
                return super.func_70099_a(stack, offsetY);
            }
            return super.func_70099_a(ItemStack.field_190927_a, offsetY);
        }
        return super.func_70099_a(stack, offsetY);
    }

    public boolean isPowered() {
        return (Boolean)this.func_184212_Q().func_187225_a(POWERED);
    }

    public void setPowered(boolean attack) {
        this.func_184212_Q().func_187227_b(POWERED, (Object)attack);
    }

    public boolean isHeavyAttacking() {
        return (Boolean)this.func_184212_Q().func_187225_a(HEAVY_ATTACK);
    }

    public void setHeavyAttack(boolean attack) {
        this.func_184212_Q().func_187227_b(HEAVY_ATTACK, (Object)attack);
    }

    public boolean isFinisherAttacking() {
        return (Boolean)this.func_184212_Q().func_187225_a(FINISHER_ATTACK);
    }

    public void setFinisherAttack(boolean attack) {
        this.func_184212_Q().func_187227_b(FINISHER_ATTACK, (Object)attack);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = false;
        if (this.isHeavyAttacking()) {
            float heavyDamage = ((LivingEntity)entityIn).func_110143_aJ() * 0.85f * DifficultyManager.getTotalAttributePPP((LivingEntity)this, Attributes.field_233823_f_);
            flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this).func_82726_p(), heavyDamage);
        } else if (this.isFinisherAttacking()) {
            float modAmount = 0.0f;
            if (entityIn instanceof PlayerEntity) {
                for (ItemStack stack : ((PlayerEntity)entityIn).field_71071_by.field_70462_a) {
                    if (stack.func_190926_b()) continue;
                    modAmount = (float)((double)modAmount + 0.1);
                }
            }
            float finisherDamage = (modAmount += this.func_70032_d(entityIn) * 1.5f + 5.0f) * DifficultyManager.getTotalAttributePPP((LivingEntity)this, Attributes.field_233823_f_);
            flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this).func_82726_p(), finisherDamage);
        } else {
            flag = super.func_70652_k(entityIn);
        }
        return flag;
    }

    public void func_70020_e(CompoundNBT compound) {
        this.setHeavyAttack(compound.func_74767_n("HeavyAttack"));
        if (!this.field_70170_p.field_72995_K) {
            CompoundNBT nbt = compound.func_74775_l("heartPos");
            for (int i = 0; i < nbt.func_74762_e("index"); ++i) {
                this.HEART_PLACES.add(BlockPos.func_218283_e((long)nbt.func_74763_f("heart_" + i)));
            }
        }
        super.func_70020_e(compound);
    }

    public CompoundNBT func_189511_e(CompoundNBT compound) {
        compound.func_74757_a("HeavyAttack", this.isHeavyAttacking());
        if (!this.field_70170_p.field_72995_K) {
            CompoundNBT nbt = compound.func_74775_l("heartPos");
            nbt.func_74768_a("index", this.HEART_PLACES.size());
            for (int i = 0; i < this.HEART_PLACES.size(); ++i) {
                nbt.func_74772_a("heart_" + i, this.HEART_PLACES.get(i).func_218275_a());
            }
            compound.func_218657_a("heartPos", (INBT)nbt);
        }
        return super.func_189511_e(compound);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new AIDoFinisherAttack(this, 60, 240));
        this.field_70714_bg.func_75776_a(2, (Goal)new AIDoHeavyAttack(this, 40, 120, 2));
        this.field_70714_bg.func_75776_a(3, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 0, true, true, (Predicate)((com.google.common.base.Predicate)null)));
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76364_f() instanceof ArrowEntity) {
            ((ArrowEntity)source.func_76364_f()).func_70240_a(0);
        }
        return super.func_70097_a(source, amount);
    }

    public static AttributeModifierMap.MutableAttribute createMobAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 300.0).func_233815_a_(Attributes.field_233823_f_, 10.0).func_233815_a_(Attributes.field_233821_d_, 0.5).func_233815_a_(Attributes.field_233819_b_, 40.0).func_233815_a_(Attributes.field_233826_i_, 10.0).func_233815_a_(Attributes.field_233820_c_, 1.0);
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223224_c_;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        List entities = this.field_70170_p.func_217357_a(LivingEntity.class, this.func_174813_aQ().func_186662_g(25.0));
        if (!entities.isEmpty()) {
            for (LivingEntity entity : entities) {
                if (entity instanceof EntityCrawler) continue;
                if (entity instanceof PlayerEntity) {
                    this.func_184185_a(SoundEvents.field_187539_bB, 10.0f, 1.0f);
                    this.func_70656_aK();
                }
                this.func_70652_k((Entity)entity);
            }
        }
        return super.func_225503_b_(distance, damageMultiplier);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_239814_an_, this.func_226282_d_(0.5), this.func_226279_cv_() - 0.25, this.func_226287_g_(0.5), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
            }
        }
    }

    protected float func_175134_bD() {
        return 0.8f;
    }

    protected void func_226294_cV_() {
        this.field_70728_aV = (int)((long)this.field_70728_aV + (long)MathHelper.func_76123_f((float)((float)this.field_70728_aV * 0.1f)) * this.bossInfo.func_186757_c().stream().filter(EntityPredicates.field_188444_d).count());
        super.func_226294_cV_();
    }

    public boolean func_184222_aU() {
        return false;
    }

    protected void func_70619_bc() {
        long hearts;
        super.func_70619_bc();
        if (((Boolean)DungeonsModConfig.COMMON.scalingDifficulty.get()).booleanValue()) {
            this.difficultyManager.adjustDifficulty((LivingEntity)this, 0.3f, 0.1f, 0.1f, 0.1f, this.bossInfo.func_186757_c());
        }
        this.setPowered((hearts = this.HEART_PLACES.stream().filter(pos -> !pos.equals((Object)BlockPos.field_177992_a) && this.field_70170_p.func_180495_p(pos).func_177230_c() == Blocks.field_150451_bX).count()) > 0L);
        this.func_70691_i((float)hearts * 2.0f);
        if (this.field_70173_aa % 20 == 0) {
            EntityUtils.scanBlocksInAABB((LivingEntity)this, this.func_174813_aQ().func_186662_g((double)0.1f), (blockPos, blockState) -> {
                int hardness = MathHelper.func_76125_a((int)MathHelper.func_76141_d((float)(blockState.func_185887_b((IBlockReader)this.field_70170_p, blockPos) * 0.33f)), (int)3, (int)Integer.MAX_VALUE);
                if (!blockState.func_177230_c().equals(Blocks.field_150357_h) && (double)blockPos.func_177956_o() > this.func_226283_e_(0.1f) && this.field_70170_p.field_73012_v.nextInt(hardness) == 0) {
                    this.field_70170_p.func_175655_b(blockPos, false);
                }
                return false;
            });
        }
        float distance = Float.MAX_VALUE;
        for (PlayerEntity playerEntity : this.getPlayers()) {
            distance = Math.min(playerEntity.func_70032_d((Entity)this), distance);
        }
        if (distance > (float)this.MAX_DISTANCE) {
            this.func_70691_i(0.5f);
        }
        this.func_70691_i(0.25f * DifficultyManager.getTotalAttributePPP((LivingEntity)this, Attributes.field_233818_a_));
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
        if (this.bossInfo.func_186757_c().isEmpty()) {
            this.func_70606_j(this.func_110138_aP());
        }
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public List<ServerPlayerEntity> getPlayers() {
        return this.bossInfo.func_186757_c().stream().filter(EntityPredicates.field_188444_d).collect(Collectors.toList());
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187662_cZ;
    }

    protected SoundEvent func_184588_d(int heightIn) {
        return SoundEvents.field_187539_bB;
    }

    public boolean func_225509_J__() {
        return this.isPowered();
    }

    public void func_70623_bb() {
    }

    class AIDoHeavyAttack
    extends AIScheduledTimedAction {
        EntityCrawler crawler;

        public AIDoHeavyAttack(EntityCrawler entity, int maxDuration, int maxCooldown, int times) {
            super((LivingEntity)entity, maxDuration, maxCooldown, ++times);
            this.crawler = entity;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        @Override
        public boolean func_75250_a() {
            if (this.crawler.func_70638_az() != null) {
                return super.func_75250_a();
            }
            return false;
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
            this.crawler.func_226284_e_(true);
        }

        @Override
        public void onStartCycle() {
            this.crawler.setHeavyAttack(true);
            if (this.times > 0) {
                this.crawler.func_70683_ar().func_75660_a();
            }
        }

        @Override
        public void func_75251_c() {
            super.func_75251_c();
            this.crawler.setHeavyAttack(false);
            this.crawler.func_226284_e_(false);
        }
    }

    class AIDoFinisherAttack
    extends AIScheduledTimedAction {
        EntityCrawler crawler;

        public AIDoFinisherAttack(EntityCrawler entity, int maxDuration, int maxCooldown) {
            super((LivingEntity)entity, maxDuration, maxCooldown);
            this.crawler = entity;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        @Override
        public boolean func_75250_a() {
            if (this.crawler.func_70638_az() != null) {
                return super.func_75250_a();
            }
            return false;
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
            this.crawler.setFinisherAttack(true);
        }

        @Override
        public void onStartCycle() {
            List entities = this.crawler.field_70170_p.func_217357_a(LivingEntity.class, this.attacker.func_174813_aQ().func_186662_g(50.0));
            if (!entities.isEmpty()) {
                for (LivingEntity entity : entities) {
                    if (entity instanceof EntityCrawler) continue;
                    this.attacker.func_70652_k((Entity)entity);
                }
            }
        }

        @Override
        public void func_75251_c() {
            super.func_75251_c();
            this.crawler.setFinisherAttack(false);
        }
    }
}

