/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.entity.boss;

import com.dainxt.dungeonsmod.ai.AITimedAction;
import com.dainxt.dungeonsmod.config.DungeonsModConfig;
import com.dainxt.dungeonsmod.difficulty.DifficultyManager;
import com.dainxt.dungeonsmod.items.ItemSandBucket;
import com.dainxt.dungeonsmod.util.EntityUtils;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FallingBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IChargeableMob;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.entity.projectile.FireballEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.BossInfo;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT, _interface=IChargeableMob.class)
public class EntityDeserted
extends MonsterEntity
implements IChargeableMob,
IRangedAttackMob {
    DifficultyManager difficultyManager = new DifficultyManager();
    private static final DataParameter<Integer> FIRE_ARMOR_TIME = EntityDataManager.func_187226_a(EntityDeserted.class, (IDataSerializer)DataSerializers.field_187192_b);
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.YELLOW, BossInfo.Overlay.PROGRESS).func_186741_a(true);

    public EntityDeserted(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70728_aV = 250;
        this.func_110163_bv();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FIRE_ARMOR_TIME, (Object)0);
    }

    public int getFireArmor() {
        return (Integer)this.func_184212_Q().func_187225_a(FIRE_ARMOR_TIME);
    }

    public void setHaveFireArmor(int time) {
        this.func_184212_Q().func_187227_b(FIRE_ARMOR_TIME, (Object)time);
    }

    protected ResourceLocation func_184647_J() {
        return DungeonsModConfig.COMMON.deserted.getLootTable();
    }

    public ItemEntity func_70099_a(ItemStack stack, float offsetY) {
        if (stack.func_77973_b() instanceof ItemSandBucket) {
            long totalPlayers = this.bossInfo.func_186757_c().stream().filter(EntityPredicates.field_188444_d).count();
            float totalChance = MathHelper.func_76131_a((float)((float)((Double)DungeonsModConfig.COMMON.legendaryLootChance.get() * (double)totalPlayers)), (float)0.0f, (float)100.0f);
            if (this.field_70170_p.func_201674_k().nextFloat() < totalChance / 100.0f) {
                return super.func_70099_a(stack, offsetY);
            }
            return super.func_70099_a(ItemStack.field_190927_a, offsetY);
        }
        return super.func_70099_a(stack, offsetY);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.getFireArmor() > 0) {
            amount *= 0.25f;
        }
        if (source.equals(DamageSource.field_76368_d)) {
            EntityUtils.destroyBlocksInAABB((LivingEntity)this, null);
        }
        if (source.func_76364_f() instanceof ArrowEntity) {
            ((ArrowEntity)source.func_76364_f()).func_70240_a(0);
        }
        if (source.func_76347_k()) {
            this.setHaveFireArmor(100);
            this.func_70691_i(amount * 2.0f);
            EntityUtils.destroyBlocksInAABB((LivingEntity)this, 2.0, Blocks.field_150480_ab, Blocks.field_150353_l);
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_96092_aw() {
        return true;
    }

    public boolean func_180427_aV() {
        return true;
    }

    public static AttributeModifierMap.MutableAttribute createMobAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 150.0).func_233815_a_(Attributes.field_233823_f_, 20.0).func_233815_a_(Attributes.field_233821_d_, 0.0).func_233815_a_(Attributes.field_233819_b_, 40.0).func_233815_a_(Attributes.field_233826_i_, 30.0).func_233815_a_(Attributes.field_233820_c_, 1.0);
    }

    private double getHeadX(int p_82214_1_) {
        if (p_82214_1_ <= 0) {
            float f = (this.field_70761_aq + 90.0f) * ((float)Math.PI / 180);
            float f1 = MathHelper.func_76134_b((float)f);
            return this.func_226277_ct_() + (double)f1 * 1.0;
        }
        float f = (this.field_70761_aq + (float)(180 * (p_82214_1_ - 1))) * ((float)Math.PI / 180);
        float f1 = MathHelper.func_76134_b((float)f);
        return this.func_226277_ct_() + (double)f1 * 1.3;
    }

    private double getHeadY(int p_82208_1_) {
        return p_82208_1_ <= 0 ? this.func_226278_cu_() + 1.9 : this.func_226278_cu_() + 2.2;
    }

    private double getHeadZ(int p_82213_1_) {
        if (p_82213_1_ <= 0) {
            float f = (this.field_70761_aq + 90.0f) * ((float)Math.PI / 180);
            float f1 = MathHelper.func_76126_a((float)f);
            return this.func_226281_cx_() + (double)f1 * 1.0;
        }
        float f = (this.field_70761_aq + (float)(180 * (p_82213_1_ - 1))) * ((float)Math.PI / 180);
        float f1 = MathHelper.func_76126_a((float)f);
        return this.func_226281_cx_() + (double)f1 * 1.3;
    }

    private void launchProjectiletoEntity(int p_82216_1_, LivingEntity p_82216_2_) {
        this.launchProjectiletoCoords(p_82216_1_, p_82216_2_.func_226277_ct_(), p_82216_2_.func_226278_cu_() + (double)p_82216_2_.func_70047_e() * 0.5, p_82216_2_.func_226281_cx_(), p_82216_1_ == 0 && this.field_70146_Z.nextFloat() < 0.001f);
    }

    private void launchProjectiletoCoords(int p_82209_1_, double x, double y, double z, boolean invulnerable) {
        if (!this.func_174814_R()) {
            this.field_70170_p.func_217378_a((PlayerEntity)null, 1024, this.func_233580_cy_(), 0);
        }
        double d0 = this.getHeadX(p_82209_1_);
        double d1 = this.getHeadY(p_82209_1_);
        double d2 = this.getHeadZ(p_82209_1_);
        double d3 = x - d0;
        double d4 = y - d1;
        double d5 = z - d2;
        FireballEntity witherskullentity = new FireballEntity(this.field_70170_p, (LivingEntity)this, d3, d4, d5);
        witherskullentity.func_212361_a((Entity)this);
        witherskullentity.field_92057_e = 0;
        witherskullentity.func_226288_n_(d0, d1, d2);
        this.field_70170_p.func_217376_c((Entity)witherskullentity);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new AIDoNothing(this, 240, 60));
        this.field_70714_bg.func_75776_a(1, (Goal)new RangedAttackGoal((IRangedAttackMob)this, 1.0, 7, 20.0f));
        this.field_70714_bg.func_75776_a(2, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 16.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, LivingEntity.class, 0, true, true, (Predicate)((com.google.common.base.Predicate)null)));
    }

    protected void func_82167_n(Entity entityIn) {
    }

    public boolean func_70104_M() {
        return false;
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        this.func_70107_b((int)this.func_226277_ct_(), this.func_226278_cu_(), (int)this.func_226281_cx_());
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_239820_at_, this.func_226282_d_(0.5), this.func_226279_cv_() - 0.25, this.func_226287_g_(0.5), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
            }
        }
        this.func_213323_x_();
        if (!this.field_70170_p.field_72995_K && this.getFireArmor() > 0) {
            int time = this.getFireArmor();
            this.setHaveFireArmor(--time);
        }
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        if (distanceFactor <= 0.35f) {
            this.func_70652_k((Entity)target);
        }
        this.func_184609_a(Hand.OFF_HAND);
        this.launchProjectiletoEntity(0, target);
    }

    protected void func_191955_a(BlockState blockstate) {
        Block block = blockstate.func_177230_c();
        if (block == Blocks.field_150354_m) {
            EntityUtils.destroyBlocksInAABB((LivingEntity)this, Blocks.field_150354_m);
            this.func_70691_i(10.0f);
        }
        if (block instanceof FallingBlock) {
            EntityUtils.destroyBlocksInAABB((LivingEntity)this, block);
        }
        super.func_191955_a(blockstate);
    }

    protected void func_226294_cV_() {
        this.field_70728_aV = (int)((long)this.field_70728_aV + (long)MathHelper.func_76123_f((float)((float)this.field_70728_aV * 0.1f)) * this.bossInfo.func_186757_c().stream().filter(EntityPredicates.field_188444_d).count());
        super.func_226294_cV_();
    }

    public boolean func_184222_aU() {
        return false;
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (((Boolean)DungeonsModConfig.COMMON.scalingDifficulty.get()).booleanValue()) {
            this.difficultyManager.adjustDifficulty((LivingEntity)this, 0.2f, 0.0f, 0.5f, 0.0f, this.bossInfo.func_186757_c());
        }
        if (!this.func_213394_dL()) {
            this.func_213390_a(this.func_233580_cy_(), 3);
        }
        BlockPos pos = this.func_213384_dI();
        this.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        this.func_213317_d(Vector3d.field_186680_a);
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
        if (this.bossInfo.func_186757_c().isEmpty()) {
            this.func_70606_j(this.func_110138_aP());
        }
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_232800_m_;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187747_eB;
    }

    public boolean func_225509_J__() {
        return this.getFireArmor() > 0;
    }

    public EntitySize func_213305_a(Pose entityPose) {
        if (this.func_110148_a(Attributes.field_233826_i_).func_111126_e() == 0.0) {
            return EntitySize.func_220314_b((float)1.0f, (float)1.0f);
        }
        return EntitySize.func_220314_b((float)1.5f, (float)2.5f);
    }

    public void func_70623_bb() {
    }

    class AIDoNothing
    extends AITimedAction {
        EntityDeserted deserted;

        public AIDoNothing(EntityDeserted entity, int maxDuration, int maxCooldown) {
            super((LivingEntity)entity, maxDuration, maxCooldown);
            this.deserted = entity;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        @Override
        public void func_75251_c() {
            super.func_75251_c();
            EntityUtils.destroyBlocksInAABB(this.attacker, 3.0, Blocks.field_150355_j);
            this.attacker.func_184185_a(SoundEvents.field_187646_bt, 10.0f, 0.1f);
            this.deserted.setHaveFireArmor(this.maxCooldown);
            this.attacker.func_110148_a(Attributes.field_233826_i_).func_111128_a(30.0);
        }

        @Override
        public boolean func_75253_b() {
            return super.func_75253_b();
        }

        @Override
        public boolean func_75250_a() {
            if (this.attacker.func_70090_H() && this.deserted.getFireArmor() > 0) {
                EntityUtils.destroyBlocksInAABB(this.attacker, 1.0, Blocks.field_150355_j);
                this.attacker.func_184185_a(SoundEvents.field_187646_bt, 10.0f, 0.1f);
            }
            return super.func_75250_a() && this.attacker.func_70090_H();
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
            this.attacker.func_110148_a(Attributes.field_233826_i_).func_111128_a(0.0);
        }
    }
}

