/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.entity.boss;

import com.dainxt.dungeonsmod.config.DungeonsModConfig;
import com.dainxt.dungeonsmod.difficulty.DifficultyManager;
import com.dainxt.dungeonsmod.items.ItemOreDetector;
import com.dainxt.dungeonsmod.util.EntityUtils;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.item.PickaxeItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.BossInfo;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraftforge.common.ToolType;

public class EntityIronSlime
extends MonsterEntity {
    DifficultyManager difficultyManager = new DifficultyManager();
    private static final DataParameter<Integer> PHASE = EntityDataManager.func_187226_a(EntityIronSlime.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> OUTER_SHELL_INTEGRITY = EntityDataManager.func_187226_a(EntityIronSlime.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> LAST_MINED_TICK = EntityDataManager.func_187226_a(EntityIronSlime.class, (IDataSerializer)DataSerializers.field_187192_b);
    public final float homeRange = 7.0f;
    private final float maxPhase = 5.0f;
    private int MaxTimeBreak = 28;
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.WHITE, BossInfo.Overlay.PROGRESS).func_186741_a(true);

    public EntityIronSlime(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70765_h = new MoveHelperController(this);
        this.field_70728_aV = 375;
        this.func_110163_bv();
    }

    public boolean func_96092_aw() {
        return false;
    }

    protected ResourceLocation func_184647_J() {
        return DungeonsModConfig.COMMON.ironslime.getLootTable();
    }

    public ItemEntity func_70099_a(ItemStack stack, float offsetY) {
        if (stack.func_77973_b() instanceof ItemOreDetector) {
            long totalPlayers = this.bossInfo.func_186757_c().stream().filter(EntityPredicates.field_188444_d).count();
            float totalChance = MathHelper.func_76131_a((float)((float)((Double)DungeonsModConfig.COMMON.legendaryLootChance.get() * (double)totalPlayers)), (float)0.0f, (float)100.0f);
            if (this.field_70170_p.func_201674_k().nextFloat() < totalChance / 100.0f) {
                return super.func_70099_a(stack, offsetY);
            }
            return super.func_70099_a(ItemStack.field_190927_a, offsetY);
        }
        return super.func_70099_a(stack, offsetY);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(LAST_MINED_TICK, (Object)0);
        this.field_70180_af.func_187214_a(PHASE, (Object)5);
        this.field_70180_af.func_187214_a(OUTER_SHELL_INTEGRITY, (Object)28);
    }

    public void setLastMinedTick(int phase) {
        this.func_184212_Q().func_187227_b(LAST_MINED_TICK, (Object)phase);
    }

    public int getLastMinedTick() {
        return (Integer)this.func_184212_Q().func_187225_a(LAST_MINED_TICK);
    }

    public void setPhase(int phase) {
        this.func_184212_Q().func_187227_b(PHASE, (Object)phase);
    }

    public int getPhase() {
        return (Integer)this.func_184212_Q().func_187225_a(PHASE);
    }

    public void setShellIntegrity(int integrity) {
        this.func_184212_Q().func_187227_b(OUTER_SHELL_INTEGRITY, (Object)integrity);
    }

    public int getShellIntegrity() {
        return (Integer)this.func_184212_Q().func_187225_a(OUTER_SHELL_INTEGRITY);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new FloatGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new AIReturnHome(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new AttackGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new FaceRandomGoal(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new HopGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 0, true, true, null));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, LivingEntity.class, 0, true, true, null));
    }

    public static AttributeModifierMap.MutableAttribute createMobAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233820_c_, 1.0);
    }

    public void func_70020_e(CompoundNBT compound) {
        super.func_70020_e(compound);
        BlockPos homePos = BlockPos.func_218283_e((long)compound.func_74763_f("HomePosition"));
        if (!homePos.equals((Object)BlockPos.field_177992_a)) {
            this.func_213390_a(homePos, 7);
        }
    }

    public CompoundNBT func_189511_e(CompoundNBT compound) {
        if (this.func_213394_dL()) {
            compound.func_74772_a("HomePosition", this.func_213384_dI().func_218275_a());
        }
        super.func_213281_b(compound);
        return super.func_189511_e(compound);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76346_g() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)source.func_76346_g();
            if (this.getPhase() >= 2 && player.func_184614_ca().getToolTypes().contains(ToolType.PICKAXE)) {
                if (!this.field_70170_p.field_72995_K && 0.0f == player.func_184811_cZ().func_185143_a(player.func_184614_ca().func_77973_b(), 1.0f)) {
                    player.func_184811_cZ().func_185145_a(player.func_184614_ca().func_77973_b(), 10);
                    this.setLastMinedTick(this.field_70173_aa);
                    int shell = this.getShellIntegrity();
                    int reduce = this.func_70027_ad() ? 2 : 1;
                    this.setShellIntegrity(shell - reduce);
                    return true;
                }
                if (player.func_184811_cZ().func_185143_a(player.func_184614_ca().func_77973_b(), 1.0f) != 0.0f) {
                    this.func_184185_a(SoundEvents.field_187880_fp, 1.0f, 1.0f);
                    return true;
                }
            }
        }
        if (source.func_76357_e()) {
            return super.func_70097_a(source, amount);
        }
        if (this.getPhase() >= 2) {
            if (!this.field_70170_p.field_72995_K && !this.func_70027_ad()) {
                this.func_184185_a(SoundEvents.field_187880_fp, 0.1f, 0.1f);
            }
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public void func_70100_b_(PlayerEntity entityIn) {
        super.func_70100_b_(entityIn);
        this.func_70652_k((Entity)entityIn);
    }

    public void func_70108_f(Entity entityIn) {
        super.func_70108_f(entityIn);
        this.func_70652_k(entityIn);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = super.func_70652_k(entityIn);
        if (flag) {
            if (entityIn instanceof LivingEntity) {
                for (ItemStack itemstack : entityIn.func_184209_aF()) {
                    if (itemstack.func_77973_b() instanceof ArmorItem && ((ArmorItem)itemstack.func_77973_b()).func_200880_d().equals(ArmorMaterial.IRON)) {
                        itemstack.func_96631_a(30, ((LivingEntity)entityIn).func_70681_au(), entityIn instanceof ServerPlayerEntity ? (ServerPlayerEntity)entityIn : null);
                    }
                    if (!itemstack.getToolTypes().contains(ToolType.PICKAXE)) continue;
                    if (itemstack.func_77973_b() instanceof PickaxeItem) {
                        if (((PickaxeItem)itemstack.func_77973_b()).func_200891_e().equals(ItemTier.IRON)) {
                            itemstack.func_96631_a(75, ((LivingEntity)entityIn).func_70681_au(), entityIn instanceof ServerPlayerEntity ? (ServerPlayerEntity)entityIn : null);
                            continue;
                        }
                        itemstack.func_96631_a(5, ((LivingEntity)entityIn).func_70681_au(), entityIn instanceof ServerPlayerEntity ? (ServerPlayerEntity)entityIn : null);
                        continue;
                    }
                    itemstack.func_96631_a(25, ((LivingEntity)entityIn).func_70681_au(), entityIn instanceof ServerPlayerEntity ? (ServerPlayerEntity)entityIn : null);
                }
                if (this.func_70027_ad()) {
                    entityIn.func_70015_d(2);
                }
            }
            ((LivingEntity)entityIn).func_233627_a_(2.0f * (float)this.getPhase(), (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
            ((LivingEntity)entityIn).func_195064_c(new EffectInstance(Effects.field_76421_d, 60, 2 + MathHelper.func_76141_d((float)(this.maxPhase + 1.0f - (float)this.getPhase()))));
        }
        return flag;
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        if (!this.func_213394_dL()) {
            this.func_213390_a(this.func_233580_cy_(), 7);
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public boolean func_241845_aY() {
        return this.func_70089_S();
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K && this.func_70681_au().nextInt(20) == 0) {
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197602_M, this.func_226282_d_(0.5), this.func_226279_cv_() - 0.25, this.func_226287_g_(0.5), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
            }
        }
        this.func_213323_x_();
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa - this.getLastMinedTick() > 20) {
            this.setShellIntegrity(this.MaxTimeBreak);
        }
        if (this.getShellIntegrity() <= 0) {
            int actualPhase = this.getPhase();
            this.setPhase(--actualPhase);
            this.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() + 0.25, this.func_226281_cx_());
            if (actualPhase == 1) {
                this.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() + 0.5, this.func_226281_cx_());
            }
            this.setShellIntegrity(this.MaxTimeBreak);
        }
    }

    protected void func_191955_a(BlockState blockstate) {
        Block block = blockstate.func_177230_c();
        if (block == Blocks.field_196553_aF) {
            EntityUtils.destroyBlocksInAABB((LivingEntity)this, block);
        }
        super.func_191955_a(blockstate);
    }

    private void faceBlockPos(BlockPos pos) {
        float f1;
        double d0 = (double)pos.func_177958_n() - this.func_226277_ct_();
        double d2 = (double)pos.func_177952_p() - this.func_226281_cx_();
        double d1 = (double)pos.func_177956_o() - this.func_226278_cu_();
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
        this.field_70125_A = f1 = (float)(-(MathHelper.func_181159_b((double)d1, (double)d3) * 57.29577951308232));
        this.field_70177_z = f;
    }

    public int getJumpDelay() {
        return 40;
    }

    public boolean makesSoundOnJump() {
        return true;
    }

    public boolean canDamagePlayer() {
        return true;
    }

    protected float func_175134_bD() {
        return this.func_180799_ab() ? 2.0f : 0.42f;
    }

    protected void func_226294_cV_() {
        this.field_70728_aV = (int)((long)this.field_70728_aV + (long)MathHelper.func_76123_f((float)((float)this.field_70728_aV * 0.1f)) * this.bossInfo.func_186757_c().stream().filter(EntityPredicates.field_188444_d).count());
        super.func_226294_cV_();
    }

    public boolean func_184222_aU() {
        return false;
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (((Boolean)DungeonsModConfig.COMMON.scalingDifficulty.get()).booleanValue()) {
            this.difficultyManager.adjustDifficulty((LivingEntity)this, 0.5f, 0.0f, 0.2f, 0.0f, this.bossInfo.func_186757_c());
            this.MaxTimeBreak = MathHelper.func_76141_d((float)(8.0f * DifficultyManager.getTotalAttributePPP((LivingEntity)this, Attributes.field_233818_a_)));
        }
        float bonusDamage = 0.0f;
        if ((double)this.getPhase() <= 1.0) {
            bonusDamage = 11.0f;
            this.bossInfo.func_186735_a(((float)this.getPhase() - (1.0f - this.func_110143_aJ() / (float)this.MaxTimeBreak)) / this.maxPhase);
        } else {
            this.bossInfo.func_186735_a(((float)this.getPhase() - (1.0f - (float)this.getShellIntegrity() / (float)this.MaxTimeBreak)) / this.maxPhase);
        }
        this.func_110148_a(Attributes.field_233821_d_).func_111128_a((double)((this.maxPhase + 1.0f - (float)this.getPhase()) * 0.08f + 0.5f));
        this.func_110148_a(Attributes.field_233823_f_).func_111128_a((double)((this.maxPhase + 1.0f - (float)this.getPhase()) * 2.0f + bonusDamage));
        if (this.field_70173_aa % 20 == 0) {
            EntityUtils.scanBlocksInAABB((LivingEntity)this, this.func_174813_aQ().func_186662_g((double)0.1f), (blockPos, blockState) -> {
                int hardness = MathHelper.func_76125_a((int)MathHelper.func_76141_d((float)(blockState.func_185887_b((IBlockReader)this.field_70170_p, blockPos) * 0.66f)), (int)3, (int)Integer.MAX_VALUE);
                if (!blockState.func_177230_c().equals(Blocks.field_150357_h) && (double)blockPos.func_177956_o() > this.func_226283_e_(0.1f) && this.field_70170_p.field_73012_v.nextInt(hardness) == 0) {
                    this.field_70170_p.func_175655_b(blockPos, false);
                }
                return false;
            });
        }
        float distance = Float.MAX_VALUE;
        for (PlayerEntity player : this.bossInfo.func_186757_c()) {
            distance = Math.min(player.func_70032_d((Entity)this), distance);
            if (!(player.func_70032_d((Entity)this) < 15.0f)) continue;
            player.func_195064_c(new EffectInstance(Effects.field_76419_f, 100, 2));
        }
        if (distance > 7.0f) {
            this.func_70691_i(1.0f);
        }
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
        if (this.bossInfo.func_186757_c().isEmpty()) {
            this.func_70606_j(this.func_110138_aP());
            ((Object)((Object)this)).getClass();
            this.setPhase(5);
        }
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    protected SoundEvent getJumpSound() {
        return SoundEvents.field_187605_cG;
    }

    protected SoundEvent func_184588_d(int heightIn) {
        return SoundEvents.field_187689_f;
    }

    public EntitySize func_213305_a(Pose entityPose) {
        return EntitySize.func_220314_b((float)((float)this.getPhase() * 0.5f + 0.5f), (float)((float)this.getPhase() * 0.5f + 0.5f));
    }

    public void func_70623_bb() {
    }

    static class MoveHelperController
    extends MovementController {
        private float yRot;
        private int jumpDelay;
        private final EntityIronSlime slime;
        private boolean isAggressive;

        public MoveHelperController(EntityIronSlime slimeIn) {
            super((MobEntity)slimeIn);
            this.slime = slimeIn;
            this.yRot = 180.0f * slimeIn.field_70177_z / (float)Math.PI;
        }

        public void setDirection(float yRotIn, boolean aggressive) {
            this.yRot = yRotIn;
            this.isAggressive = aggressive;
        }

        public void setSpeed(double speedIn) {
            this.field_75645_e = speedIn;
            this.field_188491_h = MovementController.Action.MOVE_TO;
        }

        public void func_75641_c() {
            this.field_75648_a.field_70759_as = this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, this.yRot, 90.0f);
            this.field_75648_a.field_70761_aq = this.field_75648_a.field_70177_z;
            if (this.field_188491_h != MovementController.Action.MOVE_TO) {
                this.field_75648_a.func_191989_p(0.0f);
            } else {
                this.field_188491_h = MovementController.Action.WAIT;
                if (this.field_75648_a.func_233570_aj_()) {
                    this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_233637_b_(Attributes.field_233821_d_)));
                    if (this.jumpDelay-- <= 0) {
                        this.jumpDelay = this.slime.getJumpDelay();
                        if (this.isAggressive) {
                            this.jumpDelay /= 3;
                        }
                        this.slime.func_70683_ar().func_75660_a();
                        if (this.slime.makesSoundOnJump()) {
                            this.slime.func_184185_a(this.slime.getJumpSound(), this.slime.func_70599_aP() * 0.2f, 1.0f);
                        }
                    } else {
                        this.slime.field_70702_br = 0.0f;
                        this.slime.field_191988_bg = 0.0f;
                        this.field_75648_a.func_70659_e(0.0f);
                    }
                } else {
                    this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_233637_b_(Attributes.field_233821_d_)));
                }
            }
        }
    }

    static class HopGoal
    extends Goal {
        private final EntityIronSlime slime;

        public HopGoal(EntityIronSlime slimeIn) {
            this.slime = slimeIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return !this.slime.func_184218_aH();
        }

        public void func_75246_d() {
            ((MoveHelperController)this.slime.func_70605_aq()).setSpeed(1.0);
        }
    }

    static class FaceRandomGoal
    extends Goal {
        private final EntityIronSlime slime;
        private float chosenDegrees;
        private int nextRandomizeTime;

        public FaceRandomGoal(EntityIronSlime slimeIn) {
            this.slime = slimeIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return this.slime.func_70638_az() == null && (this.slime.field_70122_E || this.slime.func_70090_H() || this.slime.func_180799_ab() || this.slime.func_70644_a(Effects.field_188424_y)) && this.slime.func_70605_aq() instanceof MoveHelperController;
        }

        public void func_75246_d() {
            if (--this.nextRandomizeTime <= 0) {
                this.nextRandomizeTime = 40 + this.slime.func_70681_au().nextInt(60);
                this.chosenDegrees = this.slime.func_70681_au().nextInt(360);
            }
            ((MoveHelperController)this.slime.func_70605_aq()).setDirection(this.chosenDegrees, false);
        }
    }

    static class AttackGoal
    extends Goal {
        private final EntityIronSlime slime;
        private int growTieredTimer;

        public AttackGoal(EntityIronSlime slimeIn) {
            this.slime = slimeIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            LivingEntity livingentity = this.slime.func_70638_az();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.func_70089_S()) {
                return false;
            }
            return livingentity instanceof PlayerEntity && ((PlayerEntity)livingentity).field_71075_bZ.field_75102_a ? false : this.slime.func_70605_aq() instanceof MoveHelperController;
        }

        public void func_75249_e() {
            this.growTieredTimer = 300;
            super.func_75249_e();
        }

        public boolean func_75253_b() {
            LivingEntity livingentity = this.slime.func_70638_az();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.func_70089_S()) {
                return false;
            }
            if (livingentity instanceof PlayerEntity && ((PlayerEntity)livingentity).field_71075_bZ.field_75102_a) {
                return false;
            }
            return --this.growTieredTimer > 0;
        }

        public void func_75246_d() {
            this.slime.func_70625_a((Entity)this.slime.func_70638_az(), 10.0f, 10.0f);
            ((MoveHelperController)this.slime.func_70605_aq()).setDirection(this.slime.field_70177_z, this.slime.canDamagePlayer());
        }
    }

    static class AIReturnHome
    extends Goal {
        private final EntityIronSlime slime;
        private int growTieredTimer;

        public AIReturnHome(EntityIronSlime slimeIn) {
            this.slime = slimeIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return !this.slime.func_213383_dH() && !this.slime.func_233580_cy_().equals((Object)this.slime.func_213384_dI());
        }

        public void func_75249_e() {
            super.func_75249_e();
        }

        public boolean func_75253_b() {
            boolean flag = false;
            flag = new AxisAlignedBB(this.slime.func_213384_dI()).func_72326_a(this.slime.func_174813_aQ());
            return !flag;
        }

        public void func_75246_d() {
            this.slime.faceBlockPos(this.slime.func_213384_dI());
            ((MoveHelperController)this.slime.func_70605_aq()).setDirection(this.slime.field_70177_z, this.slime.canDamagePlayer());
        }
    }

    static class FloatGoal
    extends Goal {
        private final EntityIronSlime slime;

        public FloatGoal(EntityIronSlime slimeIn) {
            this.slime = slimeIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
            slimeIn.func_70661_as().func_212239_d(true);
        }

        public boolean func_75250_a() {
            return (this.slime.func_70090_H() || this.slime.func_180799_ab()) && this.slime.func_70605_aq() instanceof MoveHelperController;
        }

        public void func_75246_d() {
            if (this.slime.func_70681_au().nextFloat() < 0.8f) {
                this.slime.func_70683_ar().func_75660_a();
            }
            ((MoveHelperController)this.slime.func_70605_aq()).setSpeed(1.2);
        }
    }
}

