/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.entity.boss;

import com.dainxt.dungeonsmod.ai.AIScheduledTimedAction;
import com.dainxt.dungeonsmod.ai.AIToggableMultipleTargetGoal;
import com.dainxt.dungeonsmod.config.DungeonsModConfig;
import com.dainxt.dungeonsmod.difficulty.DifficultyManager;
import com.dainxt.dungeonsmod.entity.projectile.EntityItemThrow;
import com.dainxt.dungeonsmod.interfaces.IMultiTargetEntity;
import com.dainxt.dungeonsmod.items.KingsCrownItem;
import com.dainxt.dungeonsmod.util.EntityUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.BossInfo;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.Explosion;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraft.world.server.ServerWorld;

public class EntityKing
extends MonsterEntity
implements IMultiTargetEntity {
    DifficultyManager difficultyManager = new DifficultyManager();
    static final int MAX_HOME = 7;
    public ArrayList<BlockPos> SACRIFICE_PLACES;
    public ArrayList<BlockPos> BOOKSHELFS;
    public Map<BlockPos, BlockState> DESTROY_BLOCKS_2;
    public Map<BlockPos, BlockState> FIX_BLOCKS_2;
    public ArrayList<LivingEntity> otherAttackTargets = new ArrayList();
    private static final DataParameter<Boolean> THROWING = EntityDataManager.func_187226_a(EntityKing.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> REST = EntityDataManager.func_187226_a(EntityKing.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> HEAVY_ATTACK = EntityDataManager.func_187226_a(EntityKing.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_WAITING_FOR_SACRIFICE = EntityDataManager.func_187226_a(EntityKing.class, (IDataSerializer)DataSerializers.field_187198_h);
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.PURPLE, BossInfo.Overlay.NOTCHED_6).func_186741_a(true);
    public AIReturnHome returnHome;
    public ThrowWeaponGoal throwGoal;
    public AIToggableMultipleTargetGoal<? extends LivingEntity> throwTarget;
    public AIToggableMultipleTargetGoal<? extends LivingEntity> bookShelfTarget;

    public EntityKing(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        if (!worldIn.field_72995_K) {
            this.DESTROY_BLOCKS_2 = new ConcurrentHashMap<BlockPos, BlockState>();
            this.FIX_BLOCKS_2 = new ConcurrentHashMap<BlockPos, BlockState>();
            this.SACRIFICE_PLACES = new ArrayList();
            this.BOOKSHELFS = new ArrayList();
            this.otherAttackTargets = new ArrayList();
        }
        this.func_184642_a(EquipmentSlotType.HEAD, 2.0f);
        this.func_184642_a(EquipmentSlotType.CHEST, 2.0f);
        this.func_184642_a(EquipmentSlotType.LEGS, 2.0f);
        this.func_184642_a(EquipmentSlotType.FEET, 2.0f);
        this.field_70728_aV = 1000;
        this.func_110163_bv();
    }

    protected ResourceLocation func_184647_J() {
        return DungeonsModConfig.COMMON.king.getLootTable();
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_151013_M));
        this.func_184642_a(EquipmentSlotType.MAINHAND, 0.0f);
        this.func_184201_a(EquipmentSlotType.OFFHAND, new ItemStack((IItemProvider)Items.field_151005_D));
        this.func_184642_a(EquipmentSlotType.OFFHAND, 0.0f);
    }

    public ItemEntity func_70099_a(ItemStack stack, float offsetY) {
        if (stack.func_77973_b() instanceof KingsCrownItem) {
            long totalPlayers = this.bossInfo.func_186757_c().stream().filter(EntityPredicates.field_188444_d).count();
            float totalChance = MathHelper.func_76131_a((float)((float)((Double)DungeonsModConfig.COMMON.legendaryLootChance.get() * (double)totalPlayers)), (float)0.0f, (float)100.0f);
            if (this.field_70170_p.func_201674_k().nextFloat() < totalChance / 100.0f) {
                return super.func_70099_a(stack, offsetY);
            }
            return super.func_70099_a(ItemStack.field_190927_a, offsetY);
        }
        return super.func_70099_a(stack, offsetY);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = false;
        if (this.isHeavyAttacking()) {
            EquipmentSlotType randomSlot;
            Item wearedItem;
            PlayerEntity target;
            flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this).func_82726_p(), (float)this.func_233637_b_(Attributes.field_233823_f_));
            if (entityIn instanceof PlayerEntity && !(target = (PlayerEntity)entityIn).func_184585_cz() && (wearedItem = target.func_184582_a(randomSlot = EquipmentSlotType.func_220318_a((EquipmentSlotType.Group)EquipmentSlotType.Group.ARMOR, (int)this.field_70170_p.func_201674_k().nextInt(4))).func_77973_b()) instanceof ArmorItem && !((ArmorItem)wearedItem).func_200880_d().equals(ArmorMaterial.GOLD)) {
                if (randomSlot.func_188452_c() == 4) {
                    this.func_184201_a(EquipmentSlotType.HEAD, target.func_184582_a(randomSlot));
                    ItemStack newPiece = new ItemStack((IItemProvider)Items.field_151169_ag);
                    newPiece.func_77966_a(Enchantments.field_190941_k, 1);
                    target.func_184201_a(EquipmentSlotType.HEAD, newPiece);
                } else if (randomSlot.func_188452_c() == 3) {
                    this.func_184201_a(EquipmentSlotType.CHEST, target.func_184582_a(randomSlot));
                    ItemStack newPiece = new ItemStack((IItemProvider)Items.field_151171_ah);
                    newPiece.func_77966_a(Enchantments.field_190941_k, 1);
                    target.func_184201_a(EquipmentSlotType.CHEST, newPiece);
                } else if (randomSlot.func_188452_c() == 2) {
                    this.func_184201_a(EquipmentSlotType.LEGS, target.func_184582_a(randomSlot));
                    ItemStack newPiece = new ItemStack((IItemProvider)Items.field_151149_ai);
                    newPiece.func_77966_a(Enchantments.field_190941_k, 1);
                    target.func_184201_a(EquipmentSlotType.LEGS, newPiece);
                } else if (randomSlot.func_188452_c() == 1) {
                    this.func_184201_a(EquipmentSlotType.FEET, target.func_184582_a(randomSlot));
                    ItemStack newPiece = new ItemStack((IItemProvider)Items.field_151151_aj);
                    newPiece.func_77966_a(Enchantments.field_190941_k, 1);
                    target.func_184201_a(EquipmentSlotType.FEET, newPiece);
                }
            }
            this.setHeavyAttack(false);
        } else {
            flag = super.func_70652_k(entityIn);
        }
        LivingEntity a = (LivingEntity)entityIn;
        a.func_213322_ci().func_72430_b(Vector3d.field_186680_a);
        return flag;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(THROWING, (Object)false);
        this.field_70180_af.func_187214_a(HEAVY_ATTACK, (Object)false);
        this.field_70180_af.func_187214_a(IS_WAITING_FOR_SACRIFICE, (Object)false);
        this.field_70180_af.func_187214_a(REST, (Object)true);
    }

    public boolean isHeavyAttacking() {
        return (Boolean)this.func_184212_Q().func_187225_a(HEAVY_ATTACK);
    }

    public void setHeavyAttack(boolean attack) {
        this.func_184212_Q().func_187227_b(HEAVY_ATTACK, (Object)attack);
    }

    public boolean isWaitingSacrifice() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_WAITING_FOR_SACRIFICE);
    }

    public void setWaitingSacrifice(boolean attack) {
        this.func_184212_Q().func_187227_b(IS_WAITING_FOR_SACRIFICE, (Object)attack);
    }

    public boolean isResting() {
        return (Boolean)this.func_184212_Q().func_187225_a(REST);
    }

    public void setRest(boolean attack) {
        this.func_184212_Q().func_187227_b(REST, (Object)attack);
    }

    public boolean isThrowingWeapon() {
        return (Boolean)this.func_184212_Q().func_187225_a(THROWING);
    }

    public void setThrowingWeapon(boolean attack) {
        this.func_184212_Q().func_187227_b(THROWING, (Object)attack);
    }

    @Override
    public void setAttackTargets(ArrayList<LivingEntity> players) {
        this.otherAttackTargets = players;
    }

    @Override
    public ArrayList<LivingEntity> getAttackTargets() {
        return this.otherAttackTargets;
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficulty, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        this.func_70107_b((int)this.func_226277_ct_(), this.func_226278_cu_(), (int)this.func_226281_cx_());
        if (!this.func_213394_dL()) {
            this.func_213390_a(this.func_233580_cy_(), 7);
        }
        this.func_180481_a(difficulty);
        return super.func_213386_a(worldIn, difficulty, reason, spawnDataIn, dataTag);
    }

    public void func_70020_e(CompoundNBT compound) {
        int i;
        CompoundNBT nbt;
        super.func_70020_e(compound);
        BlockPos homePos = BlockPos.func_218283_e((long)compound.func_74763_f("HomePosition"));
        if (!homePos.equals((Object)BlockPos.field_177992_a)) {
            this.func_213390_a(homePos, 7);
        }
        this.setWaitingSacrifice(compound.func_74767_n("WaitSac"));
        this.setHeavyAttack(compound.func_74767_n("HeavyAttack"));
        if (!this.field_70170_p.field_72995_K) {
            nbt = compound.func_74775_l("sacPos");
            for (i = 0; i < nbt.func_74762_e("index"); ++i) {
                this.SACRIFICE_PLACES.add(BlockPos.func_218283_e((long)nbt.func_74763_f("sacrifice_" + i)));
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            nbt = compound.func_74775_l("shelfPos");
            for (i = 0; i < nbt.func_74762_e("index"); ++i) {
                this.BOOKSHELFS.add(BlockPos.func_218283_e((long)nbt.func_74763_f("shelf_" + i)));
            }
        }
    }

    public CompoundNBT func_189511_e(CompoundNBT compound) {
        int i;
        CompoundNBT nbt;
        if (this.func_213394_dL()) {
            compound.func_74772_a("HomePosition", this.func_213384_dI().func_218275_a());
        }
        compound.func_74757_a("WaitSac", this.isWaitingSacrifice());
        compound.func_74757_a("HeavyAttack", this.isHeavyAttacking());
        if (!this.field_70170_p.field_72995_K) {
            nbt = compound.func_74775_l("sacPos");
            nbt.func_74768_a("index", this.SACRIFICE_PLACES.size());
            for (i = 0; i < this.SACRIFICE_PLACES.size(); ++i) {
                nbt.func_74772_a("sacrifice_" + i, this.SACRIFICE_PLACES.get(i).func_218275_a());
            }
            compound.func_218657_a("sacPos", (INBT)nbt);
        }
        if (!this.field_70170_p.field_72995_K) {
            nbt = compound.func_74775_l("shelfPos");
            nbt.func_74768_a("index", this.BOOKSHELFS.size());
            for (i = 0; i < this.BOOKSHELFS.size(); ++i) {
                nbt.func_74772_a("shelf_" + i, this.BOOKSHELFS.get(i).func_218275_a());
            }
            compound.func_218657_a("shelfPos", (INBT)nbt);
        }
        return super.func_189511_e(compound);
    }

    protected float func_175134_bD() {
        return this.isHeavyAttacking() ? 10.0f : super.func_175134_bD();
    }

    protected void func_184651_r() {
        this.throwGoal = new ThrowWeaponGoal(this, 40, 100);
        this.throwTarget = new AIToggableMultipleTargetGoal<PlayerEntity>((MobEntity)this, PlayerEntity.class);
        this.bookShelfTarget = new AIToggableMultipleTargetGoal<PlayerEntity>((MobEntity)this, PlayerEntity.class);
        this.field_70714_bg.func_75776_a(0, (Goal)new AIFellMad(this, 1200, 800));
        this.field_70714_bg.func_75776_a(1, (Goal)new AIDoHeavyAttack(this, 60, 180));
        this.field_70714_bg.func_75776_a(1, (Goal)this.throwGoal);
        this.returnHome = new AIReturnHome(this);
        this.field_70714_bg.func_75776_a(2, (Goal)this.returnHome);
        this.field_70714_bg.func_75776_a(4, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f, 0.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new BookShelfAttackGoal(this, 40, 200, 3));
        this.field_70715_bh.func_75776_a(1, this.throwTarget);
        this.field_70715_bh.func_75776_a(2, this.bookShelfTarget);
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 0, true, true, null));
        this.field_70715_bh.func_75776_a(4, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
    }

    public static AttributeModifierMap.MutableAttribute createMobAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 80.0).func_233815_a_(Attributes.field_233823_f_, 6.0).func_233815_a_(Attributes.field_233821_d_, 0.22).func_233815_a_(Attributes.field_233819_b_, 18.0).func_233815_a_(Attributes.field_233826_i_, 15.0).func_233815_a_(Attributes.field_233820_c_, 1.0);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76364_f() instanceof ArrowEntity) {
            ((ArrowEntity)source.func_76364_f()).func_70240_a(0);
        }
        if (source.equals(DamageSource.field_76368_d)) {
            EntityUtils.scanBlocksInAABB((LivingEntity)this, (blockPos, blockState) -> {
                Block block = blockState.func_177230_c();
                if (!block.equals(Blocks.field_150357_h)) {
                    this.field_70170_p.func_175656_a(blockPos, Blocks.field_150350_a.func_176223_P());
                }
                return false;
            });
        }
        return super.func_70097_a(source, amount);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197623_p, this.func_226282_d_(0.5), this.func_226279_cv_() - 0.25, this.func_226287_g_(0.5), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
            }
        }
    }

    private void destroyPosInAABB(AxisAlignedBB axisBB, Map<BlockPos, BlockState> blockPos, boolean shouldDrop) {
        for (Map.Entry<BlockPos, BlockState> entrySet : blockPos.entrySet()) {
            if (!axisBB.func_72326_a(new AxisAlignedBB(entrySet.getKey()))) continue;
            if (!this.SACRIFICE_PLACES.contains(entrySet.getKey()) || !this.isWaitingSacrifice() || Blocks.field_150340_R == entrySet.getValue().func_177230_c()) {
                this.func_184609_a(Hand.MAIN_HAND);
                this.field_70170_p.func_175655_b(entrySet.getKey(), false);
            }
            blockPos.remove(entrySet.getKey());
        }
    }

    private void placePosInAABB(AxisAlignedBB axisBB, Map<BlockPos, BlockState> blockPos, boolean shouldDrop) {
        for (Map.Entry<BlockPos, BlockState> entrySet : blockPos.entrySet()) {
            if (!axisBB.func_72326_a(new AxisAlignedBB(entrySet.getKey()))) continue;
            if (!this.SACRIFICE_PLACES.contains(entrySet.getKey()) || !this.isWaitingSacrifice() || Blocks.field_150340_R == entrySet.getValue().func_177230_c()) {
                this.func_184609_a(Hand.MAIN_HAND);
                this.field_70170_p.func_175656_a(entrySet.getKey(), entrySet.getValue());
            }
            blockPos.remove(entrySet.getKey());
        }
    }

    public boolean goHome(float speed) {
        BlockPos pos = this.func_213384_dI();
        if (!this.func_233580_cy_().equals((Object)pos) && !this.func_70661_as().func_75492_a((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), (double)speed)) {
            this.func_213317_d(Vector3d.field_186680_a);
            this.func_70107_b(pos.func_177958_n(), (float)pos.func_177956_o() + 0.1f, pos.func_177952_p());
        }
        return new AxisAlignedBB(this.func_213384_dI()).func_72326_a(this.func_174813_aQ());
    }

    protected void func_191955_a(BlockState blockstate) {
        Block block = blockstate.func_177230_c();
        if (block == Blocks.field_150433_aE || block instanceof FlowingFluidBlock) {
            EntityUtils.scanBlocksInAABB((LivingEntity)this, this.func_174813_aQ().func_186662_g(1.0), (blockPos, blockState) -> {
                if (!blockState.func_177230_c().equals(Blocks.field_150357_h) && block.equals(blockState.func_177230_c())) {
                    this.field_70170_p.func_175656_a(blockPos, Blocks.field_150350_a.func_176223_P());
                }
                return false;
            });
            this.func_184609_a(Hand.MAIN_HAND);
        }
        super.func_191955_a(blockstate);
    }

    public static DamageSource causeKingDamage(Entity source, @Nullable Entity indirectEntityIn) {
        return new IndirectEntityDamageSource("kingRuleBreak", source, indirectEntityIn).func_76348_h().func_82726_p();
    }

    public void func_70645_a(DamageSource cause) {
        if (!this.field_70170_p.field_72995_K && this.isWaitingSacrifice()) {
            this.func_184642_a(EquipmentSlotType.HEAD, 0.0f);
            this.func_184642_a(EquipmentSlotType.CHEST, 0.0f);
            this.func_184642_a(EquipmentSlotType.LEGS, 0.0f);
            this.func_184642_a(EquipmentSlotType.FEET, 0.0f);
            BlockPos pos = this.func_233580_cy_();
            this.field_70729_aU = true;
            this.field_70170_p.func_217385_a((Entity)this, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 40.0f, Explosion.Mode.DESTROY);
            this.field_70170_p.func_180501_a(pos, Blocks.field_150486_ae.func_176223_P(), 3);
            Arrays.stream(Direction.values()).forEach(facing -> this.field_70170_p.func_180501_a(pos.func_177972_a(facing), Blocks.field_150343_Z.func_176223_P(), 3));
            TileEntity tileentity = this.field_70170_p.func_175625_s(pos);
            if (tileentity instanceof ChestTileEntity) {
                ((ChestTileEntity)tileentity).func_70299_a(11, this.func_184582_a(EquipmentSlotType.HEAD));
                ((ChestTileEntity)tileentity).func_70299_a(12, this.func_184582_a(EquipmentSlotType.CHEST));
                ((ChestTileEntity)tileentity).func_70299_a(14, this.func_184582_a(EquipmentSlotType.LEGS));
                ((ChestTileEntity)tileentity).func_70299_a(15, this.func_184582_a(EquipmentSlotType.FEET));
            }
            this.func_70106_y();
        }
        super.func_70645_a(cause);
    }

    protected void func_226294_cV_() {
        this.field_70728_aV = (int)((long)this.field_70728_aV + (long)MathHelper.func_76123_f((float)((float)this.field_70728_aV * 0.1f)) * this.bossInfo.func_186757_c().stream().filter(EntityPredicates.field_188444_d).count());
        super.func_226294_cV_();
    }

    public boolean func_184222_aU() {
        return false;
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (((Boolean)DungeonsModConfig.COMMON.scalingDifficulty.get()).booleanValue()) {
            this.difficultyManager.adjustDifficulty((LivingEntity)this, 0.3f, 0.1f, 0.05f, 0.1f, this.bossInfo.func_186757_c());
        }
        if (this.func_70638_az() != null) {
            this.setRest(false);
        }
        if (this.isResting()) {
            this.field_70177_z = -90.0f;
            this.field_70759_as = -90.0f;
        }
        if (!this.DESTROY_BLOCKS_2.isEmpty()) {
            this.destroyPosInAABB(this.func_174813_aQ().func_186662_g(3.5), this.DESTROY_BLOCKS_2, true);
        }
        if (!this.FIX_BLOCKS_2.isEmpty()) {
            this.placePosInAABB(this.func_174813_aQ().func_186662_g(3.5), this.FIX_BLOCKS_2, true);
        }
        float distance = Float.MAX_VALUE;
        for (PlayerEntity playerEntity : this.getPlayers()) {
            if (playerEntity.func_184607_cu().func_77973_b().func_219971_r()) {
                this.throwGoal.setLethalEnemy((LivingEntity)playerEntity);
            }
            distance = Math.min(playerEntity.func_70032_d((Entity)this), distance);
        }
        if (distance > 7.0f && this.returnHome != null) {
            this.returnHome.forceUpdate();
            if (!this.isWaitingSacrifice()) {
                this.func_70691_i(this.func_110138_aP() * 5.0E-4f);
            }
        }
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
        if (this.bossInfo.func_186757_c().isEmpty()) {
            this.func_70606_j(this.func_110138_aP());
        }
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public List<ServerPlayerEntity> getPlayers() {
        return this.bossInfo.func_186757_c().stream().filter(EntityPredicates.field_188444_d).collect(Collectors.toList());
    }

    protected float func_70647_i() {
        return 0.2f;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187915_go;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187913_gm;
    }

    public void func_70623_bb() {
    }

    static class BookShelfAttackGoal
    extends AIScheduledTimedAction {
        private final EntityKing goalOwner;
        List<LivingEntity> targets;

        public BookShelfAttackGoal(EntityKing entity, int maxDuration, int maxCooldown, int times) {
            super((LivingEntity)entity, maxDuration, maxCooldown, times);
            this.goalOwner = entity;
            this.targets = new ArrayList<LivingEntity>();
        }

        @Override
        public boolean func_75250_a() {
            return this.goalOwner.func_70638_az() != null && super.func_75250_a();
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
            this.goalOwner.bookShelfTarget.func_220783_a(true);
        }

        public void func_75246_d() {
            super.func_75246_d();
            int maxShelfs = MathHelper.func_76141_d((float)(6.0f * (1.0f - this.goalOwner.func_110143_aJ() / this.goalOwner.func_110138_aP()))) + 1;
            if (this.targets.isEmpty()) {
                this.targets = this.goalOwner.getAttackTargets().stream().collect(Collectors.toList());
            }
            if (this.goalOwner.BOOKSHELFS.isEmpty()) {
                for (int i = 1; i <= maxShelfs; ++i) {
                    BlockPos shelfPos;
                    Collections.shuffle(this.targets);
                    LivingEntity target = null;
                    if (!this.targets.isEmpty()) {
                        target = this.targets.get(0);
                    }
                    if (target == null || (shelfPos = new BlockPos(target.func_226282_d_(3.0), target.func_226278_cu_() + 5.0, this.goalOwner.func_226287_g_(3.0))) == null || this.goalOwner.field_70170_p.func_180495_p(shelfPos).func_177230_c() == Blocks.field_150342_X) continue;
                    if (!this.goalOwner.func_174814_R()) {
                        this.goalOwner.field_70170_p.func_184133_a(null, shelfPos, SoundEvents.field_187885_gS, SoundCategory.HOSTILE, 20.0f, 0.5f);
                    }
                    ((ServerWorld)this.goalOwner.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197598_I, (double)shelfPos.func_177958_n(), (double)shelfPos.func_177956_o(), (double)shelfPos.func_177952_p(), 4, (this.goalOwner.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.goalOwner.field_70146_Z.nextDouble(), (this.goalOwner.field_70146_Z.nextDouble() - 0.5) * 2.0, (this.goalOwner.field_70146_Z.nextDouble() - 0.5) * 2.0);
                    this.goalOwner.field_70170_p.func_175656_a(shelfPos, Blocks.field_150342_X.func_176223_P());
                    this.goalOwner.BOOKSHELFS.add(shelfPos);
                }
            }
        }

        @Override
        public void onStartCycle() {
            this.goalOwner.BOOKSHELFS.forEach(shelfPos -> {
                Collections.shuffle(this.targets);
                LivingEntity target = null;
                if (!this.targets.isEmpty()) {
                    target = this.targets.get(0);
                }
                if (target != null) {
                    EntityItemThrow projectile = new EntityItemThrow(this.goalOwner.field_70170_p, new ItemStack((IItemProvider)Items.field_151122_aG), (impactProjectile, entity) -> entity.func_70097_a(EntityKing.causeKingDamage(impactProjectile, (Entity)this.goalOwner), 10.0f));
                    if (!this.goalOwner.func_174814_R()) {
                        this.goalOwner.field_70170_p.func_184133_a(null, shelfPos, SoundEvents.field_190021_aL, SoundCategory.HOSTILE, 20.0f, 0.5f);
                    }
                    Vector3d finalPos = new Vector3d((double)shelfPos.func_177958_n(), (double)((float)shelfPos.func_177956_o() - 1.0f), (double)shelfPos.func_177952_p());
                    Vector3d difference = target.func_174824_e(1.0f).func_178788_d(finalPos);
                    projectile.func_70107_b(finalPos.field_72450_a, finalPos.field_72448_b, finalPos.field_72449_c);
                    projectile.func_212361_a((Entity)this.goalOwner);
                    projectile.func_70186_c(difference.field_72450_a, difference.field_72448_b, difference.field_72449_c, 0.75f, 0.0f);
                    this.goalOwner.field_70170_p.func_217376_c((Entity)projectile);
                }
            });
        }

        @Override
        public void func_75251_c() {
            super.func_75251_c();
            this.goalOwner.BOOKSHELFS.forEach(shelfPos -> {
                if (shelfPos != null) {
                    this.goalOwner.field_70170_p.func_175656_a(shelfPos, Blocks.field_150350_a.func_176223_P());
                    if (!this.goalOwner.func_174814_R()) {
                        this.goalOwner.field_70170_p.func_184133_a(null, shelfPos, SoundEvents.field_187883_gR, SoundCategory.HOSTILE, 20.0f, 0.5f);
                    }
                    ((ServerWorld)this.goalOwner.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197598_I, (double)shelfPos.func_177958_n(), (double)shelfPos.func_177956_o(), (double)shelfPos.func_177952_p(), 4, (this.goalOwner.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.goalOwner.field_70146_Z.nextDouble(), (this.goalOwner.field_70146_Z.nextDouble() - 0.5) * 2.0, (this.goalOwner.field_70146_Z.nextDouble() - 0.5) * 2.0);
                }
            });
            this.goalOwner.BOOKSHELFS.clear();
            this.targets.clear();
            this.goalOwner.bookShelfTarget.func_220783_a(false);
        }
    }

    static class ThrowWeaponGoal
    extends AIScheduledTimedAction {
        private final EntityKing goalOwner;
        private LivingEntity target = null;
        private boolean isLethal = false;

        public ThrowWeaponGoal(EntityKing entity, int maxDuration, int maxCooldown) {
            super((LivingEntity)entity, maxDuration, maxCooldown);
            this.goalOwner = entity;
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
        }

        @Override
        public boolean func_75250_a() {
            return this.goalOwner.func_70638_az() != null && super.func_75250_a() || this.isLethal;
        }

        public void setLethalEnemy(LivingEntity enemy) {
            this.target = enemy;
            this.isLethal = true;
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
            this.goalOwner.throwTarget.func_220783_a(true);
            this.goalOwner.setThrowingWeapon(true);
        }

        public void func_75246_d() {
            super.func_75246_d();
            if (this.target == null) {
                LivingEntity potential;
                if (!this.goalOwner.getAttackTargets().isEmpty() && (potential = this.goalOwner.getAttackTargets().get(this.goalOwner.field_70146_Z.nextInt(this.goalOwner.getAttackTargets().size()))) != null && this.target != this.goalOwner.func_70638_az()) {
                    this.target = potential;
                }
            } else {
                this.goalOwner.func_70671_ap().func_75651_a((Entity)this.target, 30.0f, 30.0f);
            }
        }

        @Override
        public void onStartCycle() {
            if (this.target != null) {
                if (!this.goalOwner.func_174814_R()) {
                    SoundEvent soundevent = SoundEvents.field_187511_aA;
                    this.goalOwner.func_184185_a(soundevent, 20.0f, 0.2f);
                }
                Vector3d originalPos = this.goalOwner.func_174824_e(1.0f);
                Vector3d direction = Vector3d.field_186680_a.func_72441_c(1.0, -0.75, 1.0).func_186678_a(1.5).func_178785_b(-this.goalOwner.field_70761_aq * ((float)Math.PI / 180));
                Vector3d finalPos = originalPos.func_178787_e(direction);
                Vector3d difference = this.target.func_174824_e(1.0f).func_178788_d(finalPos);
                EntityItemThrow projectile = new EntityItemThrow(this.goalOwner.field_70170_p, this.goalOwner.func_184582_a(EquipmentSlotType.OFFHAND), (impactProjectile, entity) -> {
                    if (!this.isLethal) {
                        entity.func_70097_a(DamageSource.func_76354_b((Entity)impactProjectile, (Entity)this.goalOwner), 1.0f * entity.func_70032_d((Entity)this.goalOwner));
                    } else {
                        entity.func_70097_a(EntityKing.causeKingDamage(impactProjectile, (Entity)this.goalOwner).func_151518_m().func_76348_h(), entity.func_110138_aP() * 10.0f);
                    }
                });
                projectile.func_70107_b(finalPos.field_72450_a, finalPos.field_72448_b, finalPos.field_72449_c);
                projectile.func_212361_a((Entity)this.goalOwner);
                projectile.func_70186_c(difference.field_72450_a, difference.field_72448_b, difference.field_72449_c, this.isLethal ? 4.5f : 1.5f, 0.0f);
                this.goalOwner.field_70170_p.func_217376_c((Entity)projectile);
            }
        }

        @Override
        public void func_75251_c() {
            super.func_75251_c();
            this.isLethal = false;
            this.target = null;
            this.goalOwner.throwTarget.func_220783_a(false);
            this.goalOwner.setThrowingWeapon(false);
        }
    }

    class AIDoHeavyAttack
    extends AIScheduledTimedAction {
        EntityKing king;

        public AIDoHeavyAttack(EntityKing entity, int maxDuration, int maxCooldown) {
            super((LivingEntity)entity, maxDuration, maxCooldown);
            this.king = entity;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        @Override
        public boolean func_75250_a() {
            if (this.king.func_70638_az() != null) {
                return super.func_75250_a();
            }
            return false;
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
            this.king.setHeavyAttack(true);
        }

        public void func_75246_d() {
            super.func_75246_d();
            Vector3d originalPos = this.king.func_174824_e(1.0f);
            Vector3d direction = this.king.func_70676_i(1.0f).func_186678_a(2.5);
            Vector3d finalPos = originalPos.func_178787_e(direction);
            ((ServerWorld)this.king.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197598_I, finalPos.func_82615_a(), finalPos.func_82617_b() - 0.5, finalPos.func_82616_c(), 4, (this.king.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.king.field_70146_Z.nextDouble(), (this.king.field_70146_Z.nextDouble() - 0.5) * 2.0, (this.king.field_70146_Z.nextDouble() - 0.5) * 2.0);
        }

        @Override
        public void onStartCycle() {
            super.onStartCycle();
        }

        @Override
        public void func_75251_c() {
            super.func_75251_c();
        }
    }

    class AIFellMad
    extends AIScheduledTimedAction {
        EntityKing king;
        float initialHealth;

        public AIFellMad(EntityKing entity, int maxDuration, int maxCooldown) {
            super((LivingEntity)entity, maxDuration, maxCooldown);
            this.king = entity;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        @Override
        public boolean func_75250_a() {
            if (this.king.func_70638_az() != null) {
                return super.func_75250_a();
            }
            return false;
        }

        @Override
        public boolean func_75253_b() {
            return super.func_75253_b() && this.king.isWaitingSacrifice();
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
            this.king.setWaitingSacrifice(true);
            this.king.func_226284_e_(true);
            this.initialHealth = this.king.func_110143_aJ();
        }

        public void func_75246_d() {
            super.func_75246_d();
            if (this.king.goHome(2.0f)) {
                for (BlockPos pos : this.king.SACRIFICE_PLACES) {
                    if (Blocks.field_150340_R != this.attacker.field_70170_p.func_180495_p(pos).func_177230_c()) continue;
                    this.king.setWaitingSacrifice(false);
                    this.attacker.field_70170_p.func_175655_b(pos, false);
                    break;
                }
                if (this.king.isWaitingSacrifice()) {
                    this.king.func_70097_a(DamageSource.field_76376_m, 10.0f);
                }
            }
        }

        @Override
        public void func_75251_c() {
            super.func_75251_c();
            this.king.setWaitingSacrifice(false);
            this.king.func_226284_e_(false);
            this.attacker.func_70606_j(this.initialHealth);
        }
    }

    static class AIReturnHome
    extends Goal {
        private boolean force;
        private final EntityKing slime;

        public void forceUpdate() {
            this.force = true;
        }

        public AIReturnHome(EntityKing slimeIn) {
            this.slime = slimeIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return !this.slime.func_213383_dH() && !this.slime.func_233580_cy_().equals((Object)this.slime.func_213384_dI()) || this.force;
        }

        public void func_75249_e() {
            this.force = false;
            super.func_75249_e();
        }

        public boolean func_75253_b() {
            boolean flag;
            boolean bl = flag = !this.slime.goHome(1.5f);
            if (!flag) {
                this.slime.setRest(true);
            }
            return flag;
        }

        public void func_75251_c() {
            super.func_75251_c();
        }
    }
}

