/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.entity.boss;

import com.dainxt.dungeonsmod.config.DungeonsModConfig;
import com.dainxt.dungeonsmod.difficulty.DifficultyManager;
import com.dainxt.dungeonsmod.entity.EntityExtraPart;
import com.dainxt.dungeonsmod.interfaces.IEntityExtraPart;
import com.dainxt.dungeonsmod.util.EntityUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.LookController;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShieldItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.BossInfo;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;

public class EntityKraken
extends MonsterEntity
implements IEntityExtraPart {
    DifficultyManager difficultyManager = new DifficultyManager();
    public ArrayList<EntityExtraPart> extraParts;
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.BLUE, BossInfo.Overlay.PROGRESS).func_186741_a(true);
    protected RandomWalkingGoal wander;

    public EntityKraken(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.extraParts = new ArrayList();
        this.field_70158_ak = true;
        this.field_70728_aV = 700;
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.func_184644_a(PathNodeType.OPEN, -1.0f);
        this.field_70765_h = new MoveHelperController(this);
        this.func_110163_bv();
    }

    protected ResourceLocation func_184647_J() {
        return DungeonsModConfig.COMMON.kraken.getLootTable();
    }

    public ItemEntity func_70099_a(ItemStack stack, float offsetY) {
        if (stack.func_77973_b() instanceof ShieldItem) {
            long totalPlayers = this.bossInfo.func_186757_c().stream().filter(EntityPredicates.field_188444_d).count();
            float totalChance = MathHelper.func_76131_a((float)((float)((Double)DungeonsModConfig.COMMON.legendaryLootChance.get() * (double)totalPlayers)), (float)0.0f, (float)100.0f);
            if (this.field_70170_p.func_201674_k().nextFloat() < totalChance / 100.0f) {
                return super.func_70099_a(stack, offsetY);
            }
            return super.func_70099_a(ItemStack.field_190927_a, offsetY);
        }
        return super.func_70099_a(stack, offsetY);
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new SwimmerPathNavigator((MobEntity)this, worldIn);
    }

    public boolean func_204231_K() {
        return this.func_70090_H();
    }

    public boolean func_70648_aU() {
        return true;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_203100_e;
    }

    public float func_205022_a(BlockPos pos, IWorldReader worldIn) {
        return worldIn.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a) ? 10.0f + worldIn.func_205052_D(pos) - 0.5f : super.func_205022_a(pos, worldIn);
    }

    protected void func_82167_n(Entity entityIn) {
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_205019_a(IWorldReader worldIn) {
        return true;
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = super.func_70652_k(entityIn);
        if (flag && entityIn instanceof PlayerEntity && this.getParts().stream().anyMatch(part -> part.isAlivePart()) && this.func_70681_au().nextInt(3) == 0) {
            entityIn.func_213317_d(entityIn.func_213322_ci().func_178787_e(new Vector3d(0.0, 30.0, 0.0)));
            ((LivingEntity)entityIn).func_195064_c(new EffectInstance(Effects.field_76431_k, 200, 1));
            ((LivingEntity)entityIn).func_195064_c(new EffectInstance(Effects.field_76438_s, 100, 5));
        }
        return flag;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        MoveTowardsRestrictionGoal movetowardsrestrictiongoal = new MoveTowardsRestrictionGoal((CreatureEntity)this, 1.0);
        this.wander = new KrakenMoveRandomGoal((CreatureEntity)this, 1.0, 60, false);
        this.field_70714_bg.func_75776_a(4, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (Goal)movetowardsrestrictiongoal);
        this.field_70714_bg.func_75776_a(7, (Goal)this.wander);
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 20.0f, 1.0f));
        this.wander.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        movetowardsrestrictiongoal.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, LivingEntity.class, 0, false, false, (Predicate)((Object)new KrakenTargetSelector(this))));
    }

    public void func_213352_e(Vector3d travelVector) {
        if (this.func_70613_aW()) {
            this.func_213309_a(0.1f, travelVector);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
            if (this.func_70638_az() == null) {
                if (this.func_70781_l() && this.field_205013_W) {
                    this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, 0.01, 0.0));
                }
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.005, 0.0));
            } else if (this.field_205013_W) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, 0.001 * (this.func_70638_az().func_226278_cu_() - this.func_213303_ch().func_82617_b()), 0.0));
            }
        } else {
            super.func_213352_e(travelVector);
        }
    }

    public static AttributeModifierMap.MutableAttribute createMobAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 200.0).func_233815_a_(Attributes.field_233823_f_, 10.0).func_233815_a_(Attributes.field_233821_d_, 0.3).func_233815_a_(Attributes.field_233819_b_, 30.0).func_233815_a_(Attributes.field_233826_i_, 10.0).func_233815_a_(Attributes.field_233820_c_, 1.0);
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        EntityExtraPart krakenPartTentacle1 = new EntityExtraPart((MobEntity)this, "tentacle1", 6.0f, 6.0f);
        EntityExtraPart krakenPartTentacle2 = new EntityExtraPart((MobEntity)this, "tentacle2", 6.0f, 6.0f);
        EntityExtraPart krakenPartTentacle3 = new EntityExtraPart((MobEntity)this, "tentacle3", 6.0f, 6.0f);
        EntityExtraPart krakenPartTentacle4 = new EntityExtraPart((MobEntity)this, "tentacle4", 6.0f, 6.0f);
        EntityExtraPart krakenPartTentacle5 = new EntityExtraPart((MobEntity)this, "tentacle5", 6.0f, 6.0f);
        EntityExtraPart krakenPartTentacle6 = new EntityExtraPart((MobEntity)this, "tentacle6", 6.0f, 6.0f);
        EntityExtraPart krakenPartTentacle7 = new EntityExtraPart((MobEntity)this, "tentacle7", 6.0f, 6.0f);
        EntityExtraPart krakenPartTentacle8 = new EntityExtraPart((MobEntity)this, "tentacle8", 6.0f, 6.0f);
        this.extraParts.addAll(Arrays.asList(krakenPartTentacle1, krakenPartTentacle2, krakenPartTentacle3, krakenPartTentacle4, krakenPartTentacle5, krakenPartTentacle6, krakenPartTentacle7, krakenPartTentacle8));
        this.spawnExtraParts(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void spawnExtraParts(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        for (EntityExtraPart extraPart : this.extraParts) {
            extraPart.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0f, 0.0f);
            extraPart.func_213386_a(worldIn, difficultyIn, reason, new EntityExtraPart.GroupData(EntityExtraPart.ExtraPartType.TENTACLE), dataTag);
            worldIn.func_217376_c((Entity)extraPart);
        }
    }

    public Vector3d getPositionFromVector(Vector3d origin, float yawOffset, float pitchOffset, double distanceOrigin) {
        float yaw = this.field_70761_aq + yawOffset;
        float pitch = this.field_70125_A + pitchOffset;
        float yawSin = MathHelper.func_76126_a((float)((float)((double)yaw * (Math.PI / 180))));
        float yawCos = MathHelper.func_76134_b((float)((float)((double)yaw * (Math.PI / 180))));
        float pitchSin = MathHelper.func_76126_a((float)((float)((double)pitch * (Math.PI / 180))));
        float pitchCos = MathHelper.func_76134_b((float)((float)((double)pitch * (Math.PI / 180))));
        double tentaclePosX = origin.field_72450_a - (double)yawSin * (distanceOrigin * (double)MathHelper.func_76135_e((float)pitchCos));
        double tentaclePosZ = origin.field_72449_c + (double)yawCos * (distanceOrigin * (double)MathHelper.func_76135_e((float)pitchCos));
        double tentaclePosY = origin.field_72448_b - (double)pitchSin * distanceOrigin;
        return new Vector3d(tentaclePosX, tentaclePosY, tentaclePosZ);
    }

    public void setPartBoundingPosition(EntityExtraPart tentacle, float yawOffset, float pitchOffset, double distanceOrigin) {
        Vector3d origin = this.func_213303_ch();
        origin = origin.func_72441_c(0.0, (this.func_174813_aQ().field_72337_e - this.func_174813_aQ().field_72338_b) / 2.0, 0.0);
        this.setPartBoundingPosition(tentacle, origin, yawOffset, pitchOffset, distanceOrigin);
    }

    public void setPartBoundingPosition(EntityExtraPart tentacle, Vector3d origin, float yawOffset, float pitchOffset, double distanceOrigin) {
        if (tentacle != null && tentacle.func_70089_S()) {
            Vector3d finalPos = this.getPositionFromVector(origin, yawOffset, pitchOffset, distanceOrigin);
            Vector3d finalTentaclePos = new Vector3d(finalPos.field_72450_a, finalPos.field_72448_b - (double)(tentacle.func_213302_cg() / 2.0f), finalPos.field_72449_c);
            tentacle.func_213317_d(Vector3d.field_186680_a);
            tentacle.func_70080_a(finalTentaclePos.field_72450_a, finalTentaclePos.field_72448_b, finalTentaclePos.field_72449_c, 0.0f, 0.0f);
            tentacle.func_213317_d(Vector3d.field_186680_a);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        for (EntityExtraPart extraPart : this.getParts()) {
            switch (extraPart.getPartName()) {
                case "tentacle1": {
                    this.setPartBoundingPosition(extraPart, 20.0f, 0.0f, 4.5);
                    break;
                }
                case "tentacle2": {
                    this.setPartBoundingPosition(extraPart, -20.0f, 0.0f, 4.5);
                    break;
                }
                case "tentacle3": {
                    this.setPartBoundingPosition(extraPart, 0.0f, 20.0f, 4.5);
                    break;
                }
                case "tentacle4": {
                    this.setPartBoundingPosition(extraPart, 0.0f, -25.0f, 4.5);
                    break;
                }
                case "tentacle5": {
                    this.setPartBoundingPosition(extraPart, 20.0f, -20.0f, 4.5);
                    break;
                }
                case "tentacle6": {
                    this.setPartBoundingPosition(extraPart, -20.0f, -20.0f, 4.5);
                    break;
                }
                case "tentacle7": {
                    this.setPartBoundingPosition(extraPart, 20.0f, 20.0f, 4.5);
                    break;
                }
                case "tentacle8": {
                    this.setPartBoundingPosition(extraPart, -20.0f, 20.0f, 4.5);
                }
            }
        }
    }

    public void func_70645_a(DamageSource cause) {
        this.getParts().forEach(extraPart -> extraPart.func_70606_j(0.0f));
        super.func_70645_a(cause);
    }

    @Override
    public ArrayList<EntityExtraPart> getParts() {
        return this.extraParts;
    }

    protected void func_226294_cV_() {
        this.field_70728_aV = (int)((long)this.field_70728_aV + (long)MathHelper.func_76123_f((float)((float)this.field_70728_aV * 0.1f)) * this.bossInfo.func_186757_c().stream().filter(EntityPredicates.field_188444_d).count());
        super.func_226294_cV_();
    }

    public boolean func_184222_aU() {
        return false;
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (((Boolean)DungeonsModConfig.COMMON.scalingDifficulty.get()).booleanValue()) {
            this.difficultyManager.adjustDifficulty((LivingEntity)this, 0.25f, 0.1f, 0.1f, 0.05f, this.bossInfo.func_186757_c());
        }
        EntityUtils.scanBlocksInAABB((LivingEntity)this, this.func_174813_aQ().func_186662_g((double)0.1f), (blockPos, blockState) -> {
            int hardness = MathHelper.func_76125_a((int)MathHelper.func_76141_d((float)(blockState.func_185887_b((IBlockReader)this.field_70170_p, blockPos) * 0.5f)), (int)3, (int)Integer.MAX_VALUE);
            if (!blockState.func_177230_c().equals(Blocks.field_150357_h) && !blockState.func_177230_c().equals(Blocks.field_150350_a) && (double)blockPos.func_177956_o() > this.func_226283_e_(0.1f) && this.field_70170_p.field_73012_v.nextInt(hardness) == 0) {
                this.field_70170_p.func_175656_a(blockPos, Blocks.field_150355_j.func_176223_P());
            }
            return false;
        });
        float totalCurrentHealth = this.func_110143_aJ();
        float totalMaxHealth = this.func_110138_aP();
        for (EntityExtraPart extraPart : this.extraParts) {
            if (extraPart.isAlivePart()) {
                this.func_70691_i(0.01f);
            }
            totalCurrentHealth += extraPart.func_110143_aJ();
            totalMaxHealth += extraPart.func_110138_aP();
        }
        this.bossInfo.func_186735_a(totalCurrentHealth / totalMaxHealth);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
        if (this.bossInfo.func_186757_c().isEmpty()) {
            this.func_70606_j(this.func_110138_aP());
        }
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public List<ServerPlayerEntity> getPlayers() {
        return this.bossInfo.func_186757_c().stream().filter(EntityPredicates.field_188444_d).collect(Collectors.toList());
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187829_fQ;
    }

    public void func_70623_bb() {
    }

    public static class KrakenTargetSelector
    implements com.google.common.base.Predicate<LivingEntity> {
        private final EntityKraken parentEntity;

        public KrakenTargetSelector(EntityKraken guardian) {
            this.parentEntity = guardian;
        }

        public boolean apply(@Nullable LivingEntity p_apply_1_) {
            return p_apply_1_ instanceof PlayerEntity && p_apply_1_.func_70068_e((Entity)this.parentEntity) > 4.0;
        }
    }

    static class MoveHelperController
    extends MovementController {
        private final EntityKraken entityGuardian;

        public MoveHelperController(EntityKraken guardian) {
            super((MobEntity)guardian);
            this.entityGuardian = guardian;
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.MOVE_TO && !this.entityGuardian.func_70661_as().func_75500_f()) {
                Vector3d vector3d = new Vector3d(this.field_75646_b - this.entityGuardian.func_226277_ct_(), this.field_75647_c - this.entityGuardian.func_226278_cu_(), this.field_75644_d - this.entityGuardian.func_226281_cx_());
                double d0 = vector3d.func_72433_c();
                double d1 = vector3d.field_72450_a / d0;
                double d2 = vector3d.field_72448_b / d0;
                double d3 = vector3d.field_72449_c / d0;
                float f = (float)(MathHelper.func_181159_b((double)vector3d.field_72449_c, (double)vector3d.field_72450_a) * 57.2957763671875) - 90.0f;
                this.entityGuardian.field_70761_aq = this.entityGuardian.field_70177_z = this.func_75639_a(this.entityGuardian.field_70177_z, f, 90.0f);
                float f1 = (float)(this.field_75645_e * this.entityGuardian.func_233637_b_(Attributes.field_233821_d_));
                float f2 = MathHelper.func_219799_g((float)0.125f, (float)this.entityGuardian.func_70689_ay(), (float)f1);
                this.entityGuardian.func_70659_e(f2);
                LookController lookcontroller = this.entityGuardian.func_70671_ap();
                double d8 = this.entityGuardian.func_226277_ct_() + d1 * 2.0;
                double d9 = this.entityGuardian.func_226280_cw_() + d2 / d0;
                double d10 = this.entityGuardian.func_226281_cx_() + d3 * 2.0;
                double d11 = lookcontroller.func_180423_e();
                double d12 = lookcontroller.func_180422_f();
                double d13 = lookcontroller.func_180421_g();
                if (!lookcontroller.func_180424_b()) {
                    d11 = d8;
                    d12 = d9;
                    d13 = d10;
                }
                this.entityGuardian.func_70671_ap().func_75650_a(MathHelper.func_219803_d((double)0.125, (double)d11, (double)d8), MathHelper.func_219803_d((double)0.125, (double)d12, (double)d9), MathHelper.func_219803_d((double)0.125, (double)d13, (double)d10), 10.0f, 40.0f);
            } else {
                this.entityGuardian.func_70659_e(0.0f);
            }
        }
    }

    public class KrakenMoveRandomGoal
    extends RandomWalkingGoal {
        public KrakenMoveRandomGoal(CreatureEntity creature, double speed, int chance, boolean p_i231550_5_) {
            super(creature, speed, chance, p_i231550_5_);
        }

        protected Vector3d func_190864_f() {
            return RandomPositionGenerator.func_75463_a((CreatureEntity)this.field_75457_a, (int)10, (int)7);
        }
    }
}

