/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.entity.boss;

import com.dainxt.dungeonsmod.ai.AIScheduledTimedAction;
import com.dainxt.dungeonsmod.ai.AIToggableMultipleTargetGoal;
import com.dainxt.dungeonsmod.config.DungeonsModConfig;
import com.dainxt.dungeonsmod.difficulty.DifficultyManager;
import com.dainxt.dungeonsmod.entity.projectile.EntitySunPlanet;
import com.dainxt.dungeonsmod.handlers.ItemRegistries;
import com.dainxt.dungeonsmod.interfaces.IMultiTargetEntity;
import com.dainxt.dungeonsmod.util.EntityUtils;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IChargeableMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.BossInfo;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT, _interface=IChargeableMob.class)
public class EntitySun
extends MobEntity
implements IChargeableMob,
IMultiTargetEntity,
IMob {
    DifficultyManager difficultyManager = new DifficultyManager();
    public ArrayList<EntitySunPlanet> planets;
    public ArrayList<LivingEntity> otherAttackTargets = new ArrayList();
    public float gravityPullYaw = 0.0f;
    private static final DataParameter<Boolean> SOLAR_WIND = EntityDataManager.func_187226_a(EntitySun.class, (IDataSerializer)DataSerializers.field_187198_h);
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.PINK, BossInfo.Overlay.NOTCHED_12).func_186741_a(true);
    public AIToggableMultipleTargetGoal<? extends LivingEntity> windTarget;

    public EntitySun(EntityType<? extends MobEntity> type, World worldIn) {
        super(type, worldIn);
        this.planets = new ArrayList();
        this.field_70728_aV = 3000;
        this.field_70158_ak = true;
        this.field_70765_h = new MoveHelperController(this);
    }

    protected ResourceLocation func_184647_J() {
        return DungeonsModConfig.COMMON.sun.getLootTable();
    }

    public ItemEntity func_70099_a(ItemStack stack, float offsetY) {
        if (stack.func_77973_b().equals(ItemRegistries.SUNCORE_BLOCK)) {
            long totalPlayers = this.bossInfo.func_186757_c().stream().filter(EntityPredicates.field_188444_d).count();
            float totalChance = MathHelper.func_76131_a((float)((float)((Double)DungeonsModConfig.COMMON.legendaryLootChance.get() * (double)totalPlayers)), (float)0.0f, (float)100.0f);
            if (this.field_70170_p.func_201674_k().nextFloat() < totalChance / 100.0f) {
                return super.func_70099_a(stack, offsetY);
            }
            return super.func_70099_a(ItemStack.field_190927_a, offsetY);
        }
        return super.func_70099_a(stack, offsetY);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SOLAR_WIND, (Object)false);
    }

    public boolean isSolarWinding() {
        return (Boolean)this.func_184212_Q().func_187225_a(SOLAR_WIND);
    }

    public void setSolarWinding(boolean attack) {
        this.func_184212_Q().func_187227_b(SOLAR_WIND, (Object)attack);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.field_76373_n.equals("blueDamage")) {
            return super.func_70097_a(source, amount);
        }
        return super.func_70097_a(source, amount * 0.05f);
    }

    public static AttributeModifierMap.MutableAttribute createMobAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 1000.0).func_233815_a_(Attributes.field_233819_b_, 200.0).func_233815_a_(Attributes.field_233821_d_, 0.75).func_233815_a_(Attributes.field_233826_i_, 30.0).func_233815_a_(Attributes.field_233820_c_, 1.0);
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void func_213352_e(Vector3d travelVector) {
        if (!this.field_70170_p.field_72995_K) {
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_233629_a_((LivingEntity)this, false);
        }
    }

    protected void func_184651_r() {
        this.windTarget = new AIToggableMultipleTargetGoal<LivingEntity>(this, LivingEntity.class);
        this.field_70714_bg.func_75776_a(2, (Goal)new AIAttack(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new AIDoSolarWind(this, 20, 200));
        this.field_70714_bg.func_75776_a(5, (Goal)new RandomFlyGoal(this));
        this.field_70714_bg.func_75776_a(6, (Goal)new AIIgniteTargets(this, 20, 100));
        this.field_70715_bh.func_75776_a(1, this.windTarget);
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 0, true, true, null));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, LivingEntity.class, 0, true, true, null));
    }

    protected void func_82167_n(Entity entityIn) {
    }

    public boolean func_70104_M() {
        return false;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187643_bs;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187646_bt;
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    protected float func_70599_aP() {
        return 40.0f;
    }

    public int func_70641_bl() {
        return 1;
    }

    protected void func_226294_cV_() {
        this.field_70728_aV = (int)((long)this.field_70728_aV + (long)MathHelper.func_76123_f((float)((float)this.field_70728_aV * 0.1f)) * this.bossInfo.func_186757_c().stream().filter(EntityPredicates.field_188444_d).count());
        super.func_226294_cV_();
    }

    public boolean func_184222_aU() {
        return false;
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.func_213323_x_();
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197595_F, this.func_226282_d_(0.75), this.func_226279_cv_() - 0.25, this.func_226287_g_(0.75), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197594_E, this.func_226282_d_(0.75), this.func_226279_cv_() - 0.25, this.func_226287_g_(0.75), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
            }
        }
    }

    public static DamageSource causePlanetDamage(Entity source, @Nullable Entity indirectEntityIn) {
        return new IndirectEntityDamageSource("sunPlanet", source, indirectEntityIn).func_76348_h().func_82726_p();
    }

    public static DamageSource causeBlueDamage() {
        return new DamageSource("blueDamage").func_76348_h().func_82726_p();
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (((Boolean)DungeonsModConfig.COMMON.scalingDifficulty.get()).booleanValue()) {
            this.difficultyManager.adjustDifficulty((LivingEntity)this, 1.0f, 0.2f, 0.2f, 0.2f, this.bossInfo.func_186757_c());
        }
        this.gravityPullYaw = (float)this.field_70173_aa * 2.0f;
        Vector3d gravityPull = Vector3d.func_189986_a((float)0.0f, (float)this.gravityPullYaw);
        int maxPlanets = MathHelper.func_76141_d((float)(12.0f * (1.0f - this.func_110143_aJ() / this.func_110138_aP()))) + 1;
        if (this.field_70173_aa % 100 == 0 && this.planets.size() < maxPlanets) {
            EntitySunPlanet projectile = new EntitySunPlanet(this.field_70170_p, new ItemStack((IItemProvider)Items.field_221655_bP), (impactProjectile, entity) -> entity.func_70097_a(EntitySun.causePlanetDamage(impactProjectile, (Entity)this), 10.0f));
            Vector3d finalPos = this.func_174824_e(0.5f).func_178787_e(gravityPull.func_186678_a(5.5));
            projectile.func_70107_b(finalPos.field_72450_a, finalPos.field_72448_b, finalPos.field_72449_c);
            projectile.func_212361_a((Entity)this);
            this.field_70170_p.func_217376_c((Entity)projectile);
            this.planets.add(projectile);
        } else {
            this.planets.removeIf(planet -> planet == null || this.field_70170_p.func_73045_a(planet.func_145782_y()) == null);
            this.planets.forEach(planet -> {
                if (!planet.isShooted) {
                    Vector3d difference = planet.func_174824_e(1.0f).func_178788_d(this.func_174824_e(1.0f));
                    float accelerationX = (float)(-difference.field_72450_a * (double)0.001f);
                    float accelerationZ = (float)(-difference.field_72449_c * (double)0.001f);
                    Vector3d resultant = difference.func_186678_a(0.5).func_72431_c(new Vector3d(0.0, (double)0.05f, 0.0));
                    resultant = resultant.func_72441_c(0.0, -difference.field_72448_b * (double)0.1f, 0.0);
                    planet.func_213317_d(resultant.func_72441_c((double)accelerationX, 0.0, (double)accelerationZ));
                }
            });
        }
        if (this.field_70173_aa % 600 == 0) {
            this.planets.forEach(planet -> {
                if (planet != null) {
                    LivingEntity potential;
                    Vector3d targetPosition = Vector3d.field_186680_a;
                    if (this.func_70638_az() != null) {
                        targetPosition = this.func_70638_az().func_174824_e(1.0f);
                    } else if (!this.getAttackTargets().isEmpty() && (potential = this.getAttackTargets().get(this.field_70146_Z.nextInt(this.getAttackTargets().size()))) != null) {
                        targetPosition = potential.func_174824_e(1.0f);
                    }
                    if (!targetPosition.equals((Object)Vector3d.field_186680_a)) {
                        Vector3d difference = targetPosition.func_178788_d(planet.func_213303_ch());
                        planet.func_70186_c(difference.field_72450_a, difference.field_72448_b, difference.field_72449_c, 3.0f, 0.0f);
                    }
                }
            });
        }
        this.destroyNearBlocks();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public void destroyNearBlocks() {
        if (this.field_70173_aa % 600 == 0) {
            boolean doSound = false;
            float maxDistance = 5.0f;
            doSound = EntityUtils.scanBlocksInAABB((LivingEntity)this, this.func_174813_aQ().func_186662_g((double)maxDistance), (blockPos, blockState) -> {
                double distance;
                Block block = blockState.func_177230_c();
                boolean flag = false;
                if (!block.equals(Blocks.field_150357_h) && (distance = blockPos.func_177951_i((Vector3i)new BlockPos(this.func_174813_aQ().func_189972_c()))) < (double)(maxDistance * maxDistance)) {
                    flag = this.field_70170_p.func_175656_a(blockPos, Blocks.field_150350_a.func_176223_P()) || flag;
                }
                return flag;
            });
            if (doSound) {
                this.func_184185_a(SoundEvents.field_187659_cY, 40.0f, 1.0f);
                this.func_184185_a(SoundEvents.field_187539_bB, 40.0f, 1.0f);
            }
        }
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
        if (this.bossInfo.func_186757_c().isEmpty()) {
            this.func_70606_j(this.func_110138_aP());
        }
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * 0.5f;
    }

    public ArrayList<ServerPlayerEntity> getPlayers() {
        return new ArrayList<ServerPlayerEntity>(this.bossInfo.func_186757_c().stream().collect(Collectors.toList()));
    }

    public boolean func_225509_J__() {
        return true;
    }

    public EntitySize func_213305_a(Pose entityPose) {
        float scaleFactor = 20.0f * (1.0f - 0.8f * this.func_110143_aJ() / this.func_110138_aP());
        return EntitySize.func_220314_b((float)scaleFactor, (float)scaleFactor);
    }

    public boolean func_104002_bU() {
        return !this.bossInfo.func_186757_c().isEmpty();
    }

    public void func_70623_bb() {
        if (this.bossInfo.func_186757_c().isEmpty()) {
            super.func_70623_bb();
        }
    }

    @Override
    public void setAttackTargets(ArrayList<LivingEntity> players) {
        this.otherAttackTargets.addAll(players);
    }

    @Override
    public ArrayList<LivingEntity> getAttackTargets() {
        return this.otherAttackTargets;
    }

    static class MoveHelperController
    extends MovementController {
        private final EntitySun parentEntity;
        private int courseChangeCooldown;

        public MoveHelperController(EntitySun ghast) {
            super((MobEntity)ghast);
            this.parentEntity = ghast;
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.MOVE_TO && this.courseChangeCooldown-- <= 0) {
                this.courseChangeCooldown = 60;
                this.field_188491_h = MovementController.Action.WAIT;
                Vector3d vector3d = new Vector3d(this.field_75646_b - this.parentEntity.func_226277_ct_(), this.field_75647_c - this.parentEntity.func_226278_cu_(), this.field_75644_d - this.parentEntity.func_226281_cx_());
                vector3d = vector3d.func_72432_b();
                this.parentEntity.func_213317_d(this.parentEntity.func_213322_ci().func_178787_e(vector3d.func_186678_a(0.1)));
            }
        }
    }

    static class RandomFlyGoal
    extends Goal {
        private final EntitySun parentEntity;

        public RandomFlyGoal(EntitySun ghast) {
            this.parentEntity = ghast;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            double d2;
            double d1;
            MovementController movementcontroller = this.parentEntity.func_70605_aq();
            if (!movementcontroller.func_75640_a()) {
                return true;
            }
            double d0 = movementcontroller.func_179917_d() - this.parentEntity.func_226277_ct_();
            double d3 = d0 * d0 + (d1 = movementcontroller.func_179919_e() - this.parentEntity.func_226278_cu_()) * d1 + (d2 = movementcontroller.func_179918_f() - this.parentEntity.func_226281_cx_()) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            Random random = this.parentEntity.func_70681_au();
            double d0 = this.parentEntity.func_226277_ct_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d1 = this.parentEntity.func_226278_cu_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 8.0f);
            double d2 = this.parentEntity.func_226281_cx_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            float f = (float)this.parentEntity.func_233637_b_(Attributes.field_233821_d_);
            this.parentEntity.func_70605_aq().func_75642_a(d0, d1, d2, (double)f);
        }
    }

    static class AIIgniteTargets
    extends AIScheduledTimedAction {
        private final EntitySun parentEntity;

        public AIIgniteTargets(EntitySun entity, int maxDuration, int maxCooldown) {
            super((LivingEntity)entity, maxDuration, maxCooldown);
            this.parentEntity = entity;
        }

        @Override
        public boolean func_75250_a() {
            return this.parentEntity.func_70638_az() != null;
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
            this.parentEntity.windTarget.func_220783_a(true);
        }

        @Override
        public void onStartCycle() {
            super.onStartCycle();
            this.parentEntity.getAttackTargets().forEach(target -> {
                if (target != this.parentEntity) {
                    target.func_70015_d(5);
                    double distance = target.func_213303_ch().func_72438_d(this.parentEntity.func_213303_ch()) + 1.0;
                    target.func_70097_a(DamageSource.func_76358_a((LivingEntity)this.parentEntity).func_76348_h().func_76361_j(), (float)(60.0 / distance));
                }
            });
        }

        @Override
        public void func_75251_c() {
            super.func_75251_c();
            this.parentEntity.windTarget.func_220783_a(false);
        }
    }

    static class AIAttack
    extends Goal {
        private final EntitySun parentEntity;

        public AIAttack(EntitySun Sun) {
            this.parentEntity = Sun;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return this.parentEntity.func_70638_az() != null && this.parentEntity.func_70068_e((Entity)this.parentEntity.func_70638_az()) > 256.0;
        }

        public void func_75249_e() {
        }

        public void func_75251_c() {
        }

        public void func_75246_d() {
            LivingEntity LivingEntity2 = this.parentEntity.func_70638_az();
            if (LivingEntity2.func_70068_e((Entity)this.parentEntity) < 4096.0 && this.parentEntity.func_70685_l((Entity)LivingEntity2)) {
                double d2 = LivingEntity2.func_226277_ct_();
                double d3 = LivingEntity2.func_226278_cu_();
                double d4 = LivingEntity2.func_226281_cx_();
                float f = (float)this.parentEntity.func_233637_b_(Attributes.field_233821_d_);
                this.parentEntity.func_70605_aq().func_75642_a(d2, d3, d4, (double)f);
            }
        }
    }

    class AIDoSolarWind
    extends AIScheduledTimedAction {
        EntitySun sun;

        public AIDoSolarWind(EntitySun entity, int maxDuration, int maxCooldown) {
            super((LivingEntity)entity, maxDuration, maxCooldown);
            this.sun = entity;
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
        }

        @Override
        public boolean func_75250_a() {
            return super.func_75250_a();
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
            this.sun.setSolarWinding(true);
            EntitySun.this.windTarget.func_220783_a(true);
            SoundEvent soundevent = SoundEvents.field_187616_bj;
            this.sun.func_184185_a(soundevent, 20.0f, 0.2f);
        }

        public void func_75246_d() {
            super.func_75246_d();
        }

        @Override
        public void onStartCycle() {
            super.onStartCycle();
            this.sun.getAttackTargets().forEach(target -> {
                if (this.shouldBeDamaged((LivingEntity)target)) {
                    target.func_70097_a(DamageSource.func_76358_a((LivingEntity)this.sun).func_76348_h().func_76361_j(), target.func_110138_aP() * 0.25f);
                }
            });
        }

        private boolean shouldBeDamaged(LivingEntity player) {
            Vector3d Vector3d2 = this.sun.func_70676_i(1.0f).func_72432_b();
            Vector3d Vector3d1 = new Vector3d(player.func_226277_ct_() - this.sun.func_226277_ct_(), player.func_174813_aQ().field_72338_b + (double)player.func_70047_e() - (this.sun.func_226278_cu_() + (double)this.sun.func_70047_e()), player.func_226281_cx_() - this.sun.func_226281_cx_());
            double d1 = Vector3d2.func_72430_b(Vector3d1 = Vector3d1.func_216371_e().func_72432_b());
            return d1 > 0.6 ? player.func_70685_l((Entity)player) : false;
        }

        @Override
        public void func_75251_c() {
            super.func_75251_c();
            this.sun.setSolarWinding(false);
            EntitySun.this.windTarget.func_220783_a(false);
            this.sun.field_70177_z += 90.0f;
        }
    }
}

