/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.entity.boss;

import com.dainxt.dungeonsmod.ai.AIMultipleTargetGoal;
import com.dainxt.dungeonsmod.ai.AIScheduledTimedAction;
import com.dainxt.dungeonsmod.config.DungeonsModConfig;
import com.dainxt.dungeonsmod.difficulty.DifficultyManager;
import com.dainxt.dungeonsmod.entity.EntityExtraPart;
import com.dainxt.dungeonsmod.entity.projectile.EntityVoidLaser;
import com.dainxt.dungeonsmod.entity.projectile.SArrowEntity;
import com.dainxt.dungeonsmod.handlers.EntityRegistries;
import com.dainxt.dungeonsmod.interfaces.IMultiTargetEntity;
import com.dainxt.dungeonsmod.items.VoidTomeItem;
import com.dainxt.dungeonsmod.sclasses.EntityMultiPart;
import com.dainxt.dungeonsmod.util.EntityUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.WallSignBlock;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IChargeableMob;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.Property;
import net.minecraft.tileentity.SignTileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.BossInfo;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT, _interface=IChargeableMob.class)
public class EntityVoidMaster
extends EntityMultiPart
implements IChargeableMob,
IMultiTargetEntity {
    DifficultyManager difficultyManager = new DifficultyManager();
    private static final DataParameter<Boolean> NULLIFY = EntityDataManager.func_187226_a(EntityVoidMaster.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> BLACK_HOLE = EntityDataManager.func_187226_a(EntityVoidMaster.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> HAND_ANIMATION = EntityDataManager.func_187226_a(EntityVoidMaster.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<CompoundNBT> PLAYERS_POSITIONS = EntityDataManager.func_187226_a(EntityVoidMaster.class, (IDataSerializer)DataSerializers.field_192734_n);
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.GREEN, BossInfo.Overlay.PROGRESS).func_186741_a(true);
    public Map<String, BlockPos> cementeryPositions;

    public EntityVoidMaster(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        if (!worldIn.field_72995_K) {
            this.cementeryPositions = new ConcurrentHashMap<String, BlockPos>();
        }
        this.field_70728_aV = 9000;
        this.field_70158_ak = true;
        this.func_110163_bv();
    }

    protected ResourceLocation func_184647_J() {
        return DungeonsModConfig.COMMON.voidmaster.getLootTable();
    }

    public ItemEntity func_70099_a(ItemStack stack, float offsetY) {
        if (stack.func_77973_b() instanceof VoidTomeItem) {
            long totalPlayers = this.bossInfo.func_186757_c().stream().filter(EntityPredicates.field_188444_d).count();
            float totalChance = MathHelper.func_76131_a((float)((float)((Double)DungeonsModConfig.COMMON.legendaryLootChance.get() * (double)totalPlayers)), (float)0.0f, (float)100.0f);
            if (this.field_70170_p.func_201674_k().nextFloat() < totalChance / 100.0f) {
                return super.func_70099_a(stack, offsetY);
            }
            return super.func_70099_a(ItemStack.field_190927_a, offsetY);
        }
        if (stack.func_77973_b() instanceof EnchantedBookItem) {
            List enchantments = ForgeRegistries.ENCHANTMENTS.getValues().stream().filter(entry -> !entry.func_190936_d()).collect(Collectors.toList());
            Collections.shuffle(enchantments);
            enchantments.stream().limit(this.bossInfo.func_186757_c().size()).forEach(enchantment -> {
                ItemStack stackCopy = stack.func_77946_l();
                EnchantedBookItem.func_92115_a((ItemStack)stackCopy, (EnchantmentData)new EnchantmentData(enchantment, 50));
                super.func_70099_a(stackCopy, offsetY);
            });
            return super.func_70099_a(ItemStack.field_190927_a, offsetY);
        }
        return super.func_70099_a(stack, offsetY);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(NULLIFY, (Object)false);
        this.field_70180_af.func_187214_a(BLACK_HOLE, (Object)-1);
        this.field_70180_af.func_187214_a(PLAYERS_POSITIONS, (Object)new CompoundNBT());
        this.field_70180_af.func_187214_a(HAND_ANIMATION, (Object)0);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76357_e()) {
            return super.func_70097_a(source, amount);
        }
        if (amount > 30.0f) {
            if (source.func_76346_g() instanceof LivingEntity) {
                source.func_76346_g().func_70097_a(DamageSource.func_76358_a((LivingEntity)this).func_82726_p(), amount * 2.0f);
            }
            return false;
        }
        if (this.getPhase() == 3) {
            amount *= 2.0f;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = super.func_70652_k(entityIn);
        if (flag && entityIn instanceof LivingEntity) {
            ((LivingEntity)entityIn).func_195064_c(new EffectInstance(Effects.field_76440_q, 20, 5));
        }
        return super.func_70652_k(entityIn);
    }

    @Override
    public void setAttackTargets(ArrayList<LivingEntity> players) {
        CompoundNBT nbt = new CompoundNBT().func_74775_l("playerPositions");
        nbt.func_74768_a("index", players.size());
        for (int i = 0; i < players.size(); ++i) {
            nbt.func_74768_a("player_" + i, players.get(i).func_145782_y());
        }
        this.func_184212_Q().func_187227_b(PLAYERS_POSITIONS, (Object)nbt);
    }

    @Override
    public ArrayList<LivingEntity> getAttackTargets() {
        CompoundNBT incomingTag;
        ArrayList<LivingEntity> incomingArray = new ArrayList<LivingEntity>();
        CompoundNBT nbt = incomingTag = (CompoundNBT)this.func_184212_Q().func_187225_a(PLAYERS_POSITIONS);
        for (int i = 0; i < nbt.func_74762_e("index"); ++i) {
            int entityId = nbt.func_74762_e("player_" + i);
            if (!(this.field_70170_p.func_73045_a(entityId) instanceof LivingEntity)) continue;
            incomingArray.add((LivingEntity)this.field_70170_p.func_73045_a(entityId));
        }
        return incomingArray;
    }

    public void setHandAnimation(int handAnimation) {
        this.func_184212_Q().func_187227_b(HAND_ANIMATION, (Object)handAnimation);
    }

    public int getHandAnimation() {
        return (Integer)this.func_184212_Q().func_187225_a(HAND_ANIMATION);
    }

    public void setBlackHole(int state) {
        this.func_184212_Q().func_187227_b(BLACK_HOLE, (Object)state);
    }

    public int getBlackHole() {
        return (Integer)this.func_184212_Q().func_187225_a(BLACK_HOLE);
    }

    public void setNullify(boolean activate) {
        this.func_184212_Q().func_187227_b(NULLIFY, (Object)activate);
    }

    public boolean getNullify() {
        return (Boolean)this.func_184212_Q().func_187225_a(NULLIFY);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        CompoundNBT nbt = compound.func_74775_l("cementeryPositions");
        for (int i = 0; i < nbt.func_74762_e("index"); ++i) {
            String name = nbt.func_74779_i("name_" + i);
            BlockPos pos = BlockPos.func_218283_e((long)nbt.func_74763_f("position_" + i));
            this.cementeryPositions.put(name, pos);
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        CompoundNBT nbt = compound.func_74775_l("cementeryPositions");
        nbt.func_74768_a("index", this.cementeryPositions.size());
        for (int i = 0; i < this.cementeryPositions.size(); ++i) {
            String name = (String)((Map.Entry)this.cementeryPositions.entrySet().toArray()[i]).getKey();
            BlockPos pos = (BlockPos)((Map.Entry)this.cementeryPositions.entrySet().toArray()[i]).getValue();
            nbt.func_74778_a("name_" + i, name);
            nbt.func_74772_a("position_" + i, pos.func_218275_a());
        }
        compound.func_218657_a("cementeryPositions", (INBT)nbt);
    }

    public static AttributeModifierMap.MutableAttribute createMobAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 750.0).func_233815_a_(Attributes.field_233819_b_, 200.0).func_233815_a_(Attributes.field_233823_f_, 6.0).func_233815_a_(Attributes.field_233826_i_, 20.0).func_233815_a_(Attributes.field_233820_c_, 1.0);
    }

    @Override
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        this.field_70177_z = 270.0f;
        this.field_70759_as = 270.0f;
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new LaserAttackGoal(this, 1, 100, 20));
        this.field_70714_bg.func_75776_a(2, (Goal)new BlackHoleAttackGoal(this, 100, 1200));
        this.field_70714_bg.func_75776_a(3, (Goal)new NullifyAttackGoal(this, 40, 600, 3));
        this.field_70714_bg.func_75776_a(4, (Goal)new MeleeMultiAttackGoal(this, 10, 20));
        this.field_70715_bh.func_75776_a(1, new AIMultipleTargetGoal<PlayerEntity>(this, PlayerEntity.class));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        this.field_70759_as = 270.0f;
        if (this.getBlackHole() > 0) {
            if (this.getBlackHole() == 1) {
                this.getAttackTargets().forEach(nearEntity -> {
                    Vector3d offset = this.func_70040_Z().func_186678_a(22.0);
                    Vector3d direction = this.func_213303_ch().func_178787_e(offset).func_178788_d(nearEntity.func_213303_ch());
                    if (direction.func_72433_c() >= 1.5) {
                        double invDistance = 1.0 / direction.func_72433_c() * 5.0;
                        nearEntity.func_213317_d(nearEntity.func_213322_ci().func_178787_e(direction.func_72432_b().func_216372_d(invDistance, invDistance, invDistance)));
                    } else {
                        nearEntity.func_213317_d(Vector3d.field_186680_a);
                    }
                });
            } else if (this.getBlackHole() > 1) {
                this.getAttackTargets().forEach(nearEntity -> {
                    Vector3d offset = this.func_70040_Z().func_186678_a(22.0);
                    double distance = this.func_213303_ch().func_178787_e(offset).func_72438_d(nearEntity.func_213303_ch());
                    double power = 15.0;
                    Vector3d motionDirection = this.func_70040_Z().func_72441_c(0.0, (double)0.1f, 0.0).func_186678_a(power);
                    if (distance < 2.0) {
                        nearEntity.func_213317_d(motionDirection);
                    }
                });
                if (!this.field_70170_p.field_72995_K) {
                    if (this.getBlackHole() == 2) {
                        this.setBlackHole(3);
                    } else if (this.getBlackHole() == 3) {
                        this.setBlackHole(-1);
                    }
                }
            }
        }
    }

    public void tombPlayer(PlayerEntity player) {
        BlockPos cementery1 = this.cementeryPositions.get("leftCementery1");
        BlockPos cementery2 = this.cementeryPositions.get("leftCementery2");
        if (cementery1 == null || cementery2 == null) {
            return;
        }
        BlockPos difference = cementery2.func_177973_b((Vector3i)cementery1);
        BlockPos crossProduct = BlockPos.field_177992_a.func_177967_a(Direction.UP, 1).func_177955_d((Vector3i)difference);
        boolean leftCementery = true;
        block0: for (int row = 0; row <= 16; ++row) {
            int column = 0;
            while (column <= 16) {
                if (leftCementery) {
                    cementery1 = this.cementeryPositions.get("leftCementery1");
                    cementery2 = this.cementeryPositions.get("leftCementery2");
                } else {
                    cementery1 = this.cementeryPositions.get("rightCementery1");
                    cementery2 = this.cementeryPositions.get("rightCementery2");
                }
                difference = cementery2.func_177973_b((Vector3i)cementery1);
                crossProduct = BlockPos.field_177992_a.func_177967_a(Direction.UP, leftCementery ? 1 : -1).func_177955_d((Vector3i)difference);
                Direction signFacing = Direction.func_176737_a((float)crossProduct.func_177958_n(), (float)crossProduct.func_177956_o(), (float)crossProduct.func_177952_p());
                Direction expansionFacing = signFacing.func_176734_d();
                BlockPos crossPosition = cementery1.func_177967_a(Direction.func_176737_a((float)difference.func_177958_n(), (float)difference.func_177956_o(), (float)difference.func_177952_p()), column * 4);
                crossPosition = crossPosition.func_177967_a(expansionFacing, row * 5);
                BlockPos signPos = crossPosition.func_177981_b(3).func_177967_a(signFacing, 1);
                if (!leftCementery) {
                    ++column;
                }
                boolean bl = leftCementery = !leftCementery;
                if (this.field_70170_p.func_180495_p(signPos).func_177230_c() == Blocks.field_222394_cj) continue;
                for (int i = 0; i <= 4; ++i) {
                    this.field_70170_p.func_175656_a(crossPosition.func_177981_b(i), Blocks.field_150347_e.func_176223_P());
                    if (i != 3) continue;
                    this.field_70170_p.func_175656_a(crossPosition.func_177981_b(i).func_177967_a(Direction.func_176737_a((float)difference.func_177958_n(), (float)difference.func_177956_o(), (float)difference.func_177952_p()), 1), Blocks.field_150347_e.func_176223_P());
                    this.field_70170_p.func_175656_a(crossPosition.func_177981_b(i).func_177967_a(Direction.func_176737_a((float)difference.func_177958_n(), (float)difference.func_177956_o(), (float)difference.func_177952_p()), -1), Blocks.field_150347_e.func_176223_P());
                    this.field_70170_p.func_175656_a(signPos, (BlockState)Blocks.field_222394_cj.func_176223_P().func_206870_a((Property)WallSignBlock.field_176412_a, (Comparable)signFacing));
                    ((SignTileEntity)this.field_70170_p.func_175625_s(signPos)).func_212365_a(1, player.func_145748_c_());
                }
                break block0;
            }
        }
    }

    private double getHeadX(int p_82214_1_) {
        if (p_82214_1_ <= 0) {
            float f = (this.field_70761_aq + 90.0f) * ((float)Math.PI / 180);
            float f1 = MathHelper.func_76134_b((float)f);
            return this.func_226277_ct_() + (double)f1 * 5.0;
        }
        float f = (this.field_70761_aq + (float)(180 * (p_82214_1_ - 1))) * ((float)Math.PI / 180);
        float f1 = MathHelper.func_76134_b((float)f);
        return this.func_226277_ct_() + (double)f1 * 13.5;
    }

    private double getHeadY(int p_82208_1_) {
        return p_82208_1_ <= 0 ? this.func_226280_cw_() + 0.0 : this.func_226280_cw_() - 1.5;
    }

    private double getHeadZ(int p_82213_1_) {
        if (p_82213_1_ <= 0) {
            float f = (this.field_70761_aq + 90.0f) * ((float)Math.PI / 180);
            float f1 = MathHelper.func_76126_a((float)f);
            return this.func_226281_cx_() + (double)f1 * 5.0;
        }
        float f = (this.field_70761_aq + (float)(180 * (p_82213_1_ - 1))) * ((float)Math.PI / 180);
        float f1 = MathHelper.func_76126_a((float)f);
        return this.func_226281_cx_() + (double)f1 * 13.5;
    }

    private void launchProjectiletoEntity(int p_82216_1_, LivingEntity p_82216_2_) {
        this.launchProjectiletoCoords(p_82216_1_, p_82216_2_.func_226277_ct_(), p_82216_2_.func_226278_cu_() + (double)p_82216_2_.func_70047_e() * 0.5, p_82216_2_.func_226281_cx_(), p_82216_1_ == 0 && this.field_70146_Z.nextFloat() < 0.001f);
    }

    private void launchProjectiletoCoords(int p_82209_1_, double x, double y, double z, boolean invulnerable) {
        if (!this.func_174814_R()) {
            SoundEvent soundevent = SoundEvents.field_206940_M;
            this.func_184185_a(soundevent, 20.0f, 0.2f);
        }
        double d0 = this.getHeadX(p_82209_1_);
        double d1 = this.getHeadY(p_82209_1_);
        double d2 = this.getHeadZ(p_82209_1_);
        double d3 = x - d0;
        double d4 = y - d1;
        double d5 = z - d2;
        double d7 = MathHelper.func_76133_a((double)(d3 * d3 + d5 * d5));
        EntityVoidLaser witherskullentity = new EntityVoidLaser(EntityRegistries.VOIDLASER, this.field_70170_p);
        witherskullentity.func_70107_b(d0, d1, d2);
        witherskullentity.func_212361_a((Entity)this);
        witherskullentity.func_70186_c(d3, d4, d5, 5.0f, 0.0f);
        this.field_70170_p.func_217376_c((Entity)witherskullentity);
    }

    private void launchArrowEntity(LivingEntity target) {
        double d4 = this.getHeadX(0);
        double d5 = this.getHeadY(0);
        double d6 = this.getHeadZ(0);
        double d0 = target.func_226277_ct_() - d4;
        double d1 = target.func_226283_e_(0.3333333333) - d5;
        double d2 = target.func_226281_cx_() - d6;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        SArrowEntity abstractarrowentity = new SArrowEntity(this.field_70170_p, d4, d5, d6);
        abstractarrowentity.func_212361_a((Entity)this);
        abstractarrowentity.func_70239_b(0.1f);
        abstractarrowentity.func_70186_c(d0, d1 + d3 * (double)0.05f, d2, 5.0f, 1.0f);
        this.field_70170_p.func_217376_c((Entity)abstractarrowentity);
    }

    protected void func_191955_a(BlockState blockstate) {
        Block block = blockstate.func_177230_c();
        if (block != Blocks.field_150350_a) {
            EntityUtils.scanBlocksInAABB((LivingEntity)this, (blockPos, blockState) -> {
                this.field_70170_p.func_175655_b(blockPos, false);
                return false;
            });
        }
        super.func_191955_a(blockstate);
    }

    public int getPhase() {
        float healthPercent = this.func_110143_aJ() / this.func_110138_aP();
        return MathHelper.func_76123_f((float)((1.0f - healthPercent) * 3.0f));
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * 0.5f;
    }

    @Override
    protected EntityExtraPart.ExtraPartType getExtraPartType() {
        return EntityExtraPart.ExtraPartType.VOIDHAND;
    }

    @Override
    protected void initExtraParts(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        EntityExtraPart leftHand = new EntityExtraPart((MobEntity)this, "rightHand", 6.0f, 6.0f);
        EntityExtraPart rightHand = new EntityExtraPart((MobEntity)this, "leftHand", 6.0f, 6.0f);
        this.extraParts.addAll(Arrays.asList(leftHand, rightHand));
    }

    @Override
    protected void updateExtraParts() {
        this.getParts().forEach(extraPart -> {
            extraPart.field_70177_z = this.field_70177_z;
            extraPart.field_70759_as = this.field_70759_as;
        });
        for (EntityExtraPart extraPart2 : this.getParts()) {
            if (extraPart2.func_70638_az() != null) continue;
            switch (extraPart2.getPartName()) {
                case "rightHand": {
                    this.setPartBoundingPosition(extraPart2, 50.0f, 20.0f, 15.0);
                    break;
                }
                case "leftHand": {
                    this.setPartBoundingPosition(extraPart2, -50.0f, 20.0f, 15.0);
                }
            }
        }
    }

    protected void func_226294_cV_() {
        this.field_70728_aV = (int)((long)this.field_70728_aV + (long)MathHelper.func_76123_f((float)((float)this.field_70728_aV * 0.1f)) * this.bossInfo.func_186757_c().stream().filter(EntityPredicates.field_188444_d).count());
        super.func_226294_cV_();
    }

    public boolean func_184222_aU() {
        return false;
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (((Boolean)DungeonsModConfig.COMMON.scalingDifficulty.get()).booleanValue()) {
            this.difficultyManager.adjustDifficulty((LivingEntity)this, 0.7f, 0.0f, 0.7f, 0.7f, this.bossInfo.func_186757_c());
        }
        if (!this.func_213394_dL()) {
            this.func_213390_a(this.func_233580_cy_(), 3);
        }
        BlockPos pos = this.func_213384_dI();
        this.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        this.func_213317_d(Vector3d.field_186680_a);
        float distance = Float.MAX_VALUE;
        for (PlayerEntity player : this.bossInfo.func_186757_c()) {
            distance = Math.min(player.func_70032_d((Entity)this), distance);
        }
        if (distance > 30.0f) {
            this.func_70691_i(0.5f);
        }
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
        if (this.bossInfo.func_186757_c().isEmpty()) {
            this.func_70606_j(this.func_110138_aP());
        }
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public boolean func_225509_J__() {
        return true;
    }

    public void func_70623_bb() {
    }

    static class MeleeMultiAttackGoal
    extends AIScheduledTimedAction {
        private final EntityVoidMaster goalOwner;

        public MeleeMultiAttackGoal(EntityVoidMaster slimeIn, int duration, int cooldown) {
            super((LivingEntity)slimeIn, duration, cooldown);
            this.goalOwner = slimeIn;
        }

        @Override
        public boolean func_75250_a() {
            return !this.goalOwner.getAttackTargets().isEmpty() && super.func_75250_a();
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
            ArrayList<LivingEntity> targetEntities = this.goalOwner.getAttackTargets();
            Collections.shuffle(targetEntities);
            for (int i = 0; i < Math.min(this.goalOwner.getParts().size(), targetEntities.size()); ++i) {
                this.goalOwner.getParts().get(i).func_70624_b((LivingEntity)targetEntities.get(i));
            }
            this.goalOwner.setAttackTargets(new ArrayList<LivingEntity>(targetEntities));
            this.goalOwner.func_184609_a(Hand.MAIN_HAND);
        }

        public void func_75246_d() {
            super.func_75246_d();
            this.goalOwner.getParts().stream().filter(extraPart -> extraPart.func_70638_az() != null).forEach(hand -> {
                LivingEntity target = hand.func_70638_az();
                hand.func_70080_a(target.func_226277_ct_(), target.func_226283_e_(1.0), target.func_226281_cx_(), 0.0f, 0.0f);
                hand.func_213317_d(Vector3d.field_186680_a);
            });
        }

        @Override
        public void onStartCycle() {
            if (this.func_75250_a()) {
                this.goalOwner.getParts().stream().filter(extraPart -> extraPart.func_70638_az() != null).findAny().ifPresent(hand -> this.goalOwner.func_70652_k((Entity)hand.func_70638_az()));
            }
        }

        @Override
        public void func_75251_c() {
            super.func_75251_c();
            this.goalOwner.setAttackTargets(new ArrayList<LivingEntity>());
            this.goalOwner.getParts().forEach(extraPart -> extraPart.func_70624_b(null));
        }
    }

    static class BlackHoleAttackGoal
    extends AIScheduledTimedAction {
        private final EntityVoidMaster goalOwner;

        public BlackHoleAttackGoal(EntityVoidMaster entity, int maxDuration, int maxCooldown) {
            super((LivingEntity)entity, maxDuration, maxCooldown);
            this.goalOwner = entity;
        }

        @Override
        public boolean func_75250_a() {
            return !this.goalOwner.getAttackTargets().isEmpty() && super.func_75250_a();
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
            this.goalOwner.setBlackHole(1);
        }

        public void func_75246_d() {
            super.func_75246_d();
        }

        @Override
        public void onStartCycle() {
            this.goalOwner.setBlackHole(2);
        }

        @Override
        public void func_75251_c() {
            super.func_75251_c();
        }
    }

    static class NullifyAttackGoal
    extends AIScheduledTimedAction {
        private final EntityVoidMaster goalOwner;

        public NullifyAttackGoal(EntityVoidMaster entity, int maxDuration, int maxCooldown, int maxTimes) {
            super((LivingEntity)entity, maxDuration, maxCooldown, maxTimes);
            this.goalOwner = entity;
        }

        @Override
        public boolean func_75250_a() {
            return !this.goalOwner.getAttackTargets().isEmpty() && super.func_75250_a();
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
            this.goalOwner.setNullify(true);
        }

        @Override
        public void onStartCycle() {
            this.goalOwner.getAttackTargets().forEach(nearEntity -> {
                float damagefactor = 0.95f + (float)(this.goalOwner.getPhase() - 1) * 0.5f;
                if (!nearEntity.func_180799_ab() && !nearEntity.func_70090_H()) {
                    nearEntity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this.goalOwner).func_82726_p(), nearEntity.func_110138_aP() * damagefactor);
                }
            });
        }

        @Override
        public void func_75251_c() {
            super.func_75251_c();
            this.goalOwner.setNullify(false);
        }
    }

    static class LaserAttackGoal
    extends AIScheduledTimedAction {
        private int baseMaxTimes;
        private final EntityVoidMaster goalOwner;
        LivingEntity target;

        public LaserAttackGoal(EntityVoidMaster entity, int maxDuration, int maxCooldown, int maxTimes) {
            super((LivingEntity)entity, maxDuration, maxCooldown, maxTimes);
            this.goalOwner = entity;
            this.baseMaxTimes = maxTimes;
        }

        @Override
        public boolean func_75250_a() {
            return !this.goalOwner.getAttackTargets().isEmpty() && super.func_75250_a();
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
            ArrayList<LivingEntity> targetEntities = this.goalOwner.getAttackTargets();
            this.target = targetEntities.get(this.goalOwner.func_70681_au().nextInt(targetEntities.size()));
        }

        @Override
        public void onStartCycle() {
            if (this.target != null) {
                int phase = this.goalOwner.getPhase();
                this.goalOwner.launchProjectiletoEntity(0, this.target);
                if (phase == 1) {
                    this.maxTimes = this.baseMaxTimes;
                }
                if (phase == 2) {
                    this.maxTimes = this.baseMaxTimes * 2;
                    this.goalOwner.launchProjectiletoEntity(this.goalOwner.func_70681_au().nextBoolean() ? 1 : 2, this.target);
                }
                if (phase == 3) {
                    this.maxTimes = this.baseMaxTimes * 60 * 5;
                    this.goalOwner.launchProjectiletoEntity(1, this.target);
                    this.goalOwner.launchProjectiletoEntity(2, this.target);
                }
            }
        }
    }
}

