/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.entity.dungeons.dungeon4;

import com.dainxt.dungeonsmod.config.DungeonsModConfig;
import com.dainxt.dungeonsmod.difficulty.DifficultyManager;
import com.dainxt.dungeonsmod.entity.boss.EntityKing;
import com.dainxt.dungeonsmod.handlers.ItemRegistries;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class EntityGuard
extends TameableEntity {
    DifficultyManager difficultyManager = new DifficultyManager();
    private static final DataParameter<Boolean> IS_GUARD = EntityDataManager.func_187226_a(EntityGuard.class, (IDataSerializer)DataSerializers.field_187198_h);

    public EntityGuard(EntityType<? extends TameableEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_110163_bv();
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        this.func_184201_a(EquipmentSlotType.OFFHAND, new ItemStack((IItemProvider)Items.field_185159_cQ));
        this.func_184642_a(EquipmentSlotType.MAINHAND, 0.0f);
        this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_151040_l));
        this.func_184642_a(EquipmentSlotType.OFFHAND, 0.0f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_GUARD, (Object)false);
    }

    public boolean isGuard() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_GUARD);
    }

    public void setGuard(boolean attack) {
        this.func_184212_Q().func_187227_b(IS_GUARD, (Object)attack);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(6, (Goal)new FollowOwnerGoal((TameableEntity)this, 1.0, 10.0f, 2.0f, false));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[]{EntityGuard.class}));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 0, true, true, entity -> !this.func_70909_n()));
        this.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MonsterEntity.class, 0, true, true, (Predicate)((Object)new GuardTargetSelector(this))));
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (!this.field_70170_p.field_72995_K) {
            // empty if block
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (!this.field_70170_p.field_72995_K) {
            // empty if block
        }
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficulty, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        ILivingEntityData data = super.func_213386_a(worldIn, difficulty, reason, spawnDataIn, dataTag);
        this.func_180481_a(difficulty);
        if (data != null && data instanceof GroupData) {
            if (((GroupData)data).isBodyGuard) {
                this.setGuard(true);
                this.func_110148_a(Attributes.field_233818_a_).func_111128_a(10.0);
                this.func_195064_c(new EffectInstance(Effects.field_76428_l, Integer.MAX_VALUE, 4));
                this.func_184201_a(EquipmentSlotType.CHEST, new ItemStack((IItemProvider)Items.field_151030_Z));
                this.func_184201_a(EquipmentSlotType.LEGS, new ItemStack((IItemProvider)Items.field_151165_aa));
                this.func_184201_a(EquipmentSlotType.FEET, new ItemStack((IItemProvider)Items.field_151167_ab));
            }
            if (((GroupData)data).isPlayerGuard) {
                this.func_110148_a(Attributes.field_233818_a_).func_111128_a(10.0);
                this.func_110148_a(Attributes.field_233823_f_).func_111128_a(0.5);
                this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_151010_B));
            }
        }
        if (((Boolean)DungeonsModConfig.COMMON.scalingDifficulty.get()).booleanValue()) {
            this.difficultyManager.adjustDifficulty((LivingEntity)this);
        }
        return data;
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.func_82168_bl();
    }

    protected void func_70619_bc() {
        ItemStack stack;
        super.func_70619_bc();
        if (this.func_70909_n() && this.func_70902_q() != null && (stack = this.func_70902_q().func_184582_a(EquipmentSlotType.HEAD)).func_77973_b() != ItemRegistries.KING_CROWN) {
            this.func_70656_aK();
            this.func_70106_y();
        }
    }

    public void func_70645_a(DamageSource cause) {
        ItemStack stack;
        super.func_70645_a(cause);
        if (this.func_70909_n() && this.func_70902_q() != null && (stack = this.func_70902_q().func_184582_a(EquipmentSlotType.HEAD)).func_77973_b() == ItemRegistries.KING_CROWN) {
            this.func_70656_aK();
        }
    }

    public static AttributeModifierMap.MutableAttribute createMobAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233823_f_, 3.0).func_233815_a_(Attributes.field_233821_d_, 0.3).func_233815_a_(Attributes.field_233819_b_, 40.0).func_233815_a_(Attributes.field_233826_i_, 4.0);
    }

    public boolean func_142018_a(LivingEntity target, LivingEntity owner) {
        boolean whiteList = !(target instanceof EntityGuard) && !(target instanceof EntityKing) && !(target instanceof ArmorStandEntity);
        return whiteList;
    }

    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        return null;
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    protected boolean func_225511_J_() {
        return true;
    }

    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_187593_cC;
    }

    protected SoundEvent func_184181_aa() {
        return SoundEvents.field_187591_cB;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187741_cz;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187738_cy;
    }

    protected SoundEvent func_184588_d(int heightIn) {
        return heightIn > 4 ? SoundEvents.field_187735_cx : SoundEvents.field_187589_cA;
    }

    protected boolean func_146066_aG() {
        return !this.func_70909_n();
    }

    protected boolean func_230282_cS_() {
        return true;
    }

    public boolean func_230292_f_(PlayerEntity p_230292_1_) {
        return true;
    }

    public static class GroupData
    extends AgeableEntity.AgeableData {
        boolean isBodyGuard;
        boolean isPlayerGuard;

        public GroupData(boolean isBodyGuard) {
            super(false);
            this.isBodyGuard = isBodyGuard;
            this.isPlayerGuard = false;
        }

        public GroupData(boolean isBodyGuard, boolean isPlayerGuard) {
            super(false);
            this.isBodyGuard = isBodyGuard;
            this.isPlayerGuard = isPlayerGuard;
        }
    }

    public static class GuardTargetSelector
    implements com.google.common.base.Predicate<LivingEntity> {
        private final EntityGuard parentEntity;

        public GuardTargetSelector(EntityGuard guardian) {
            this.parentEntity = guardian;
        }

        public boolean apply(@Nullable LivingEntity p_apply_1_) {
            boolean whiteList = !(p_apply_1_ instanceof EntityGuard) && !(p_apply_1_ instanceof EntityKing) && !(p_apply_1_ instanceof ArmorStandEntity);
            return whiteList && !this.parentEntity.func_70909_n();
        }
    }
}

