/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.entity.layers;

import com.dainxt.dungeonsmod.entity.boss.EntitySun;
import com.dainxt.dungeonsmod.entity.layers.LayerDeserted;
import com.dainxt.dungeonsmod.entity.model.ModelSun;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.EnergyLayer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class LayerSun
extends EnergyLayer<EntitySun, ModelSun<EntitySun>> {
    private static final ResourceLocation idbaseModel = new ResourceLocation("dungeonsmod:textures/entity/sun/sun.png");
    private static final ResourceLocation idWindModel = new ResourceLocation("dungeonsmod:textures/entity/sun/solar_wind.png");
    private static final ResourceLocation idExt = new ResourceLocation("dungeonsmod:textures/entity/sun/sun_exterior.png");
    private final ModelSun<EntitySun> model_base = new ModelSun(0, 0.0f);
    private final ModelSun<EntitySun> model_solar_wind = new ModelSun(1, 0.0f);
    private final ModelSun<EntitySun> model_exterior = new ModelSun(0, 0.75f);
    protected static final RenderState.FogState BLACK_FOG = new RenderState.FogState("black_fog", () -> {
        RenderSystem.fog((int)2918, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        RenderSystem.enableFog();
    }, () -> {
        FogRenderer.func_228373_b_();
        RenderSystem.disableFog();
    });
    protected static final RenderState.TransparencyState ADDITIVE_TRANSPARENCY = new RenderState.TransparencyState("additive_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    protected static final RenderState.DiffuseLightingState DIFFUSE_LIGHTING_ENABLED = new RenderState.DiffuseLightingState(true);
    protected static final RenderState.AlphaState DEFAULT_ALPHA = new RenderState.AlphaState(0.003921569f);
    protected static final RenderState.CullState CULL_DISABLED = new RenderState.CullState(false);
    protected static final RenderState.LightmapState LIGHTMAP_ENABLED = new RenderState.LightmapState(true);
    protected static final RenderState.OverlayState OVERLAY_ENABLED = new RenderState.OverlayState(true);

    public LayerSun(IEntityRenderer<EntitySun, ModelSun<EntitySun>> featureRendererContext) {
        super(featureRendererContext);
    }

    public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, EntitySun entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        float f = (float)entitylivingbaseIn.field_70173_aa + partialTicks;
        ((ModelSun)this.func_215332_c()).func_217111_a(this.model_base);
        this.model_base.setLivingAnimations(entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks);
        this.model_base.setRotationAngles(entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        IVertexBuilder ivertexbuilder1 = bufferIn.getBuffer(LayerDeserted.getSandSwirl(idbaseModel, this.func_225634_a_(f), 0.0f));
        this.model_base.setRotationAngles(entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        float threshold = MathHelper.func_76131_a((float)(entitylivingbaseIn.func_110143_aJ() / entitylivingbaseIn.func_110138_aP() - 0.25f), (float)0.0f, (float)1.0f);
        this.model_base.renderAll(matrixStackIn, ivertexbuilder1, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, threshold, threshold, 1.0f);
        this.model_exterior.setLivingAnimations(entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks);
        ((ModelSun)this.func_215332_c()).func_217111_a(this.model_exterior);
        this.model_exterior.setLivingAnimations(entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks);
        this.model_exterior.setRotationAngles(entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RenderType.func_228636_a_((ResourceLocation)this.func_225633_a_(), (float)(-this.func_225634_a_(f)), (float)0.0f));
        this.model_exterior.setRotationAngles(entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.model_exterior.renderAll(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, 0.5f, 0.5f, 0.5f, 1.0f);
        if (entitylivingbaseIn.isSolarWinding()) {
            float frames = 8.0f;
            float seconds = 1.0f;
            float f1 = (float)MathHelper.func_76123_f((float)(((float)entitylivingbaseIn.field_70173_aa % (20.0f * seconds) + 1.0f) * frames / (20.0f * seconds))) / frames;
            ((ModelSun)this.func_215332_c()).func_217111_a(this.model_solar_wind);
            this.model_solar_wind.setLivingAnimations(entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks);
            this.model_solar_wind.setRotationAngles(entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            IVertexBuilder ivertexbuilder2 = bufferIn.getBuffer(LayerSun.getSolarWind(idWindModel, 0.0f, f1));
            this.model_solar_wind.setRotationAngles(entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            matrixStackIn.func_227862_a_(1.0f, 4.0f, 4.0f);
            this.model_solar_wind.renderWind(matrixStackIn, ivertexbuilder2, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, threshold, threshold, 1.0f);
        }
    }

    protected float func_225634_a_(float f) {
        return f * 0.005f;
    }

    protected ResourceLocation func_225633_a_() {
        return idExt;
    }

    protected EntityModel<EntitySun> func_225635_b_() {
        return this.model_exterior;
    }

    public static RenderType getSolarWind(ResourceLocation locationIn, float uIn, float vIn) {
        return RenderType.func_228633_a_((String)"solar_wind", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)7, (int)256, (boolean)false, (boolean)true, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(locationIn, false, false)).func_228725_a_((RenderState.TexturingState)new RenderState.OffsetTexturingState(uIn, vIn)).func_228717_a_(BLACK_FOG).func_228726_a_(ADDITIVE_TRANSPARENCY).func_228716_a_(DIFFUSE_LIGHTING_ENABLED).func_228713_a_(DEFAULT_ALPHA).func_228714_a_(CULL_DISABLED).func_228719_a_(LIGHTMAP_ENABLED).func_228722_a_(OVERLAY_ENABLED).func_228728_a_(false));
    }
}

