/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.entity.projectile;

import com.dainxt.dungeonsmod.entity.boss.EntityKing;
import com.dainxt.dungeonsmod.handlers.EntityRegistries;
import java.util.function.BiConsumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.projectile.DamagingProjectileEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

@OnlyIn(value=Dist.CLIENT, _interface=IRendersAsItem.class)
public class EntityItemThrow
extends DamagingProjectileEntity
implements IRendersAsItem {
    private float clientSideRotation = 0.0f;
    private static final DataParameter<CompoundNBT> COMPOUND_STACK = EntityDataManager.func_187226_a(EntityItemThrow.class, (IDataSerializer)DataSerializers.field_192734_n);
    private BiConsumer<Entity, LivingEntity> onImpact;

    public EntityItemThrow(EntityType<? extends DamagingProjectileEntity> p_i50173_1_, World p_i50173_2_) {
        super(p_i50173_1_, p_i50173_2_);
    }

    public EntityItemThrow(World worldIn, ItemStack thrownStackIn, BiConsumer<Entity, LivingEntity> onImpact) {
        super(EntityRegistries.ITEMTHROW, worldIn);
        this.onImpact = onImpact;
        this.field_70180_af.func_187227_b(COMPOUND_STACK, (Object)thrownStackIn.func_77946_l().func_77955_b(new CompoundNBT()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public EntityItemThrow(World worldIn, double x, double y, double z, double accelX, double accelY, double accelZ) {
        super(EntityRegistries.ITEMTHROW, x, y, z, accelX, accelY, accelZ, worldIn);
    }

    public EntityItemThrow(World worldIn, LivingEntity shooter, double accelX, double accelY, double accelZ) {
        super(EntityRegistries.ITEMTHROW, shooter, accelX, accelY, accelZ, worldIn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(COMPOUND_STACK, (Object)new CompoundNBT());
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_189654_d(false);
        Vector3d vector3d = this.func_213322_ci();
        float f = MathHelper.func_76133_a((double)EntityItemThrow.func_213296_b((Vector3d)vector3d));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)vector3d.field_72450_a, (double)vector3d.field_72449_c) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)vector3d.field_72448_b, (double)f) * 57.2957763671875);
        if (this.func_213322_ci().func_72430_b(this.func_213322_ci()) < 0.001) {
            this.func_70106_y();
        }
    }

    protected void func_70227_a(RayTraceResult result) {
        super.func_70227_a(result);
    }

    protected void func_213868_a(EntityRayTraceResult p_213868_1_) {
        if (!this.field_70170_p.field_72995_K) {
            Entity entity = p_213868_1_.func_216348_a();
            Entity entity1 = this.func_234616_v_();
            if (entity != null && !(entity instanceof EntityKing) && entity instanceof LivingEntity) {
                this.onImpact.accept((Entity)this, (LivingEntity)entity);
                this.func_70106_y();
            }
            if (entity1 instanceof LivingEntity) {
                this.func_174815_a((LivingEntity)entity1, entity);
            }
        }
    }

    protected float func_213316_a(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * 0.5f;
    }

    protected float func_82341_c() {
        return 0.95f;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return false;
    }

    protected IParticleData func_195057_f() {
        return ParticleTypes.field_197622_o;
    }

    protected boolean func_184564_k() {
        return false;
    }

    public void setItemStack(ItemStack stack) {
        this.func_184212_Q().func_187227_b(COMPOUND_STACK, (Object)stack.func_77955_b(new CompoundNBT()));
    }

    public ItemStack getItemStack() {
        return ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)this.func_184212_Q().func_187225_a(COMPOUND_STACK)));
    }

    public ItemStack func_184543_l() {
        return this.getItemStack();
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getRotationAnimation(float partialTicks) {
        if (!this.field_70122_E) {
            this.clientSideRotation = 1.0f * ((float)this.field_70173_aa + partialTicks) * 50.0f;
        }
        return this.clientSideRotation;
    }
}

