/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.handlers;

import com.dainxt.dungeonsmod.config.DungeonsModConfig;
import com.dainxt.dungeonsmod.entity.EntityAnthermite;
import com.dainxt.dungeonsmod.entity.EntityCrow;
import com.dainxt.dungeonsmod.entity.EntityDeadhound;
import com.dainxt.dungeonsmod.entity.EntityExtraPart;
import com.dainxt.dungeonsmod.entity.EntityHaunter;
import com.dainxt.dungeonsmod.entity.EntityLeech;
import com.dainxt.dungeonsmod.entity.EntityLordSkeleton;
import com.dainxt.dungeonsmod.entity.EntityMimic;
import com.dainxt.dungeonsmod.entity.EntityNoteHead;
import com.dainxt.dungeonsmod.entity.EntityPice;
import com.dainxt.dungeonsmod.entity.EntityPiranha;
import com.dainxt.dungeonsmod.entity.EntityPitcher;
import com.dainxt.dungeonsmod.entity.EntityRogue;
import com.dainxt.dungeonsmod.entity.EntitySandCloud;
import com.dainxt.dungeonsmod.entity.EntitySlimond;
import com.dainxt.dungeonsmod.entity.EntityWhirlwind;
import com.dainxt.dungeonsmod.entity.EntityWinterHunter;
import com.dainxt.dungeonsmod.entity.boss.EntityCrawler;
import com.dainxt.dungeonsmod.entity.boss.EntityDeserted;
import com.dainxt.dungeonsmod.entity.boss.EntityIronSlime;
import com.dainxt.dungeonsmod.entity.boss.EntityKing;
import com.dainxt.dungeonsmod.entity.boss.EntityKraken;
import com.dainxt.dungeonsmod.entity.boss.EntitySun;
import com.dainxt.dungeonsmod.entity.boss.EntityVoidMaster;
import com.dainxt.dungeonsmod.entity.dungeons.dungeon4.EntityGuard;
import com.dainxt.dungeonsmod.entity.dungeons.dungeon5.EntityScientist;
import com.dainxt.dungeonsmod.entity.dungeons.dungeon5.EntitySlimewolf;
import com.dainxt.dungeonsmod.entity.projectile.EntityChargedFireball;
import com.dainxt.dungeonsmod.entity.projectile.EntityItemThrow;
import com.dainxt.dungeonsmod.entity.projectile.EntitySunPlanet;
import com.dainxt.dungeonsmod.entity.projectile.EntityVoidLaser;
import com.dainxt.dungeonsmod.sclasses.TravelerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class EntityRegistries {
    public static final EntityType<EntityExtraPart> EXTRAPART = EntityRegistries.register("extrapart", EntityType.Builder.func_220322_a(EntityExtraPart::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(1.5f, 1.5f).setTrackingRange(100));
    public static final EntityType<EntityVoidLaser> VOIDLASER = EntityRegistries.register("voidlaser", EntityType.Builder.func_220322_a(EntityVoidLaser::new, (EntityClassification)EntityClassification.MISC).func_220321_a(1.0f, 1.0f).setTrackingRange(100));
    public static final EntityType<EntityItemThrow> ITEMTHROW = EntityRegistries.register("itemthrowed", EntityType.Builder.func_220322_a(EntityItemThrow::new, (EntityClassification)EntityClassification.MISC).func_220321_a(1.0f, 1.0f).setTrackingRange(100));
    public static final EntityType<EntitySandCloud> SANDCLOUD = EntityRegistries.register("sandcloud", EntityType.Builder.func_220322_a(EntitySandCloud::new, (EntityClassification)EntityClassification.MISC).func_220321_a(2.0f, 1.5f).setTrackingRange(100));
    public static final EntityType<EntityChargedFireball> CHARGEDFIREBALL = EntityRegistries.register("chargedfireball", EntityType.Builder.func_220322_a(EntityChargedFireball::new, (EntityClassification)EntityClassification.MISC).func_220321_a(1.0f, 1.0f).func_233606_a_(4).func_233608_b_(10));
    public static final EntityType<TravelerEntity> TRAVELER = EntityRegistries.register("traveler", EntityType.Builder.func_220322_a(TravelerEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.6f, 1.95f).func_233606_a_(10));
    public static final EntityType<EntitySunPlanet> SUNPLANET = EntityRegistries.register("sunplanet", EntityType.Builder.func_220322_a(EntitySunPlanet::new, (EntityClassification)EntityClassification.MISC).func_220321_a(2.0f, 2.0f).setTrackingRange(100));
    public static final EntityType<EntityAnthermite> ANTHERMITE = EntityRegistries.register("anthermite", EntityType.Builder.func_220322_a(EntityAnthermite::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(1.0f, 0.75f).setTrackingRange(100));
    public static final EntityType<EntityMimic> MIMIC = EntityRegistries.register("mimic", EntityType.Builder.func_220322_a(EntityMimic::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.9f, 0.9f).setTrackingRange(100));
    public static final EntityType<EntityPiranha> PIRANHA = EntityRegistries.register("piranha", EntityType.Builder.func_220322_a(EntityPiranha::new, (EntityClassification)EntityClassification.WATER_CREATURE).func_220321_a(0.8f, 0.8f).setTrackingRange(100));
    public static final EntityType<EntityRogue> ROGUE = EntityRegistries.register("rogue", EntityType.Builder.func_220322_a(EntityRogue::new, (EntityClassification)EntityClassification.MONSTER).setTrackingRange(100));
    public static final EntityType<EntitySlimond> SLIMOND = EntityRegistries.register("slimond", EntityType.Builder.func_220322_a(EntitySlimond::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.9f, 0.9f).setTrackingRange(100));
    public static final EntityType<EntityHaunter> HAUNTER = EntityRegistries.register("haunter", EntityType.Builder.func_220322_a(EntityHaunter::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.8f, 1.5f).setTrackingRange(100));
    public static final EntityType<EntityLordSkeleton> LORDSKELETON = EntityRegistries.register("lordskeleton", EntityType.Builder.func_220322_a(EntityLordSkeleton::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(2.0f, 6.9f).setTrackingRange(100));
    public static final EntityType<EntityDeadhound> DEADHOUND = EntityRegistries.register("deadhound", EntityType.Builder.func_220322_a(EntityDeadhound::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(1.9f, 1.9f).setTrackingRange(100));
    public static final EntityType<EntityCrow> CROW = EntityRegistries.register("crow", EntityType.Builder.func_220322_a(EntityCrow::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.5f, 0.6f).setTrackingRange(100));
    public static final EntityType<EntityNoteHead> NOTEHEAD = EntityRegistries.register("notehead", EntityType.Builder.func_220322_a(EntityNoteHead::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(3.5f, 22.1f).setTrackingRange(100));
    public static final EntityType<EntityWinterHunter> WINTERHUNTER = EntityRegistries.register("winterhunter", EntityType.Builder.func_220322_a(EntityWinterHunter::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(2.5f, 10.0f).setTrackingRange(100));
    public static final EntityType<EntityPice> PICE = EntityRegistries.register("pice", EntityType.Builder.func_220322_a(EntityPice::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(1.5f, 1.5f).setTrackingRange(100));
    public static final EntityType<EntityLeech> LEECH = EntityRegistries.register("leech", EntityType.Builder.func_220322_a(EntityLeech::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.9f, 0.9f).setTrackingRange(100));
    public static final EntityType<EntityPitcher> PITCHER = EntityRegistries.register("pitcher", EntityType.Builder.func_220322_a(EntityPitcher::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(1.0f, 1.2f).setTrackingRange(100));
    public static final EntityType<EntityWhirlwind> WHIRLWIND = EntityRegistries.register("whirlwind", EntityType.Builder.func_220322_a(EntityWhirlwind::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(3.0f, 5.0f).setTrackingRange(100));
    public static final EntityType<EntityCrawler> CRAWLER = EntityRegistries.register("crawler", EntityType.Builder.func_220322_a(EntityCrawler::new, (EntityClassification)EntityClassification.CREATURE).func_220320_c().func_220321_a(5.0f, 5.0f).setTrackingRange(100));
    public static final EntityType<EntityDeserted> DESERTED = EntityRegistries.register("deserted", EntityType.Builder.func_220322_a(EntityDeserted::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(1.5f, 2.5f).setTrackingRange(100));
    public static final EntityType<EntityIronSlime> IRONSLIME = EntityRegistries.register("ironslime", EntityType.Builder.func_220322_a(EntityIronSlime::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(3.0f, 3.0f).setTrackingRange(100));
    public static final EntityType<EntityKing> KING = EntityRegistries.register("king", EntityType.Builder.func_220322_a(EntityKing::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(1.8f, 5.0f).setTrackingRange(100));
    public static final EntityType<EntityKraken> KRAKEN = EntityRegistries.register("kraken", EntityType.Builder.func_220322_a(EntityKraken::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(5.0f, 5.0f).setTrackingRange(100));
    public static final EntityType<EntitySun> SUN = EntityRegistries.register("sun", EntityType.Builder.func_220322_a(EntitySun::new, (EntityClassification)EntityClassification.CREATURE).func_220320_c().func_220321_a(25.0f, 25.0f).setTrackingRange(100));
    public static final EntityType<EntityVoidMaster> VOIDMASTER = EntityRegistries.register("voidmaster", EntityType.Builder.func_220322_a(EntityVoidMaster::new, (EntityClassification)EntityClassification.CREATURE).func_220320_c().func_220321_a(12.0f, 12.0f).setTrackingRange(100));
    public static final EntityType<EntityGuard> GUARD = EntityRegistries.register("guard", EntityType.Builder.func_220322_a(EntityGuard::new, (EntityClassification)EntityClassification.CREATURE).setTrackingRange(100));
    public static final EntityType<EntityScientist> SCIENTIST = EntityRegistries.register("scientist", EntityType.Builder.func_220322_a(EntityScientist::new, (EntityClassification)EntityClassification.CREATURE).setTrackingRange(100));
    public static final EntityType<EntitySlimewolf> SLIMEWOLF = EntityRegistries.register("slimewolf", EntityType.Builder.func_220322_a(EntitySlimewolf::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.9f, 0.9f).setTrackingRange(100));

    @SubscribeEvent
    public static void onEntityRegistry(RegistryEvent.Register<EntityType<?>> e) {
        e.getRegistry().register(EXTRAPART);
        GlobalEntityTypeAttributes.put(EXTRAPART, (AttributeModifierMap)EntityExtraPart.createMobAttributes().func_233813_a_());
        e.getRegistry().register(VOIDLASER);
        e.getRegistry().register(ITEMTHROW);
        e.getRegistry().register(SANDCLOUD);
        GlobalEntityTypeAttributes.put(SANDCLOUD, (AttributeModifierMap)EntitySandCloud.createMobAttributes().func_233813_a_());
        e.getRegistry().register(CHARGEDFIREBALL);
        e.getRegistry().register(TRAVELER);
        GlobalEntityTypeAttributes.put(TRAVELER, (AttributeModifierMap)VillagerEntity.func_234551_eU_().func_233813_a_());
        e.getRegistry().register(SUNPLANET);
        e.getRegistry().register(ANTHERMITE);
        GlobalEntityTypeAttributes.put(ANTHERMITE, (AttributeModifierMap)EntityAnthermite.createMobAttributes().func_233813_a_());
        EntitySpawnPlacementRegistry.func_209343_a(ANTHERMITE, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EntityAnthermite::canSpawn);
        e.getRegistry().register(MIMIC);
        GlobalEntityTypeAttributes.put(MIMIC, (AttributeModifierMap)EntityMimic.createMobAttributes().func_233813_a_());
        EntitySpawnPlacementRegistry.func_209343_a(MIMIC, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EntityMimic::canSpawn);
        e.getRegistry().register(PIRANHA);
        GlobalEntityTypeAttributes.put(PIRANHA, (AttributeModifierMap)EntityPiranha.createMobAttributes().func_233813_a_());
        EntitySpawnPlacementRegistry.func_209343_a(PIRANHA, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.IN_WATER, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EntityPiranha::canSpawn);
        e.getRegistry().register(ROGUE);
        GlobalEntityTypeAttributes.put(ROGUE, (AttributeModifierMap)EntityRogue.createMobAttributes().func_233813_a_());
        EntitySpawnPlacementRegistry.func_209343_a(ROGUE, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EntityRogue::canSpawn);
        e.getRegistry().register(SLIMOND);
        GlobalEntityTypeAttributes.put(SLIMOND, (AttributeModifierMap)EntitySlimond.createMobAttributes().func_233813_a_());
        EntitySpawnPlacementRegistry.func_209343_a(SLIMOND, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EntitySlimond::canSpawn);
        e.getRegistry().register(HAUNTER);
        GlobalEntityTypeAttributes.put(HAUNTER, (AttributeModifierMap)EntityHaunter.createMobAttributes().func_233813_a_());
        EntitySpawnPlacementRegistry.func_209343_a(HAUNTER, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EntityHaunter::canSpawn);
        e.getRegistry().register(LORDSKELETON);
        GlobalEntityTypeAttributes.put(LORDSKELETON, (AttributeModifierMap)EntityLordSkeleton.createMobAttributes().func_233813_a_());
        e.getRegistry().register(DEADHOUND);
        GlobalEntityTypeAttributes.put(DEADHOUND, (AttributeModifierMap)EntityDeadhound.createMobAttributes().func_233813_a_());
        e.getRegistry().register(CROW);
        GlobalEntityTypeAttributes.put(CROW, (AttributeModifierMap)EntityCrow.createMobAttributes().func_233813_a_());
        EntitySpawnPlacementRegistry.func_209343_a(CROW, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EntityCrow::canSpawn);
        e.getRegistry().register(NOTEHEAD);
        GlobalEntityTypeAttributes.put(NOTEHEAD, (AttributeModifierMap)EntityNoteHead.createMobAttributes().func_233813_a_());
        EntitySpawnPlacementRegistry.func_209343_a(NOTEHEAD, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EntityNoteHead::canSpawn);
        e.getRegistry().register(WINTERHUNTER);
        GlobalEntityTypeAttributes.put(WINTERHUNTER, (AttributeModifierMap)EntityWinterHunter.createMobAttributes().func_233813_a_());
        EntitySpawnPlacementRegistry.func_209343_a(WINTERHUNTER, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EntityWinterHunter::canSpawn);
        e.getRegistry().register(PICE);
        GlobalEntityTypeAttributes.put(PICE, (AttributeModifierMap)EntityPice.createMobAttributes().func_233813_a_());
        EntitySpawnPlacementRegistry.func_209343_a(PICE, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EntityPice::canSpawn);
        e.getRegistry().register(LEECH);
        GlobalEntityTypeAttributes.put(LEECH, (AttributeModifierMap)EntityLeech.createMobAttributes().func_233813_a_());
        EntitySpawnPlacementRegistry.func_209343_a(LEECH, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EntityLeech::canSpawn);
        e.getRegistry().register(PITCHER);
        GlobalEntityTypeAttributes.put(PITCHER, (AttributeModifierMap)EntityPitcher.createMobAttributes().func_233813_a_());
        EntitySpawnPlacementRegistry.func_209343_a(PITCHER, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EntityPitcher::canSpawn);
        e.getRegistry().register(WHIRLWIND);
        GlobalEntityTypeAttributes.put(WHIRLWIND, (AttributeModifierMap)EntityWhirlwind.createMobAttributes().func_233813_a_());
        EntitySpawnPlacementRegistry.func_209343_a(WHIRLWIND, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EntityWhirlwind::canSpawn);
        e.getRegistry().register(CRAWLER);
        GlobalEntityTypeAttributes.put(CRAWLER, (AttributeModifierMap)EntityCrawler.createMobAttributes().func_233813_a_());
        e.getRegistry().register(DESERTED);
        GlobalEntityTypeAttributes.put(DESERTED, (AttributeModifierMap)EntityDeserted.createMobAttributes().func_233813_a_());
        e.getRegistry().register(IRONSLIME);
        GlobalEntityTypeAttributes.put(IRONSLIME, (AttributeModifierMap)EntityIronSlime.createMobAttributes().func_233813_a_());
        e.getRegistry().register(KING);
        GlobalEntityTypeAttributes.put(KING, (AttributeModifierMap)EntityKing.createMobAttributes().func_233813_a_());
        e.getRegistry().register(KRAKEN);
        GlobalEntityTypeAttributes.put(KRAKEN, (AttributeModifierMap)EntityKraken.createMobAttributes().func_233813_a_());
        e.getRegistry().register(SUN);
        GlobalEntityTypeAttributes.put(SUN, (AttributeModifierMap)EntitySun.createMobAttributes().func_233813_a_());
        e.getRegistry().register(VOIDMASTER);
        GlobalEntityTypeAttributes.put(VOIDMASTER, (AttributeModifierMap)EntityVoidMaster.createMobAttributes().func_233813_a_());
        e.getRegistry().register(GUARD);
        GlobalEntityTypeAttributes.put(GUARD, (AttributeModifierMap)EntityGuard.createMobAttributes().func_233813_a_());
        e.getRegistry().register(SCIENTIST);
        GlobalEntityTypeAttributes.put(SCIENTIST, (AttributeModifierMap)EntityScientist.createMobAttributes().func_233813_a_());
        e.getRegistry().register(SLIMEWOLF);
        GlobalEntityTypeAttributes.put(SLIMEWOLF, (AttributeModifierMap)EntitySlimewolf.createMobAttributes().func_233813_a_());
    }

    private static <T extends Entity> EntityType<T> register(String name, EntityType.Builder<T> entityTypeBuilder) {
        EntityType entityType = entityTypeBuilder.func_206830_a(name);
        entityType.setRegistryName(name);
        return entityType;
    }

    public static void registerEntityWorldSpawn(MobSpawnInfo.Builder builder, EntityType<?> type, int weight, int min, int max) {
        builder.func_242575_a(type.func_220339_d(), new MobSpawnInfo.Spawners(type, weight, min, max));
    }

    public static void registerOnBiomes(BiomeLoadingEvent e) {
        boolean blackFlag = false;
        for (Biome biome : DungeonsModConfig.COMMON.blackMobs.get()) {
            if (!biome.getRegistryName().equals((Object)e.getName())) continue;
            blackFlag = true;
        }
        if (!blackFlag) {
            if (e.getCategory() == Biome.Category.DESERT) {
                EntityRegistries.registerEntityWorldSpawn((MobSpawnInfo.Builder)e.getSpawns(), ANTHERMITE, DungeonsModConfig.COMMON.anthermite.getWeight(), 2, 5);
            }
            if (e.getCategory() == Biome.Category.PLAINS) {
                EntityRegistries.registerEntityWorldSpawn((MobSpawnInfo.Builder)e.getSpawns(), MIMIC, DungeonsModConfig.COMMON.mimic.getWeight(), 1, 1);
            }
            if (e.getCategory() == Biome.Category.OCEAN) {
                EntityRegistries.registerEntityWorldSpawn((MobSpawnInfo.Builder)e.getSpawns(), PIRANHA, DungeonsModConfig.COMMON.piranha.getWeight(), 2, 3);
            }
            if (e.getCategory() == Biome.Category.FOREST) {
                EntityRegistries.registerEntityWorldSpawn((MobSpawnInfo.Builder)e.getSpawns(), ROGUE, DungeonsModConfig.COMMON.rogue.getWeight(), 1, 1);
            }
            if (e.getCategory() == Biome.Category.SWAMP) {
                EntityRegistries.registerEntityWorldSpawn((MobSpawnInfo.Builder)e.getSpawns(), SLIMOND, DungeonsModConfig.COMMON.slimond.getWeight(), 1, 1);
            }
            if (e.getCategory() == Biome.Category.SWAMP) {
                EntityRegistries.registerEntityWorldSpawn((MobSpawnInfo.Builder)e.getSpawns(), HAUNTER, DungeonsModConfig.COMMON.haunter.getWeight(), 1, 1);
                EntityRegistries.registerEntityWorldSpawn((MobSpawnInfo.Builder)e.getSpawns(), NOTEHEAD, DungeonsModConfig.COMMON.notehead.getWeight(), 1, 1);
                EntityRegistries.registerEntityWorldSpawn((MobSpawnInfo.Builder)e.getSpawns(), CROW, DungeonsModConfig.COMMON.notehead.getWeight(), 1, 1);
            }
            if (e.getCategory() == Biome.Category.TAIGA || e.getCategory() == Biome.Category.ICY) {
                EntityRegistries.registerEntityWorldSpawn((MobSpawnInfo.Builder)e.getSpawns(), NOTEHEAD, DungeonsModConfig.COMMON.notehead.getWeight(), 1, 1);
            }
            if (e.getCategory() == Biome.Category.MESA || e.getCategory() == Biome.Category.DESERT || e.getCategory() == Biome.Category.FOREST) {
                EntityRegistries.registerEntityWorldSpawn((MobSpawnInfo.Builder)e.getSpawns(), CROW, DungeonsModConfig.COMMON.crow.getWeight(), 1, 1);
            }
            if (e.getCategory() == Biome.Category.TAIGA || e.getCategory() == Biome.Category.ICY) {
                EntityRegistries.registerEntityWorldSpawn((MobSpawnInfo.Builder)e.getSpawns(), WHIRLWIND, DungeonsModConfig.COMMON.whirlwind.getWeight(), 1, 1);
                EntityRegistries.registerEntityWorldSpawn((MobSpawnInfo.Builder)e.getSpawns(), PICE, DungeonsModConfig.COMMON.pice.getWeight(), 1, 2);
            }
        }
    }
}

