/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.handlers;

import com.dainxt.dungeonsmod.DungeonsMod;
import com.dainxt.dungeonsmod.config.DungeonsModConfig;
import com.dainxt.dungeonsmod.handlers.BlocksHandler;
import com.dainxt.dungeonsmod.handlers.ItemRegistries;
import com.dainxt.dungeonsmod.handlers.StructureRegistries;
import com.dainxt.dungeonsmod.interfaces.IDungeon;
import com.dainxt.dungeonsmod.util.WrittenBooks;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapDecoration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class VillagerRegistries {
    public static PointOfInterestType TRAVELER_PoI = new PointOfInterestType("traveler", VillagerRegistries.getJobSites(), 1, 1);
    public static VillagerProfession TRAVELER_Prof = new VillagerProfession("traveler", TRAVELER_PoI, ImmutableSet.of(), ImmutableSet.of(), null);

    private static Set<BlockState> getJobSites() {
        HashSet<BlockState> JOB_SITES = new HashSet<BlockState>();
        JOB_SITES.addAll(PointOfInterestType.func_221042_a((Block)BlocksHandler.HAYCOAL_BLOCK));
        return JOB_SITES;
    }

    @SubscribeEvent
    public static void onPoIRegistry(RegistryEvent.Register<PointOfInterestType> e) {
        e.getRegistry().register(TRAVELER_PoI.setRegistryName("traveler"));
        try {
            VillagerRegistries.PoIFix(TRAVELER_PoI);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e1) {
            e1.printStackTrace();
        }
    }

    @SubscribeEvent
    public static void onProfessionRegistry(RegistryEvent.Register<VillagerProfession> e) {
        e.getRegistry().register(TRAVELER_Prof.setRegistryName("traveler"));
        VillagerTrades.field_221239_a.put(TRAVELER_Prof, VillagerRegistries.gatAsIntMap((ImmutableMap<Integer, VillagerTrades.ITrade[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ITrade[]{new EmeraldForMapTrade(DungeonsModConfig.COMMON.dungeon1, StructureRegistries.dungeon1_feature, MapDecoration.Type.TARGET_X, 12, 5), new ItemsForEmeraldsTrade(ItemRegistries.BACK_PERGAMINE, 2, 1, 32)}, (Object)2, (Object)new VillagerTrades.ITrade[]{new EmeraldForMapTrade(DungeonsModConfig.COMMON.dungeon2, StructureRegistries.dungeon2_feature, MapDecoration.Type.TARGET_X, 12, 5)}, (Object)3, (Object)new VillagerTrades.ITrade[]{new EmeraldForMapTrade(DungeonsModConfig.COMMON.dungeon3, StructureRegistries.dungeon3_feature, MapDecoration.Type.TARGET_X, 12, 5)}, (Object)4, (Object)new VillagerTrades.ITrade[]{new EmeraldForMapTrade(DungeonsModConfig.COMMON.dungeon4, StructureRegistries.dungeon4_feature, MapDecoration.Type.TARGET_X, 12, 5)}, (Object)5, (Object)new VillagerTrades.ITrade[]{new EmeraldForMapTrade(DungeonsModConfig.COMMON.dungeon5, StructureRegistries.dungeon5_feature, MapDecoration.Type.TARGET_X, 12, 5), new SunTrade(Item.func_150898_a((Block)Blocks.field_196606_bd), 1, 1, 32)})));
    }

    private static Int2ObjectMap<VillagerTrades.ITrade[]> gatAsIntMap(ImmutableMap<Integer, VillagerTrades.ITrade[]> of) {
        return new Int2ObjectOpenHashMap(of);
    }

    private static void PoIFix(PointOfInterestType TRAVELER_PoI) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        Method method = null;
        for (Method met : PointOfInterestType.class.getDeclaredMethods()) {
            if (met.getName().equals("registerBlockStates")) {
                method = PointOfInterestType.class.getDeclaredMethod("registerBlockStates", PointOfInterestType.class);
                break;
            }
            if (!met.getName().equals("func_221052_a")) continue;
            method = PointOfInterestType.class.getDeclaredMethod("func_221052_a", PointOfInterestType.class);
            break;
        }
        method.setAccessible(true);
        method.invoke((Object)TRAVELER_PoI, TRAVELER_PoI);
        DungeonsMod.LOGGER.info("Register Point of Interest {}", (Object)method);
    }

    static class EmeraldForMapTrade
    implements VillagerTrades.ITrade {
        private final DungeonsModConfig.Server.StructureConfiguration configuration;
        private final Structure<?> structureName;
        private final MapDecoration.Type mapDecorationType;
        private final int maxUses;
        private final int xpValue;

        public EmeraldForMapTrade(DungeonsModConfig.Server.StructureConfiguration configuration, Structure<?> structureName, MapDecoration.Type mapDecorationType, int maxUses, int xpValue) {
            this.configuration = configuration;
            this.structureName = structureName;
            this.mapDecorationType = mapDecorationType;
            this.maxUses = maxUses;
            this.xpValue = xpValue;
        }

        @Nullable
        public MerchantOffer func_221182_a(Entity trader, Random rand) {
            if (!(trader.field_70170_p instanceof ServerWorld)) {
                return null;
            }
            if ((Integer)this.configuration.chance.get() >= 1) {
                int count = (Integer)this.configuration.price.get();
                ServerWorld serverworld = (ServerWorld)trader.field_70170_p;
                BlockPos blockpos = serverworld.func_241117_a_(this.structureName, trader.func_233580_cy_(), 100, true);
                if (blockpos != null) {
                    if (this.structureName instanceof IDungeon) {
                        ItemStack stack = ((IDungeon)this.structureName).getWrittenBook();
                        ItemEntity itemEntity = new ItemEntity(trader.field_70170_p, trader.func_226277_ct_(), trader.func_226278_cu_() + (double)1.4f, trader.func_226281_cx_(), stack);
                        itemEntity.func_174869_p();
                        trader.field_70170_p.func_217376_c((Entity)itemEntity);
                    }
                    ItemStack itemstack = FilledMapItem.func_195952_a((World)serverworld, (int)blockpos.func_177958_n(), (int)blockpos.func_177952_p(), (byte)2, (boolean)true, (boolean)true);
                    FilledMapItem.func_226642_a_((ServerWorld)serverworld, (ItemStack)itemstack);
                    MapData.func_191094_a((ItemStack)itemstack, (BlockPos)blockpos, (String)"+", (MapDecoration.Type)this.mapDecorationType);
                    itemstack.func_200302_a((ITextComponent)new TranslationTextComponent("filled_map." + this.structureName.func_143025_a().toLowerCase(Locale.ROOT)));
                    return new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, count), new ItemStack((IItemProvider)Items.field_151148_bJ), itemstack, this.maxUses, this.xpValue, 0.2f);
                }
                return null;
            }
            return new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, ((Integer)this.configuration.price.get()).intValue()), new ItemStack((IItemProvider)Items.field_151044_h), this.maxUses, this.xpValue, 0.2f);
        }
    }

    static class ItemsForEmeraldsTrade
    implements VillagerTrades.ITrade {
        private final ItemStack sellingItem;
        private final int emeraldCount;
        private final int sellingItemCount;
        private final int maxUses;
        private final int xpValue;
        private final float priceMultiplier;

        public ItemsForEmeraldsTrade(Block sellingItem, int emeraldCount, int sellingItemCount, int maxUses, int xpValue) {
            this(new ItemStack((IItemProvider)sellingItem), emeraldCount, sellingItemCount, maxUses, xpValue);
        }

        public ItemsForEmeraldsTrade(Item sellingItem, int emeraldCount, int sellingItemCount, int xpValue) {
            this(new ItemStack((IItemProvider)sellingItem), emeraldCount, sellingItemCount, 12, xpValue);
        }

        public ItemsForEmeraldsTrade(Item sellingItem, int emeraldCount, int sellingItemCount, int maxUses, int xpValue) {
            this(new ItemStack((IItemProvider)sellingItem), emeraldCount, sellingItemCount, maxUses, xpValue);
        }

        public ItemsForEmeraldsTrade(ItemStack sellingItem, int emeraldCount, int sellingItemCount, int maxUses, int xpValue) {
            this(sellingItem, emeraldCount, sellingItemCount, maxUses, xpValue, 0.05f);
        }

        public ItemsForEmeraldsTrade(ItemStack sellingItem, int emeraldCount, int sellingItemCount, int maxUses, int xpValue, float priceMultiplier) {
            this.sellingItem = sellingItem;
            this.emeraldCount = emeraldCount;
            this.sellingItemCount = sellingItemCount;
            this.maxUses = maxUses;
            this.xpValue = xpValue;
            this.priceMultiplier = priceMultiplier;
        }

        public MerchantOffer func_221182_a(Entity trader, Random rand) {
            return new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, this.emeraldCount), new ItemStack((IItemProvider)this.sellingItem.func_77973_b(), this.sellingItemCount), this.maxUses, this.xpValue, this.priceMultiplier);
        }
    }

    static class SunTrade
    implements VillagerTrades.ITrade {
        private final ItemStack sellingItem;
        private final int emeraldCount;
        private final int sellingItemCount;
        private final int maxUses;
        private final int xpValue;
        private final float priceMultiplier;

        public SunTrade(Block sellingItem, int emeraldCount, int sellingItemCount, int maxUses, int xpValue) {
            this(new ItemStack((IItemProvider)sellingItem), emeraldCount, sellingItemCount, maxUses, xpValue);
        }

        public SunTrade(Item sellingItem, int emeraldCount, int sellingItemCount, int xpValue) {
            this(new ItemStack((IItemProvider)sellingItem), emeraldCount, sellingItemCount, 12, xpValue);
        }

        public SunTrade(Item sellingItem, int emeraldCount, int sellingItemCount, int maxUses, int xpValue) {
            this(new ItemStack((IItemProvider)sellingItem), emeraldCount, sellingItemCount, maxUses, xpValue);
        }

        public SunTrade(ItemStack sellingItem, int emeraldCount, int sellingItemCount, int maxUses, int xpValue) {
            this(sellingItem, emeraldCount, sellingItemCount, maxUses, xpValue, 0.05f);
        }

        public SunTrade(ItemStack sellingItem, int emeraldCount, int sellingItemCount, int maxUses, int xpValue, float priceMultiplier) {
            this.sellingItem = sellingItem;
            this.emeraldCount = emeraldCount;
            this.sellingItemCount = sellingItemCount;
            this.maxUses = maxUses;
            this.xpValue = xpValue;
            this.priceMultiplier = priceMultiplier;
        }

        public MerchantOffer func_221182_a(Entity trader, Random rand) {
            ItemStack stack = WrittenBooks.getTranslatableBook("6");
            ItemEntity itemEntity = new ItemEntity(trader.field_70170_p, trader.func_226277_ct_(), trader.func_226278_cu_() + (double)1.4f, trader.func_226281_cx_(), stack);
            itemEntity.func_174869_p();
            trader.field_70170_p.func_217376_c((Entity)itemEntity);
            return new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, this.emeraldCount), new ItemStack((IItemProvider)this.sellingItem.func_77973_b(), this.sellingItemCount), this.maxUses, this.xpValue, this.priceMultiplier);
        }
    }
}

