/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.items;

import com.dainxt.dungeonsmod.items.ItemArmorMaterials;
import com.dainxt.dungeonsmod.sclasses.SItemGroup;
import com.dainxt.dungeonsmod.util.EntityUtils;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.Rarity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class CrawlerArmorItem
extends ArmorItem {
    public CrawlerArmorItem(IArmorMaterial materialIn, EquipmentSlotType slot, Item.Properties builderIn) {
        super(materialIn, slot, builderIn);
    }

    public CrawlerArmorItem(String name, EquipmentSlotType slot) {
        super((IArmorMaterial)ItemArmorMaterials.CRAWLER, slot, new Item.Properties().func_200916_a((ItemGroup)SItemGroup.MISC).func_208103_a(Rarity.RARE));
        this.setRegistryName(name);
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        super.onArmorTick(stack, world, player);
        boolean haveAllPieces = EntityUtils.entityHaveAllArmor((LivingEntity)player, ItemArmorMaterials.CRAWLER);
        if (haveAllPieces) {
            boolean canApplyRegeneration;
            long redstoneStacks = player.field_71071_by.field_70462_a.stream().filter(redstoneStack -> {
                if (redstoneStack.func_77973_b().equals(Items.field_221858_em)) {
                    return redstoneStack.func_190916_E() >= redstoneStack.func_77976_d();
                }
                return false;
            }).count();
            int regenerationLevel = MathHelper.func_76125_a((int)(MathHelper.func_76123_f((float)(redstoneStacks / 3L)) - 1), (int)-1, (int)2);
            boolean bl = canApplyRegeneration = !player.func_193076_bZ().containsKey(Effects.field_76428_l);
            if (player.func_193076_bZ().containsKey(Effects.field_76428_l)) {
                boolean bl2 = canApplyRegeneration = ((EffectInstance)player.func_193076_bZ().get(Effects.field_76428_l)).func_76458_c() < regenerationLevel;
            }
            if (regenerationLevel >= 0 && player instanceof LivingEntity && canApplyRegeneration) {
                player.func_195064_c(new EffectInstance(Effects.field_76428_l, 200, regenerationLevel));
            }
        }
    }
}

