/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.items;

import com.dainxt.dungeonsmod.config.DungeonsModConfig;
import com.dainxt.dungeonsmod.items.ItemBase;
import com.dainxt.dungeonsmod.util.Location;
import com.dainxt.dungeonsmod.util.TeleportHelper;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class ItemHomeGem
extends ItemBase {
    public ItemHomeGem(String name) {
        super(name, new Item.Properties().func_200917_a(1));
    }

    private int getMaxCooldown() {
        return (Integer)DungeonsModConfig.COMMON.cooldownHomeGem.get();
    }

    private int getMaxUseTime() {
        return (Integer)DungeonsModConfig.COMMON.usageHomeGem.get();
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (!worldIn.field_72995_K) {
            int cooldown;
            CompoundNBT tag = stack.func_77978_p();
            if (tag == null) {
                tag = new CompoundNBT();
            }
            if ((cooldown = tag.func_74762_e("cooldown")) > 0) {
                tag.func_74768_a("cooldown", --cooldown);
            }
            stack.func_77982_d(tag);
        }
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityIn, int timeLeft) {
        super.func_77615_a(stack, worldIn, entityIn, timeLeft);
        if (!worldIn.field_72995_K && entityIn.func_184607_cu() == stack) {
            PlayerEntity entityplayer = (PlayerEntity)entityIn;
            entityplayer.func_184811_cZ().func_185145_a(stack.func_77973_b(), 0);
        }
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, LivingEntity entityLiving) {
        CompoundNBT tag;
        PlayerEntity PlayerEntity2;
        PlayerEntity playerEntity = PlayerEntity2 = entityLiving instanceof PlayerEntity ? (PlayerEntity)entityLiving : null;
        if (!worldIn.field_72995_K && (tag = stack.func_77978_p()) != null) {
            BlockPos pos = BlockPos.func_218283_e((long)tag.func_74763_f("HomePos"));
            RegistryKey dimension = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(tag.func_74779_i("Dimension")));
            tag.func_74768_a("cooldown", this.getMaxCooldown());
            stack.func_77982_d(tag);
            Location location = new Location(pos, (RegistryKey<World>)dimension);
            TeleportHelper.warp((ServerPlayerEntity)PlayerEntity2, location);
            PlayerEntity2.func_195064_c(new EffectInstance(Effects.field_76440_q, 10));
            worldIn.func_184133_a(null, PlayerEntity2.func_233580_cy_(), SoundEvents.field_187812_eh, SoundCategory.AMBIENT, 10.0f, 1.0f);
        }
        return super.func_77654_b(stack, worldIn, entityLiving);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null) {
            return tag.func_74762_e("cooldown") > 0;
        }
        return super.showDurabilityBar(stack);
    }

    public boolean func_77636_d(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null) {
            return tag.func_74767_n("isLinked");
        }
        return super.func_77636_d(stack);
    }

    public int func_77626_a(ItemStack stack) {
        return this.getMaxUseTime();
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null) {
            return (double)tag.func_74762_e("cooldown") / (double)this.getMaxCooldown();
        }
        return super.getDurabilityForDisplay(stack);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity user, Hand handIn) {
        if (!worldIn.field_72995_K) {
            ServerPlayerEntity playerIn = (ServerPlayerEntity)user;
            ItemStack stack = playerIn.func_184586_b(handIn);
            CompoundNBT tag = stack.func_77978_p();
            if (DungeonsModConfig.COMMON.enableHomeGem.isEnabled()) {
                if (tag != null && playerIn.func_241140_K_() != null) {
                    ServerWorld worldServer = playerIn.func_130014_f_().func_73046_m().func_71218_a(playerIn.func_241141_L_());
                    boolean wasLinked = tag.func_74767_n("isLinked");
                    if (PlayerEntity.func_242374_a((ServerWorld)worldServer, (BlockPos)playerIn.func_241140_K_(), (float)playerIn.func_242109_L(), (boolean)false, (boolean)false).isPresent()) {
                        tag.func_74757_a("isLinked", true);
                        tag.func_74778_a("Dimension", playerIn.func_241141_L_().func_240901_a_().toString());
                        tag.func_74772_a("HomePos", playerIn.func_241140_K_().func_218275_a());
                        if (!wasLinked) {
                            worldIn.func_184133_a(null, playerIn.func_233580_cy_(), SoundEvents.field_193781_bp, SoundCategory.AMBIENT, 1.0f, 1.0f);
                        }
                    } else {
                        tag.func_74757_a("isLinked", false);
                        if (wasLinked) {
                            worldIn.func_184133_a(null, playerIn.func_233580_cy_(), SoundEvents.field_193777_bb, SoundCategory.AMBIENT, 1.0f, 1.0f);
                        }
                        return ActionResult.func_226251_d_((Object)playerIn.func_184586_b(handIn));
                    }
                    if ((float)tag.func_74762_e("cooldown") == 0.0f) {
                        playerIn.func_184598_c(handIn);
                        playerIn.func_184811_cZ().func_185145_a(stack.func_77973_b(), this.getMaxUseTime());
                        return ActionResult.func_226248_a_((Object)stack);
                    }
                    stack.func_77982_d(tag);
                }
            } else if (playerIn instanceof PlayerEntity) {
                playerIn.func_146105_b((ITextComponent)new TranslationTextComponent("item.dungeonsmod.home_gem.denied"), true);
            }
        }
        return super.func_77659_a(worldIn, user, handIn);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        CompoundNBT tagCompound = stack.func_77978_p();
        if (tagCompound != null) {
            DecimalFormat df = new DecimalFormat();
            df.setMaximumFractionDigits(3);
            int cooldown = tagCompound.func_74762_e("cooldown");
            float minutesExact = cooldown / 1200;
            int minutes = (int)minutesExact;
            float secondsExact = cooldown / 20;
            int seconds = (int)(secondsExact - (float)(minutes * 60));
            if (tagCompound.func_74767_n("isLinked")) {
                tooltip.add((ITextComponent)new TranslationTextComponent("item.dungeonsmod.home_gem.tooltip_1"));
            }
            tooltip.add((ITextComponent)new TranslationTextComponent("item.dungeonsmod.cooldown", new Object[]{minutes, seconds}));
        }
    }
}

