/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.items;

import com.dainxt.dungeonsmod.items.ItemBase;
import com.dainxt.dungeonsmod.util.EntityUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.OreBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemOreDetector
extends ItemBase {
    public Iterator<Block> ores;
    public Block selectedOre = Blocks.field_150365_q;

    public ItemOreDetector(String name) {
        super(name, new Item.Properties().func_200917_a(1).func_208103_a(Rarity.RARE));
    }

    public ArrayList<Block> getOres() {
        return ForgeRegistries.BLOCKS.getValues().stream().filter(block -> block instanceof OreBlock).collect(Collectors.toCollection(ArrayList::new));
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if ((itemSlot == 0 || isSelected) && entityIn instanceof PlayerEntity && !worldIn.field_72995_K && entityIn.field_70173_aa % 40 == 0) {
            CompoundNBT tag = stack.func_77978_p();
            if (tag == null) {
                tag = new CompoundNBT();
            }
            tag.func_74768_a("selectedBlock", Block.func_196246_j((BlockState)this.selectedOre.func_176223_P()));
            stack.func_77982_d(tag);
            double nearestDistance = EntityUtils.scanBlocksInAABB((Entity)((LivingEntity)entityIn), entityIn.func_174813_aQ().func_186662_g(10.0), (pos, state, distance) -> {
                if (distance == null) {
                    distance = 3.0 * Math.pow(10.0, 2.0);
                } else if (state.func_177230_c().equals(this.selectedOre)) {
                    distance = Math.min(distance, ((LivingEntity)entityIn).func_70092_e((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()));
                }
                return distance;
            });
            worldIn.func_184133_a(null, entityIn.func_233580_cy_(), SoundEvents.field_193807_ew, SoundCategory.PLAYERS, 1.0f, (float)(1.0 - nearestDistance / 300.0));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (!worldIn.field_72995_K) {
            if (this.ores == null || !this.ores.hasNext()) {
                this.ores = this.getOres().listIterator();
            } else if (this.ores.hasNext()) {
                this.selectedOre = this.ores.next();
            }
            worldIn.func_184133_a(null, playerIn.func_233580_cy_(), SoundEvents.field_187839_fV, SoundCategory.PLAYERS, 1.0f, 0.5f);
            if (this.selectedOre != null) {
                playerIn.func_146105_b((ITextComponent)new TranslationTextComponent(this.selectedOre.func_149739_a()), true);
            }
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null) {
            tooltip.add((ITextComponent)new TranslationTextComponent("item.dungeonsmod.ore_detector.tooltip_1", new Object[]{Block.func_196257_b((int)tag.func_74762_e("selectedBlock")).func_177230_c().func_235333_g_().getString()}));
        }
    }
}

