/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.items;

import com.dainxt.dungeonsmod.entity.dungeons.dungeon4.EntityGuard;
import com.dainxt.dungeonsmod.handlers.EntityRegistries;
import com.dainxt.dungeonsmod.items.ItemArmorMaterials;
import com.dainxt.dungeonsmod.sclasses.SItemGroup;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class KingsCrownItem
extends ArmorItem {
    public KingsCrownItem(IArmorMaterial materialIn, EquipmentSlotType slot, Item.Properties builderIn) {
        super(materialIn, slot, builderIn);
    }

    public KingsCrownItem(String name, EquipmentSlotType slot) {
        super((IArmorMaterial)ItemArmorMaterials.KINGCROWN, slot, new Item.Properties().func_200916_a((ItemGroup)SItemGroup.MISC).func_208103_a(Rarity.RARE));
        this.setRegistryName(name);
    }

    private int getMaxCooldown() {
        return 200;
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        super.onArmorTick(stack, world, player);
        if (!world.field_72995_K) {
            CompoundNBT tag = stack.func_77978_p();
            if (tag == null) {
                tag = new CompoundNBT();
            }
            ServerWorld worldserver = (ServerWorld)world;
            this.updateGuard("Guard1", worldserver, player, stack);
            this.updateGuard("Guard2", worldserver, player, stack);
        }
    }

    public void updateGuard(String name, ServerWorld worldserver, PlayerEntity player, ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        UUID guard1UUID = tag.func_74764_b(name + "UUID") ? tag.func_186857_a(name + "UUID") : null;
        int cooldown = tag.func_74762_e("cooldown" + name);
        if (cooldown > 0) {
            if (guard1UUID == null || worldserver.func_217461_a(guard1UUID) == null) {
                tag.func_74768_a("cooldown" + name, --cooldown);
            }
        } else if (guard1UUID == null) {
            guard1UUID = this.summonGuard(worldserver, player);
            if (guard1UUID != null) {
                tag.func_74768_a("cooldown" + name, this.getMaxCooldown());
                tag.func_186854_a(name + "UUID", guard1UUID);
            }
        } else if (worldserver.func_217461_a(guard1UUID) == null) {
            tag.func_82580_o(name + "UUID");
        }
        stack.func_77982_d(tag);
    }

    public UUID summonGuard(ServerWorld world, PlayerEntity player) {
        BlockPos pos = player.func_233580_cy_();
        EntityGuard guard = new EntityGuard(EntityRegistries.GUARD, (World)world);
        guard.func_70012_b((float)pos.func_177958_n() + 0.5f, pos.func_177956_o(), (float)pos.func_177952_p() + 0.5f, world.func_201674_k().nextFloat() * 360.0f, 0.0f);
        guard.func_213386_a((IServerWorld)world, world.func_175649_E(pos), SpawnReason.MOB_SUMMONED, (ILivingEntityData)new EntityGuard.GroupData(false, true), null);
        world.func_217376_c((Entity)guard);
        guard.func_193101_c(player);
        return guard.func_110124_au();
    }
}

