/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.sclasses;

import com.dainxt.dungeonsmod.entity.EntityExtraPart;
import com.dainxt.dungeonsmod.interfaces.IEntityExtraPart;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public abstract class EntityMultiPart
extends MonsterEntity
implements IEntityExtraPart {
    public ArrayList<EntityExtraPart> extraParts = new ArrayList();

    public EntityMultiPart(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        this.initExtraParts(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.spawnExtraParts(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void spawnExtraParts(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        for (EntityExtraPart extraPart : this.extraParts) {
            extraPart.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0f, 0.0f);
            extraPart.func_213386_a(worldIn, difficultyIn, reason, new EntityExtraPart.GroupData(this.getExtraPartType()), dataTag);
            worldIn.func_217376_c((Entity)extraPart);
        }
    }

    public Vector3d getPositionFromVector(Vector3d origin, float yawOffset, float pitchOffset, double distanceOrigin) {
        float yaw = this.field_70177_z + yawOffset;
        float pitch = this.field_70125_A + pitchOffset;
        float yawSin = MathHelper.func_76126_a((float)((float)((double)yaw * (Math.PI / 180))));
        float yawCos = MathHelper.func_76134_b((float)((float)((double)yaw * (Math.PI / 180))));
        float pitchSin = MathHelper.func_76126_a((float)((float)((double)pitch * (Math.PI / 180))));
        float pitchCos = MathHelper.func_76134_b((float)((float)((double)pitch * (Math.PI / 180))));
        double tentaclePosX = origin.field_72450_a - (double)yawSin * (distanceOrigin * (double)MathHelper.func_76135_e((float)pitchCos));
        double tentaclePosZ = origin.field_72449_c + (double)yawCos * (distanceOrigin * (double)MathHelper.func_76135_e((float)pitchCos));
        double tentaclePosY = origin.field_72448_b - (double)pitchSin * distanceOrigin;
        return new Vector3d(tentaclePosX, tentaclePosY, tentaclePosZ);
    }

    public void setPartBoundingPosition(EntityExtraPart tentacle, float yawOffset, float pitchOffset, double distanceOrigin) {
        Vector3d origin = this.func_213303_ch();
        origin = origin.func_72441_c(0.0, (this.func_174813_aQ().field_72337_e - this.func_174813_aQ().field_72338_b) / 2.0, 0.0);
        this.setPartBoundingPosition(tentacle, origin, yawOffset, pitchOffset, distanceOrigin);
    }

    public void setPartBoundingPosition(EntityExtraPart tentacle, Vector3d origin, float yawOffset, float pitchOffset, double distanceOrigin) {
        if (tentacle != null && tentacle.func_70089_S()) {
            Vector3d finalPos = this.getPositionFromVector(origin, yawOffset, pitchOffset, distanceOrigin);
            Vector3d finalTentaclePos = new Vector3d(finalPos.field_72450_a, finalPos.field_72448_b - (double)(tentacle.func_213302_cg() / 2.0f), finalPos.field_72449_c);
            tentacle.func_70080_a(finalTentaclePos.field_72450_a, finalTentaclePos.field_72448_b, finalTentaclePos.field_72449_c, tentacle.field_70177_z, tentacle.field_70125_A);
            tentacle.func_213317_d(Vector3d.field_186680_a);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.updateExtraParts();
    }

    @Override
    public ArrayList<EntityExtraPart> getParts() {
        return this.extraParts;
    }

    public void func_70645_a(DamageSource cause) {
        this.getParts().forEach(extraPart -> extraPart.func_70606_j(0.0f));
        super.func_70645_a(cause);
    }

    protected abstract EntityExtraPart.ExtraPartType getExtraPartType();

    protected abstract void initExtraParts(IServerWorld var1, DifficultyInstance var2, SpawnReason var3, ILivingEntityData var4, CompoundNBT var5);

    protected abstract void updateExtraParts();
}

