/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.util;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityUtils {
    public static boolean entityHaveAllArmor(LivingEntity player, IArmorMaterial material) {
        return StreamSupport.stream(player.func_184193_aE().spliterator(), false).collect(Collectors.toList()).stream().allMatch(piece -> {
            if (piece.func_77973_b() instanceof ArmorItem) {
                return ((ArmorItem)piece.func_77973_b()).func_200880_d().equals(material);
            }
            return false;
        });
    }

    public static void destroyBlocksInAABB(LivingEntity user, Block ... blockList) {
        EntityUtils.destroyBlocksInAABB(user, 0.0, blockList);
    }

    public static void destroyBlocksInAABB(LivingEntity entity, double growValue, Block ... blockList) {
        EntityUtils.scanBlocksInAABB(entity, entity.func_174813_aQ().func_186662_g(growValue), (BlockPos blockPos, BlockState blockState) -> {
            boolean destroyAll = false;
            if (blockList == null) {
                destroyAll = true;
            }
            if (destroyAll) {
                entity.field_70170_p.func_175656_a(blockPos, Blocks.field_150350_a.func_176223_P());
            } else {
                for (Block blockInList : blockList) {
                    if (blockState.func_177230_c() != blockInList || blockState.func_177230_c().equals(Blocks.field_150357_h)) continue;
                    entity.field_70170_p.func_175656_a(blockPos, Blocks.field_150350_a.func_176223_P());
                }
            }
            return false;
        });
    }

    public static boolean scanBlocksInAABB(LivingEntity user, BiFunction<BlockPos, BlockState, Boolean> blockChecker) {
        return EntityUtils.scanBlocksInAABB(user, user.func_174813_aQ(), blockChecker);
    }

    public static boolean scanBlocksInAABB(LivingEntity user, AxisAlignedBB p_70972_1_, BiFunction<BlockPos, BlockState, Boolean> blockChecker) {
        World world = user.func_130014_f_();
        int i = MathHelper.func_76128_c((double)p_70972_1_.field_72340_a);
        int j = MathHelper.func_76128_c((double)p_70972_1_.field_72338_b);
        int k = MathHelper.func_76128_c((double)p_70972_1_.field_72339_c);
        int l = MathHelper.func_76128_c((double)p_70972_1_.field_72336_d);
        int i1 = MathHelper.func_76128_c((double)p_70972_1_.field_72337_e);
        int j1 = MathHelper.func_76128_c((double)p_70972_1_.field_72334_f);
        boolean destroyed = false;
        for (int k1 = i; k1 <= l; ++k1) {
            for (int l1 = j; l1 <= i1; ++l1) {
                for (int i2 = k; i2 <= j1; ++i2) {
                    BlockPos blockpos = new BlockPos(k1, l1, i2);
                    BlockState blockState = world.func_180495_p(blockpos);
                    Block block = blockState.func_177230_c();
                    if (!ForgeEventFactory.getMobGriefingEvent((World)world, (Entity)user) || !block.canEntityDestroy(blockState, (IBlockReader)world, blockpos, (Entity)user) || !ForgeEventFactory.onEntityDestroyBlock((LivingEntity)user, (BlockPos)blockpos, (BlockState)blockState)) continue;
                    destroyed = blockChecker.apply(blockpos, blockState) != false || destroyed;
                }
            }
        }
        return destroyed;
    }

    public static <T> T scanBlocksInAABB(Entity user, AxisAlignedBB p_70972_1_, TriFunction<BlockPos, BlockState, T, T> blockChecker) {
        World world = user.func_130014_f_();
        int i = MathHelper.func_76128_c((double)p_70972_1_.field_72340_a);
        int j = MathHelper.func_76128_c((double)p_70972_1_.field_72338_b);
        int k = MathHelper.func_76128_c((double)p_70972_1_.field_72339_c);
        int l = MathHelper.func_76128_c((double)p_70972_1_.field_72336_d);
        int i1 = MathHelper.func_76128_c((double)p_70972_1_.field_72337_e);
        int j1 = MathHelper.func_76128_c((double)p_70972_1_.field_72334_f);
        Object returnValue = null;
        for (int k1 = i; k1 <= l; ++k1) {
            for (int l1 = j; l1 <= i1; ++l1) {
                for (int i2 = k; i2 <= j1; ++i2) {
                    BlockPos blockpos = new BlockPos(k1, l1, i2);
                    BlockState blockState = world.func_180495_p(blockpos);
                    returnValue = blockChecker.apply(blockpos, blockState, returnValue);
                }
            }
        }
        return (T)returnValue;
    }

    @FunctionalInterface
    public static interface TriFunction<A, B, C, R> {
        public R apply(A var1, B var2, C var3);

        default public <V> TriFunction<A, B, C, V> andThen(Function<? super R, ? extends V> after) {
            Objects.requireNonNull(after);
            return (a, b, c) -> after.apply((R)this.apply(a, b, c));
        }
    }
}

