/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.world.gen.generators;

import com.dainxt.dungeonsmod.entity.boss.EntityKraken;
import com.dainxt.dungeonsmod.handlers.EntityRegistries;
import com.dainxt.dungeonsmod.handlers.StructureRegistries;
import com.dainxt.dungeonsmod.world.gen.generators.PieceBase;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.loot.LootTables;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.properties.StructureMode;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.DispenserTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class Dungeon3Generator {

    public static class Piece
    extends PieceBase {
        public Piece(TemplateManager structureManager, ResourceLocation identifier, BlockPos blockPos, Rotation rotation) {
            super(structureManager, identifier, blockPos, rotation, StructureRegistries.dungeon3_piece, 0);
        }

        public Piece(TemplateManager structureManager, CompoundNBT compoundTag) {
            super(structureManager, compoundTag, StructureRegistries.dungeon3_piece);
        }

        protected void func_186175_a(String function, BlockPos pos, IServerWorld world, Random rand, MutableBoundingBox sbb) {
            TileEntity tileentity;
            BlockPos blockpos2;
            if ("dispenser".equals(function)) {
                blockpos2 = pos;
                world.func_180501_a(blockpos2, Blocks.field_150350_a.func_176223_P(), 3);
                tileentity = world.func_175625_s(blockpos2.func_177979_c(2));
                if (tileentity instanceof DispenserTileEntity) {
                    ((DispenserTileEntity)tileentity).func_189404_a(LootTables.field_189420_m, world.func_201674_k().nextLong());
                }
            }
            if ("chest".equals(function)) {
                blockpos2 = pos;
                world.func_180501_a(blockpos2, Blocks.field_150350_a.func_176223_P(), 3);
                tileentity = world.func_175625_s(blockpos2.func_177979_c(1));
                if (tileentity instanceof ChestTileEntity) {
                    ((ChestTileEntity)tileentity).func_189404_a(LootTables.field_204773_u, world.func_201674_k().nextLong());
                }
            }
            if ("head".equals(function)) {
                BlockPos initialPos = pos;
                EntityKraken kraken = new EntityKraken(EntityRegistries.KRAKEN, (World)world.func_201672_e());
                kraken.func_70012_b(initialPos.func_177958_n(), (float)initialPos.func_177956_o() + 20.0f, initialPos.func_177952_p(), 0.0f, 0.0f);
                kraken.func_213386_a(world, world.func_175649_E(initialPos), SpawnReason.STRUCTURE, null, null);
                world.func_217376_c((Entity)kraken);
            }
        }

        @Override
        public BlockPos preCheckPlacement(ISeedReader iWorld, StructureManager structureAccessor, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox boundingBox, ChunkPos chunkPos, BlockPos blockPos) {
            if (this.field_186178_c.func_177956_o() == 1) {
                int yMin = Integer.MAX_VALUE;
                int deltaMin = Integer.MAX_VALUE;
                this.field_186177_b.func_186223_a(null);
                this.field_74887_e = this.field_186176_a.func_215388_b(this.field_186177_b, this.field_186178_c);
                for (Template.BlockInfo template$blockinfo : this.field_186176_a.func_215381_a(this.field_186178_c, this.field_186177_b, Blocks.field_185779_df)) {
                    String metadata;
                    StructureMode structuremode;
                    if (template$blockinfo.field_186244_c == null || (structuremode = StructureMode.valueOf((String)template$blockinfo.field_186244_c.func_74779_i("mode"))) != StructureMode.DATA || !(metadata = template$blockinfo.field_186244_c.func_74779_i("metadata")).equals("surface")) continue;
                    this.field_186177_b.func_186223_a(boundingBox);
                    int yHeight1 = iWorld.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, template$blockinfo.field_186242_a.func_177958_n(), template$blockinfo.field_186242_a.func_177952_p());
                    int yHeight = chunkGenerator.func_222532_b(template$blockinfo.field_186242_a.func_177958_n(), template$blockinfo.field_186242_a.func_177952_p(), Heightmap.Type.OCEAN_FLOOR_WG);
                    if (yHeight >= yMin || yHeight == 0) continue;
                    yMin = yHeight;
                    deltaMin = template$blockinfo.field_186242_a.func_177956_o();
                }
                int finalHeight = yMin - deltaMin;
                if (yMin > 256) {
                    int yHeight = iWorld.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, this.field_186178_c.func_177958_n() + 8, this.field_186178_c.func_177952_p() + 8);
                    this.field_186178_c = this.field_186178_c.func_177982_a(0, yHeight + this.getYOffset(), 0);
                } else {
                    this.field_186178_c = this.field_186178_c.func_177982_a(0, finalHeight - 1, 0);
                }
            }
            return this.field_186178_c;
        }

        @Override
        protected int getYOffset() {
            return -21;
        }

        @Override
        protected StructureProcessor getCustomIgnoreProcessor() {
            return new BlockIgnoreStructureProcessor((List)ImmutableList.of((Object)Blocks.field_150350_a));
        }
    }
}

