/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.world.gen.generators;

import com.dainxt.dungeonsmod.config.DungeonsModConfig;
import com.dainxt.dungeonsmod.entity.boss.EntityCrawler;
import com.dainxt.dungeonsmod.entity.dungeons.dungeon5.EntityScientist;
import com.dainxt.dungeonsmod.entity.dungeons.dungeon5.EntitySlimewolf;
import com.dainxt.dungeonsmod.handlers.EntityRegistries;
import com.dainxt.dungeonsmod.handlers.StructureRegistries;
import com.dainxt.dungeonsmod.util.WrittenBooks;
import com.dainxt.dungeonsmod.world.gen.generators.PieceBase;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RedstoneLampBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootTables;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.state.Property;
import net.minecraft.state.properties.StructureMode;
import net.minecraft.tileentity.BrewingStandTileEntity;
import net.minecraft.tileentity.DispenserTileEntity;
import net.minecraft.tileentity.FurnaceTileEntity;
import net.minecraft.tileentity.ShulkerBoxTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraftforge.registries.ForgeRegistries;

public class Dungeon5Generator {
    public static ItemStack getRandomPotion(World world) {
        ItemStack stack = ItemStack.field_190927_a;
        if (world.func_201674_k().nextInt(3) == 0) {
            int index = world.func_201674_k().nextInt(ForgeRegistries.POTION_TYPES.getValues().size());
            for (Potion potionType : ForgeRegistries.POTION_TYPES.getValues()) {
                stack = PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_185155_bH), (Potion)potionType);
                if (--index > 0) continue;
                break;
            }
        }
        return stack;
    }

    public static class Piece
    extends PieceBase {
        public Piece(TemplateManager structureManager, ResourceLocation identifier, BlockPos blockPos, Rotation rotation) {
            super(structureManager, identifier, blockPos, rotation, StructureRegistries.dungeon5_piece, 0);
        }

        public Piece(TemplateManager structureManager, CompoundNBT compoundTag) {
            super(structureManager, compoundTag, StructureRegistries.dungeon5_piece);
        }

        protected void func_186175_a(String function, BlockPos pos, IServerWorld world, Random rand, MutableBoundingBox sbb) {
            MonsterEntity crawler;
            BlockPos initialPos;
            TileEntity tileentity;
            BlockPos blockpos2;
            if ("furnace".equals(function)) {
                blockpos2 = pos;
                world.func_180501_a(blockpos2, Blocks.field_150350_a.func_176223_P(), 3);
                tileentity = world.func_175625_s(blockpos2.func_177977_b());
                if (tileentity instanceof FurnaceTileEntity) {
                    ItemStack stack = new ItemStack((IItemProvider)Items.field_151044_h);
                    stack.func_190920_e(world.func_201674_k().nextInt(31) + 1);
                    ((FurnaceTileEntity)tileentity).func_70299_a(1, stack);
                }
            }
            if ("frame_pickaxe".equals(function)) {
                BlockPos blockpos1 = pos;
                world.func_180501_a(blockpos1, Blocks.field_150343_Z.func_176223_P(), 3);
                BlockPos blockpos22 = blockpos1.func_177979_c(1);
                for (ItemStack facing : Direction.values()) {
                    BlockPos blockpos3 = blockpos22.func_177972_a(facing.func_176734_d());
                    BlockState iblockstate = world.func_180495_p(blockpos3);
                    Block block = iblockstate.func_177230_c();
                    if (block.equals(Blocks.field_150359_w) || block.equals(Blocks.field_150343_Z) || !facing.func_176740_k().func_176722_c() || !iblockstate.func_224755_d((IBlockReader)world, blockpos3, (Direction)facing)) continue;
                    ItemFrameEntity itemframeentity = new ItemFrameEntity((World)world.func_201672_e(), blockpos22, (Direction)facing);
                    itemframeentity.func_174864_a(WrittenBooks.getTranslatableBook("7"), false);
                    world.func_217376_c((Entity)itemframeentity);
                    break;
                }
            }
            if ("spawn_scientist".equals(function)) {
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                if (world.func_201674_k().nextFloat() < (float)DungeonsModConfig.COMMON.scientist.getWeight() / 100.0f) {
                    initialPos = pos;
                    crawler = new EntityScientist(EntityRegistries.SCIENTIST, (World)world.func_201672_e());
                    crawler.func_70012_b((double)((float)initialPos.func_177958_n() + 0.5f), (double)initialPos.func_177956_o(), (double)((float)initialPos.func_177952_p() + 0.5f), world.func_201674_k().nextFloat() * 360.0f, 0.0f);
                    world.func_217376_c((Entity)crawler);
                }
            }
            if ("spawn_slimewolf".equals(function)) {
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                initialPos = pos;
                if (world.func_201674_k().nextFloat() < (float)DungeonsModConfig.COMMON.slimewolf.getWeight() / 100.0f) {
                    crawler = new EntitySlimewolf(EntityRegistries.SLIMEWOLF, (World)world.func_201672_e());
                    crawler.func_70012_b((double)((float)initialPos.func_177958_n() + 0.5f), (double)initialPos.func_177956_o(), (double)((float)initialPos.func_177952_p() + 0.5f), world.func_201674_k().nextFloat() * 360.0f, 0.0f);
                    world.func_217376_c((Entity)crawler);
                }
            }
            if ("brew".equals(function)) {
                blockpos2 = pos;
                world.func_180501_a(blockpos2, Blocks.field_150350_a.func_176223_P(), 3);
                tileentity = world.func_175625_s(blockpos2.func_177977_b());
                if (tileentity instanceof BrewingStandTileEntity) {
                    ((BrewingStandTileEntity)tileentity).func_70299_a(0, Dungeon5Generator.getRandomPotion((World)world.func_201672_e()));
                    ((BrewingStandTileEntity)tileentity).func_70299_a(1, Dungeon5Generator.getRandomPotion((World)world.func_201672_e()));
                    ((BrewingStandTileEntity)tileentity).func_70299_a(2, Dungeon5Generator.getRandomPotion((World)world.func_201672_e()));
                }
            }
            if ("lamp".equals(function)) {
                blockpos2 = pos;
                world.func_180501_a(blockpos2, Blocks.field_150451_bX.func_176223_P(), 3);
                world.func_180501_a(blockpos2.func_177977_b(), (BlockState)Blocks.field_150379_bu.func_176223_P().func_206870_a((Property)RedstoneLampBlock.field_196502_a, (Comparable)Boolean.valueOf(true)), 3);
            }
            if ("shulker".equals(function)) {
                blockpos2 = pos;
                world.func_180501_a(blockpos2, Blocks.field_150350_a.func_176223_P(), 3);
                tileentity = world.func_175625_s(blockpos2.func_177977_b());
                if (tileentity instanceof ShulkerBoxTileEntity) {
                    ((ShulkerBoxTileEntity)tileentity).func_189404_a(LootTables.field_204312_r, world.func_201674_k().nextLong());
                }
                if ((tileentity = world.func_175625_s(blockpos2.func_177984_a())) instanceof ShulkerBoxTileEntity) {
                    ((ShulkerBoxTileEntity)tileentity).func_189404_a(LootTables.field_204312_r, world.func_201674_k().nextLong());
                }
            }
            if ("dispenser".equals(function)) {
                blockpos2 = pos;
                world.func_180501_a(blockpos2, Blocks.field_150371_ca.func_176223_P(), 3);
                tileentity = world.func_175625_s(blockpos2.func_177977_b());
                if (tileentity instanceof DispenserTileEntity) {
                    ((DispenserTileEntity)tileentity).func_189404_a(LootTables.field_204312_r, world.func_201674_k().nextLong());
                }
                if ((tileentity = world.func_175625_s(blockpos2.func_177979_c(2))) instanceof DispenserTileEntity) {
                    ((DispenserTileEntity)tileentity).func_189404_a(LootTables.field_204312_r, world.func_201674_k().nextLong());
                }
            }
            if ("heart".equals(function)) {
                blockpos2 = pos;
                world.func_180501_a(blockpos2, Blocks.field_150451_bX.func_176223_P(), 3);
            }
            if ("crawler".equals(function)) {
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                initialPos = pos;
                crawler = new EntityCrawler(EntityRegistries.CRAWLER, (World)world.func_201672_e());
                crawler.func_70012_b((double)initialPos.func_177958_n(), (double)initialPos.func_177956_o(), (double)initialPos.func_177952_p(), 0.0f, 0.0f);
                PlacementSettings withoutBoundsSettings = this.field_186177_b.func_186217_a();
                for (Template.BlockInfo template$blockinfo : this.field_186176_a.func_215381_a(this.field_186178_c, withoutBoundsSettings.func_186223_a(null), Blocks.field_185779_df)) {
                    StructureMode structuremode;
                    if (template$blockinfo.field_186244_c == null || (structuremode = StructureMode.valueOf((String)template$blockinfo.field_186244_c.func_74779_i("mode"))) != StructureMode.DATA) continue;
                    String metadata = template$blockinfo.field_186244_c.func_74779_i("metadata");
                    BlockPos heartPos = template$blockinfo.field_186242_a;
                    if (!"heart".equals(metadata)) continue;
                    crawler.HEART_PLACES.add(heartPos);
                }
                world.func_217376_c((Entity)crawler);
            }
        }

        @Override
        protected int getYOffset() {
            return -25;
        }
    }
}

