/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.world.gen.generators;

import com.dainxt.dungeonsmod.handlers.ItemRegistries;
import com.dainxt.dungeonsmod.handlers.StructureRegistries;
import com.dainxt.dungeonsmod.util.WrittenBooks;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.ShulkerBoxTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.jigsaw.IJigsawDeserializer;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.SingleJigsawPiece;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.template.AlwaysTrueRuleTest;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.ProcessorLists;
import net.minecraft.world.gen.feature.template.RandomBlockMatchRuleTest;
import net.minecraft.world.gen.feature.template.RuleEntry;
import net.minecraft.world.gen.feature.template.RuleStructureProcessor;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.StructureProcessorList;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class DungeonSide31Generator
extends SingleJigsawPiece {
    public static final Codec<DungeonSide31Generator> CODEC = RecordCodecBuilder.create(p_236841_0_ -> p_236841_0_.group((App)DungeonSide31Generator.func_236846_c_(), (App)DungeonSide31Generator.func_236844_b_(), (App)DungeonSide31Generator.func_236848_d_()).apply((Applicative)p_236841_0_, DungeonSide31Generator::new));

    protected DungeonSide31Generator(Either<ResourceLocation, Template> p_i242008_1_, Supplier<StructureProcessorList> p_i242008_2_, JigsawPattern.PlacementBehaviour p_i242008_3_) {
        super(p_i242008_1_, p_i242008_2_, p_i242008_3_);
    }

    protected PlacementSettings func_230379_a_(Rotation p_230379_1_, MutableBoundingBox p_230379_2_, boolean p_230379_3_) {
        PlacementSettings placeSettings = super.func_230379_a_(p_230379_1_, p_230379_2_, p_230379_3_);
        placeSettings.func_215222_a((StructureProcessor)new RuleStructureProcessor((List)ImmutableList.of((Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_150357_h, 0.7f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150347_e.func_176223_P()))));
        placeSettings.func_215222_a((StructureProcessor)new RuleStructureProcessor((List)ImmutableList.of((Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_150347_e, 0.9f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150341_Y.func_176223_P()))));
        placeSettings.func_215222_a(this.getCustomIgnoreProcessor());
        return placeSettings;
    }

    public boolean func_230378_a_(TemplateManager p_230378_1_, ISeedReader p_230378_2_, StructureManager p_230378_3_, ChunkGenerator p_230378_4_, BlockPos p_230378_5_, BlockPos p_230378_6_, Rotation p_230378_7_, MutableBoundingBox p_230378_8_, Random p_230378_9_, boolean p_230378_10_) {
        PlacementSettings placementsettings;
        Template template = (Template)this.field_236839_c_.map(arg_0 -> ((TemplateManager)p_230378_1_).func_200220_a(arg_0), Function.identity());
        if (!template.func_237146_a_((IServerWorld)p_230378_2_, p_230378_5_, p_230378_6_, placementsettings = this.func_230379_a_(p_230378_7_, p_230378_8_, p_230378_10_), p_230378_9_, 18)) {
            return false;
        }
        for (Template.BlockInfo template$blockinfo : DungeonSide31Generator.processBlockInfos((IWorld)p_230378_2_, p_230378_5_, p_230378_6_, placementsettings, this.func_214857_a(p_230378_1_, p_230378_5_, p_230378_7_, false), template)) {
            this.func_214846_a((IWorld)p_230378_2_, template$blockinfo, p_230378_5_, p_230378_7_, p_230378_9_, p_230378_8_);
        }
        return true;
    }

    public static List<Template.BlockInfo> processBlockInfos(IWorld p_237145_0_, BlockPos p_237145_1_, BlockPos p_237145_2_, PlacementSettings p_237145_3_, List<Template.BlockInfo> p_237145_4_, @Nullable Template template) {
        ArrayList list = Lists.newArrayList();
        for (Template.BlockInfo template$blockinfo : p_237145_4_) {
            BlockPos blockpos = Template.func_186266_a((PlacementSettings)p_237145_3_, (BlockPos)template$blockinfo.field_186242_a).func_177971_a((Vector3i)p_237145_1_);
            Template.BlockInfo template$blockinfo1 = new Template.BlockInfo(blockpos, template$blockinfo.field_186243_b, template$blockinfo.field_186244_c != null ? template$blockinfo.field_186244_c.func_74737_b() : null);
            if (template$blockinfo1 == null) continue;
            list.add(template$blockinfo1);
        }
        return list;
    }

    public void func_214846_a(IWorld world, Template.BlockInfo p_214846_2_, BlockPos piecePos, Rotation rotationIn, Random rand, MutableBoundingBox p_214846_6_) {
        String structureMode;
        super.func_214846_a(world, p_214846_2_, piecePos, rotationIn, rand, p_214846_6_);
        if (p_214846_2_.field_186244_c != null && (structureMode = p_214846_2_.field_186244_c.func_74779_i("mode")).toLowerCase().contains("data")) {
            TileEntity tileentity;
            BlockPos blockpos2;
            String function = p_214846_2_.field_186244_c.func_74779_i("metadata");
            BlockPos pos = p_214846_2_.field_186242_a;
            if ("spawner_bat".equals(function)) {
                blockpos2 = pos;
                if (world.func_201674_k().nextInt(5) == 0) {
                    world.func_180501_a(blockpos2, Blocks.field_150474_ac.func_176223_P(), 2);
                    tileentity = world.func_175625_s(blockpos2);
                    if (tileentity instanceof MobSpawnerTileEntity) {
                        ((MobSpawnerTileEntity)tileentity).func_145881_a().func_200876_a(EntityType.field_200791_e);
                    }
                } else {
                    world.func_180501_a(blockpos2, Blocks.field_150350_a.func_176223_P(), 3);
                }
            }
            if ("shulker".equals(function)) {
                blockpos2 = pos;
                world.func_180501_a(blockpos2, Blocks.field_150350_a.func_176223_P(), 3);
                tileentity = world.func_175625_s(blockpos2.func_177977_b());
                if (tileentity instanceof ShulkerBoxTileEntity) {
                    ((ShulkerBoxTileEntity)tileentity).func_70299_a(0, new ItemStack((IItemProvider)ItemRegistries.UNSTABLE_MAP));
                    ((ShulkerBoxTileEntity)tileentity).func_70299_a(13, WrittenBooks.getTranslatableBook("8"));
                }
                if ((tileentity = world.func_175625_s(blockpos2.func_177984_a())) instanceof ShulkerBoxTileEntity) {
                    ((ShulkerBoxTileEntity)tileentity).func_70299_a(0, new ItemStack((IItemProvider)ItemRegistries.UNSTABLE_MAP));
                    ((ShulkerBoxTileEntity)tileentity).func_70299_a(13, WrittenBooks.getTranslatableBook("8"));
                }
            }
        }
    }

    protected StructureProcessor getCustomIgnoreProcessor() {
        return new BlockIgnoreStructureProcessor((List)ImmutableList.of((Object)Blocks.field_150354_m));
    }

    public IJigsawDeserializer<?> func_214853_a() {
        return StructureRegistries.dungeonside31_piece;
    }

    public String toString() {
        return "DungeonSide31Generator[" + this.field_236839_c_ + "]";
    }

    public static Function<JigsawPattern.PlacementBehaviour, DungeonSide31Generator> createCustom(String p_242849_0_) {
        return p_242860_1_ -> new DungeonSide31Generator((Either<ResourceLocation, Template>)Either.left((Object)new ResourceLocation(p_242849_0_)), () -> ProcessorLists.field_244101_a, (JigsawPattern.PlacementBehaviour)p_242860_1_);
    }
}

