/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.world.gen.generators;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.properties.StructureMode;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public abstract class PieceBase
extends TemplateStructurePiece {
    protected Rotation field_186169_c;
    protected ResourceLocation identifier;

    public PieceBase(TemplateManager structureManager, ResourceLocation identifier, BlockPos blockPos, Rotation rotation, IStructurePieceType structurePieceType, int i) {
        super(structurePieceType, i);
        this.field_186178_c = blockPos;
        this.field_186169_c = rotation;
        this.identifier = identifier;
        this.setStructureData(structureManager);
    }

    public PieceBase(TemplateManager structureManager, CompoundNBT compoundTag, IStructurePieceType structurePieceType) {
        super(structurePieceType, compoundTag);
        this.identifier = new ResourceLocation(compoundTag.func_74779_i("Template"));
        this.field_186169_c = Rotation.valueOf((String)compoundTag.func_74779_i("Rot"));
        this.setStructureData(structureManager);
    }

    protected void func_143011_b(CompoundNBT compoundTag_1) {
        super.func_143011_b(compoundTag_1);
        compoundTag_1.func_74778_a("Template", this.identifier.toString());
        compoundTag_1.func_74778_a("Rot", this.field_186169_c.name());
    }

    public void setStructureData(TemplateManager structureManager) {
        Template structure_1 = structureManager.func_200219_b(this.identifier);
        PlacementSettings structurePlacementData_1 = new PlacementSettings().func_186222_a(true).func_186220_a(this.field_186169_c).func_186214_a(Mirror.NONE).func_207665_a(this.field_186178_c).func_215222_a(this.getCustomIgnoreProcessor()).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
        this.func_186173_a(structure_1, this.field_186178_c, structurePlacementData_1);
    }

    public BlockPos preCheckPlacement(ISeedReader iWorld, StructureManager structureAccessor, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox boundingBox, ChunkPos chunkPos, BlockPos blockPos) {
        if (this.field_186178_c.func_177956_o() == 1) {
            int yMin = Integer.MAX_VALUE;
            int deltaMin = Integer.MAX_VALUE;
            this.field_186177_b.func_186223_a(null);
            this.field_74887_e = this.field_186176_a.func_215388_b(this.field_186177_b, this.field_186178_c);
            for (Template.BlockInfo template$blockinfo : this.field_186176_a.func_215381_a(this.field_186178_c, this.field_186177_b, Blocks.field_185779_df)) {
                String metadata;
                StructureMode structuremode;
                if (template$blockinfo.field_186244_c == null || (structuremode = StructureMode.valueOf((String)template$blockinfo.field_186244_c.func_74779_i("mode"))) != StructureMode.DATA || !(metadata = template$blockinfo.field_186244_c.func_74779_i("metadata")).equals("surface")) continue;
                this.field_186177_b.func_186223_a(boundingBox);
                int yHeight1 = iWorld.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, template$blockinfo.field_186242_a.func_177958_n(), template$blockinfo.field_186242_a.func_177952_p());
                int yHeight = chunkGenerator.func_222532_b(template$blockinfo.field_186242_a.func_177958_n(), template$blockinfo.field_186242_a.func_177952_p(), Heightmap.Type.WORLD_SURFACE_WG);
                if (yHeight >= yMin || yHeight == 0) continue;
                yMin = yHeight;
                deltaMin = template$blockinfo.field_186242_a.func_177956_o();
            }
            int finalHeight = yMin - deltaMin;
            if (yMin > 256) {
                int yHeight = iWorld.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, this.field_186178_c.func_177958_n() + 8, this.field_186178_c.func_177952_p() + 8);
                this.field_186178_c = this.field_186178_c.func_177982_a(0, yHeight + this.getYOffset(), 0);
            } else {
                this.field_186178_c = this.field_186178_c.func_177982_a(0, finalHeight - 1, 0);
            }
        }
        return this.field_186178_c;
    }

    public boolean func_230383_a_(ISeedReader iWorld, StructureManager structureAccessor, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox boundingBox, ChunkPos chunkPos, BlockPos blockPos) {
        this.preCheckPlacement(iWorld, structureAccessor, chunkGenerator, random, boundingBox, chunkPos, blockPos);
        boolean flag = super.func_230383_a_(iWorld, structureAccessor, chunkGenerator, random, boundingBox, chunkPos, blockPos);
        return flag;
    }

    protected abstract int getYOffset();

    protected StructureProcessor getCustomIgnoreProcessor() {
        return new BlockIgnoreStructureProcessor((List)ImmutableList.of((Object)Blocks.field_150354_m));
    }
}

