/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.world.gen.structures;

import com.dainxt.dungeonsmod.handlers.EntityRegistries;
import com.dainxt.dungeonsmod.interfaces.IDungeon;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Random;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.gen.settings.StructureSeparationSettings;

abstract class DungeonBase
extends Structure<NoFeatureConfig>
implements IDungeon {
    private static final List<MobSpawnInfo.Spawners> field_202381_d = ImmutableList.of((Object)new MobSpawnInfo.Spawners(EntityRegistries.MIMIC, 1, 1, 1));

    public DungeonBase(ResourceLocation name, Codec<NoFeatureConfig> codec) {
        super(codec);
        this.setRegistryName(name);
    }

    public List<MobSpawnInfo.Spawners> getDefaultSpawnList() {
        return field_202381_d;
    }

    protected boolean func_230363_a_(ChunkGenerator p_230363_1_, BiomeProvider p_230363_2_, long p_230363_3_, SharedSeedRandom p_230363_5_, int p_230363_6_, int p_230363_7_, Biome p_230363_8_, ChunkPos p_230363_9_, NoFeatureConfig p_230363_10_) {
        for (Biome biome : p_230363_2_.func_225530_a_(p_230363_6_ * 16 + 9, p_230363_1_.func_230356_f_(), p_230363_7_ * 16 + 9, 16)) {
            if (biome.func_242440_e().func_242493_a((Structure)this)) continue;
            return false;
        }
        int chance = this.getChance();
        return chance >= 1 ? p_230363_5_.nextInt(chance) == 0 : false;
    }

    public BlockPos func_236388_a_(IWorldReader world, StructureManager manager, BlockPos p_236388_3_, int radius, boolean skipExistingChunks, long seed, StructureSeparationSettings separationSettings) {
        return this.getChance() >= 1 ? super.func_236388_a_(world, manager, p_236388_3_, radius, skipExistingChunks, seed, separationSettings) : null;
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return MyStructureStart::new;
    }

    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.SURFACE_STRUCTURES;
    }

    @Override
    public RegistryKey<DimensionSettings> getDimensionSettings() {
        return DimensionSettings.field_242734_c;
    }

    public static class MyStructureStart
    extends StructureStart<NoFeatureConfig> {
        public MyStructureStart(Structure<NoFeatureConfig> structureFeature, int chunkX, int chunkZ, MutableBoundingBox blockBox, int i, long l) {
            super(structureFeature, chunkX, chunkZ, blockBox, i, l);
        }

        public void func_230364_a_(DynamicRegistries p_230364_1_, ChunkGenerator p_230364_2_, TemplateManager manager, int chunkX, int chunkZ, Biome biome, NoFeatureConfig config) {
            int x = chunkX * 16;
            int z = chunkZ * 16;
            BlockPos startingPos = new BlockPos(x, 1, z);
            Rotation rotation = Rotation.NONE;
            ((IDungeon)this.func_214627_k()).addParts(manager, startingPos, rotation, this.field_75075_a, (Random)this.field_214631_d, config);
            this.func_202500_a();
        }
    }
}

