/*
 * Decompiled with CFR 0.152.
 */
package me.jaackson.etched.bridge.fabric;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.jaackson.etched.common.network.EtchedPacket;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.impl.networking.client.ClientNetworkingImpl;
import net.fabricmc.fabric.impl.networking.server.ServerNetworkingImpl;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class NetworkBridgeImpl {
    public static <T extends EtchedPacket> void registerPlayToClient(class_2960 channel, Class<T> messageType, Function<class_2540, T> read, Supplier<Consumer<T>> handle) {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)channel, (client, handler, buf, responseSender) -> ((Consumer)handle.get()).accept((EtchedPacket)read.apply(buf)));
    }

    public static <T extends EtchedPacket> void registerPlayToServer(class_2960 channel, Class<T> messageType, Function<class_2540, T> read, BiConsumer<T, class_1657> handle) {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)channel, (server, player, handler, buf, responseSender) -> handle.accept((Object)((EtchedPacket)read.apply(buf)), (class_1657)player));
    }

    public static void sendToPlayer(class_3222 player, EtchedPacket packet) {
        class_2540 buf = PacketByteBufs.create();
        packet.write(buf);
        ServerPlayNetworking.send((class_3222)player, (class_2960)packet.getChannel(), (class_2540)buf);
    }

    public static void sendToTracking(class_1297 tracking, EtchedPacket packet) {
        class_2540 buf = PacketByteBufs.create();
        packet.write(buf);
        for (class_3222 player : PlayerLookup.tracking((class_1297)tracking)) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)packet.getChannel(), (class_2540)buf);
        }
    }

    public static void sendToNear(class_3218 level, double x, double y, double z, double distance, EtchedPacket packet) {
        class_2540 buf = PacketByteBufs.create();
        packet.write(buf);
        for (class_3222 player : PlayerLookup.around((class_3218)level, (class_243)new class_243(x, y, z), (double)distance)) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)packet.getChannel(), (class_2540)buf);
        }
    }

    public static void sendToServer(EtchedPacket packet) {
        class_2540 buf = PacketByteBufs.create();
        packet.write(buf);
        ClientPlayNetworking.send((class_2960)packet.getChannel(), (class_2540)buf);
    }

    public static class_2596<?> toVanillaPacket(EtchedPacket packet, boolean clientbound) {
        class_2540 buf = PacketByteBufs.create();
        packet.write(buf);
        return clientbound ? ServerNetworkingImpl.createPlayC2SPacket((class_2960)packet.getChannel(), (class_2540)buf) : ClientNetworkingImpl.createPlayC2SPacket((class_2960)packet.getChannel(), (class_2540)buf);
    }
}

