/*
 * Decompiled with CFR 0.152.
 */
package me.jaackson.etched.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Objects;
import me.jaackson.etched.EtchedRegistry;
import me.jaackson.etched.bridge.NetworkBridge;
import me.jaackson.etched.common.item.EtchedMusicDiscItem;
import me.jaackson.etched.common.item.MusicLabelItem;
import me.jaackson.etched.common.menu.EtchingMenu;
import me.jaackson.etched.common.network.ServerboundSetEtchingUrlPacket;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1712;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public class EtchingScreen
extends class_465<EtchingMenu>
implements class_1712 {
    private static final class_2960 TEXTURE = new class_2960("etched", "textures/gui/container/etching_table.png");
    private class_1799 discStack;
    private class_1799 labelStack;
    private class_342 url;
    private int urlTicks;
    private String oldUrl;
    private String invalidReason;
    private boolean displayLabels;

    public EtchingScreen(EtchingMenu menu, class_1661 inventory, class_2561 component) {
        super((class_1703)menu, inventory, component);
        this.field_2779 = 180;
        this.field_25270 += 14;
        this.discStack = class_1799.field_8037;
        this.labelStack = class_1799.field_8037;
        this.invalidReason = "";
    }

    protected void method_25426() {
        super.method_25426();
        this.field_22787.field_1774.method_1462(true);
        this.url = new class_342(this.field_22793, this.field_2776 + 11, this.field_2800 + 25, 154, 16, (class_2561)new class_2588("container.etched.etching_table"));
        this.url.method_1868(-1);
        this.url.method_1860(-1);
        this.url.method_1858(false);
        this.url.method_1880(32500);
        this.url.method_1863(s -> {
            if (!Objects.equals(this.oldUrl, s) && this.urlTicks <= 0) {
                NetworkBridge.sendToServer(new ServerboundSetEtchingUrlPacket(""));
            }
            this.urlTicks = 8;
        });
        this.url.method_1856(true);
        this.field_22786.add(this.url);
        ((EtchingMenu)this.field_2797).method_7596(this);
    }

    public void method_25410(class_310 minecraft, int i, int j) {
        String string = this.url.method_1882();
        this.method_25423(minecraft, i, j);
        this.url.method_1852(string);
    }

    public void method_25432() {
        super.method_25432();
        this.field_22787.field_1774.method_1462(false);
    }

    public void method_25393() {
        super.method_25393();
        this.url.method_1865();
        if (this.urlTicks > 0) {
            --this.urlTicks;
            if (this.urlTicks <= 0 && !Objects.equals(this.oldUrl, this.url.method_1882())) {
                this.oldUrl = this.url.method_1882();
                NetworkBridge.sendToServer(new ServerboundSetEtchingUrlPacket(this.url.method_1882()));
            }
        }
    }

    public void method_7634(class_1703 abstractContainerMenu, class_2371<class_1799> nonNullList) {
        this.method_7635(abstractContainerMenu, 0, abstractContainerMenu.method_7611(0).method_7677());
        this.method_7635(abstractContainerMenu, 1, abstractContainerMenu.method_7611(1).method_7677());
    }

    public void method_7635(class_1703 abstractContainerMenu, int slot, class_1799 stack) {
        if (slot == 0) {
            if (this.discStack.method_7960() && !stack.method_7960()) {
                this.url.method_1852("");
            }
            EtchedMusicDiscItem.getMusic(stack).ifPresent(musicInfo -> this.url.method_1852(musicInfo.getUrl()));
            this.discStack = stack;
        }
        if (slot == 1) {
            this.labelStack = stack;
        }
        boolean editable = this.discStack.method_7909() == EtchedRegistry.ETCHED_MUSIC_DISC.get() || !this.discStack.method_7960() && !this.labelStack.method_7960();
        this.url.method_1888(editable);
        this.url.method_1862(editable);
        this.url.method_1876(editable);
        this.method_25395((class_364)(editable ? this.url : null));
        this.displayLabels = !this.discStack.method_7960() && !this.labelStack.method_7960();
    }

    public void method_7633(class_1703 abstractContainerMenu, int index, int value) {
    }

    public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(poseStack, mouseX, mouseY, partialTicks);
        this.url.method_25394(poseStack, mouseX, mouseY, partialTicks);
        this.method_2380(poseStack, mouseX, mouseY);
    }

    protected void method_2380(class_4587 poseStack, int mouseX, int mouseY) {
        super.method_2380(poseStack, mouseX, mouseY);
        boolean isEtched = this.discStack.method_7909() == EtchedRegistry.ETCHED_MUSIC_DISC.get();
        ArrayList<class_5481> reasonLines = new ArrayList<class_5481>();
        if (!isEtched && !this.discStack.method_7960() && this.labelStack.method_7960()) {
            reasonLines.add(new class_2588("screen.etched.etching_table.error.missing_label").method_30937());
        } else if (!isEtched && this.discStack.method_7960() && !this.labelStack.method_7960()) {
            reasonLines.add(new class_2588("screen.etched.etching_table.error.missing_disc").method_30937());
        } else if (!this.url.method_1882().isEmpty() && !EtchedMusicDiscItem.isValidURL(this.url.method_1882()) || !this.invalidReason.isEmpty()) {
            reasonLines.add(new class_2588("screen.etched.etching_table.error.invalid_url").method_30937());
            if (!this.invalidReason.isEmpty()) {
                reasonLines.addAll(this.field_22793.method_1728((class_5348)new class_2585(this.invalidReason).method_27695(new class_124[]{class_124.field_1080, class_124.field_1056}), 200));
            }
        }
        if (mouseX >= this.field_2776 + 83 && mouseX < this.field_2776 + 110 && mouseY >= this.field_2800 + 44 && mouseY < this.field_2800 + 61) {
            this.method_25417(poseStack, reasonLines, mouseX, mouseY);
        }
    }

    protected void method_2389(class_4587 poseStack, float f, int mouseX, int mouseY) {
        this.method_25420(poseStack);
        this.field_22787.method_1531().method_22813(TEXTURE);
        this.method_25302(poseStack, this.field_2776, this.field_2800, 0, 0, this.field_2792, this.field_2779);
        if (!this.url.method_1882().isEmpty() && !EtchedMusicDiscItem.isValidURL(this.url.method_1882()) || !this.invalidReason.isEmpty() || this.discStack.method_7909() != EtchedRegistry.ETCHED_MUSIC_DISC.get() && (!this.discStack.method_7960() && this.labelStack.method_7960() || this.discStack.method_7960() && !this.labelStack.method_7960())) {
            this.method_25302(poseStack, this.field_2776 + 83, this.field_2800 + 44, 0, 226, 27, 17);
        }
        this.method_25302(poseStack, this.field_2776 + 9, this.field_2800 + 21, 0, this.discStack.method_7909() == EtchedRegistry.ETCHED_MUSIC_DISC.get() || !this.discStack.method_7960() && !this.labelStack.method_7960() ? 180 : 196, 158, 16);
        if (this.displayLabels) {
            for (int index = 0; index < 6; ++index) {
                int x = this.field_2776 + 46 + index * 14;
                int y = this.field_2800 + 65;
                this.field_22787.method_1531().method_22813(TEXTURE);
                int u = index == ((EtchingMenu)this.field_2797).getLabelIndex() ? 14 : (mouseX >= x && mouseY >= y && mouseX < x + 14 && mouseY < y + 14 ? 28 : 0);
                this.method_25302(poseStack, x, y, u, 212, 14, 14);
                this.renderLabel(poseStack, x, y, index);
            }
        }
    }

    private void renderLabel(class_4587 poseStack, int x, int y, int index) {
        int labelColor;
        if (this.labelStack.method_7960() || this.discStack.method_7960()) {
            return;
        }
        EtchedMusicDiscItem.LabelPattern pattern = EtchedMusicDiscItem.LabelPattern.values()[index];
        int n = labelColor = this.labelStack.method_7909() instanceof MusicLabelItem ? ((MusicLabelItem)this.labelStack.method_7909()).method_7800(this.labelStack) : 0xFFFFFF;
        if (pattern.isColorable()) {
            RenderSystem.color3f((float)((float)(labelColor >> 16 & 0xFF) / 255.0f), (float)((float)(labelColor >> 8 & 0xFF) / 255.0f), (float)((float)(labelColor & 0xFF) / 255.0f));
        }
        RenderSystem.alphaFunc((int)514, (float)1.0f);
        RenderSystem.enableAlphaTest();
        class_310.method_1551().method_1531().method_22813(pattern.getTexture());
        class_329.method_25290((class_4587)poseStack, (int)x, (int)y, (float)1.0f, (float)1.0f, (int)14, (int)14, (int)16, (int)16);
        RenderSystem.disableAlphaTest();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public boolean method_25402(double mouseX, double mouseY, int i) {
        if (this.displayLabels) {
            for (int index = 0; index < 6; ++index) {
                int x = this.field_2776 + 46 + index * 14;
                int y = this.field_2800 + 65;
                if (!(mouseX >= (double)x) || !(mouseY >= (double)y) || !(mouseX < (double)(x + 14)) || !(mouseY < (double)(y + 14)) || ((EtchingMenu)this.field_2797).getLabelIndex() == index) continue;
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
                this.field_22787.field_1761.method_2900(((EtchingMenu)this.field_2797).field_7763, index);
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, i);
    }

    public boolean method_25404(int i, int j, int k) {
        return this.url.method_25404(i, j, k) || this.url.method_25370() && this.url.method_1885() && i != 256 || super.method_25404(i, j, k);
    }

    public void setReason(String exception) {
        this.invalidReason = exception;
    }
}

