/*
 * Decompiled with CFR 0.152.
 */
package me.jaackson.etched.client.sound.download;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReentrantLock;
import me.jaackson.etched.client.sound.download.DownloadProgressListener;
import me.jaackson.etched.client.sound.download.SoundCloud;
import me.jaackson.etched.client.sound.source.AudioSource;
import me.jaackson.etched.client.sound.source.RawAudioSource;
import me.jaackson.etched.client.sound.source.StreamingAudioSource;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_3521;
import org.apache.commons.codec.digest.DigestUtils;
import org.jetbrains.annotations.Nullable;

public final class SoundCache {
    private static final Path SOUND_FOLDER = class_310.method_1551().field_1697.toPath().resolve("etched-sounds");
    private static final ReentrantLock LOCK = new ReentrantLock();
    private static final Map<String, CompletableFuture<AudioSource>> DOWNLOADING = new HashMap<String, CompletableFuture<AudioSource>>();
    private static Map<String, Path> files = new ConcurrentHashMap<String, Path>();

    private SoundCache() {
    }

    @Environment(value=EnvType.CLIENT)
    public static CompletableFuture<AudioSource> getAudioStream(String url, @Nullable DownloadProgressListener listener) {
        CompletableFuture<AudioSource> future;
        if (DOWNLOADING.containsKey(url) && !(future = DOWNLOADING.get(url)).isDone()) {
            return future;
        }
        try {
            LOCK.lock();
            boolean soundCloud = SoundCloud.isValidUrl(url);
            CompletionStage future2 = ((CompletableFuture)((CompletableFuture)(soundCloud ? CompletableFuture.supplyAsync(() -> {
                try {
                    return SoundCloud.resolveUrl(url, listener, class_310.method_1551().method_1487()).toArray(new URL[0]);
                }
                catch (Exception e) {
                    throw new CompletionException("Failed to connect to SoundCloud API", e);
                }
            }, (Executor)class_3521.field_15664) : CompletableFuture.completedFuture(new URL[]{new URL(url)})).thenApplyAsync(urls -> {
                try {
                    if (((URL[])urls).length == 0) {
                        throw new IOException("No audio data was found at the source!");
                    }
                    if (((URL[])urls).length == 1) {
                        return new RawAudioSource(class_310.method_1551().method_1487(), DigestUtils.sha1Hex((String)url), urls[0], soundCloud);
                    }
                    return new StreamingAudioSource(class_310.method_1551().method_1487(), DigestUtils.sha1Hex((String)url), (URL[])urls, listener, soundCloud);
                }
                catch (Exception e) {
                    throw new CompletionException(e);
                }
            }, (Executor)class_3521.field_15664)).handle((source, e) -> {
                if (e != null) {
                    if (listener != null) {
                        listener.onFail();
                    }
                    throw new CompletionException((Throwable)e);
                }
                return source;
            })).thenApplyAsync(source -> {
                DOWNLOADING.remove(url);
                return source;
            }, (Executor)class_310.method_1551());
            DOWNLOADING.put(url, (CompletableFuture<AudioSource>)future2);
            CompletionStage completionStage = future2;
            return completionStage;
        }
        catch (Exception e2) {
            if (listener != null) {
                listener.onFail();
            }
            throw new CompletionException("Failed to load audio into cache", e2);
        }
        finally {
            LOCK.unlock();
        }
    }

    public static synchronized Path resolveFilePath(String hash, boolean temporary) throws IOException {
        if (temporary) {
            return SoundCache.getTemporaryFile(hash);
        }
        if (!Files.exists(SOUND_FOLDER, new LinkOption[0])) {
            Files.createDirectories(SOUND_FOLDER, new FileAttribute[0]);
        }
        return SOUND_FOLDER.resolve(hash);
    }

    private static synchronized Path getTemporaryFile(String hash) throws IOException {
        if (files == null) {
            throw new IllegalStateException("Shutdown in progress");
        }
        if (!files.containsKey(hash)) {
            files.put(hash, Files.createTempFile(hash, null, new FileAttribute[0]));
        }
        return files.get(hash);
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            Class<SoundCache> clazz = SoundCache.class;
            synchronized (SoundCache.class) {
                Map<String, Path> theFiles = files;
                files = null;
                // ** MonitorExit[var1] (shouldn't be in output)
                ArrayList<Path> toBeDeleted = new ArrayList<Path>(theFiles.values());
                theFiles.clear();
                Collections.reverse(toBeDeleted);
                for (Path filename : toBeDeleted) {
                    try {
                        Files.deleteIfExists(filename);
                    }
                    catch (Exception exception) {}
                }
                return;
            }
        }));
    }
}

