/*
 * Decompiled with CFR 0.152.
 */
package me.jaackson.etched.client.sound.download;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.jaackson.etched.client.sound.download.DownloadProgressListener;
import me.jaackson.etched.client.sound.download.SoundCloudIdTracker;
import me.jaackson.etched.client.sound.format.M3uParser;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_3518;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class SoundCloud {
    static final Logger LOGGER = LogManager.getLogger();

    static Map<String, String> getDownloadHeaders() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("X-Minecraft-Version", class_155.method_16673().getName());
        map.put("X-Minecraft-Version-ID", class_155.method_16673().getId());
        map.put("User-Agent", "Minecraft Java/" + class_155.method_16673().getName());
        return map;
    }

    private static InputStream get(String url, @Nullable DownloadProgressListener progressListener, Proxy proxy, int attempt, boolean requiresId) throws IOException {
        HttpURLConnection httpURLConnection = null;
        if (progressListener != null) {
            progressListener.progressStartRequest((class_2561)new class_2588("sound_cloud.requesting"));
        }
        try {
            URL uRL = requiresId ? new URL(url + SoundCloudIdTracker.fetch(proxy)) : new URL(url);
            httpURLConnection = (HttpURLConnection)uRL.openConnection(proxy);
            httpURLConnection.setInstanceFollowRedirects(true);
            float f = 0.0f;
            Map<String, String> map = SoundCloud.getDownloadHeaders();
            float g = map.entrySet().size();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                httpURLConnection.setRequestProperty(entry.getKey(), entry.getValue());
                if (progressListener == null) continue;
                progressListener.progressStagePercentage((int)((f += 1.0f) / g * 100.0f));
            }
            int response = httpURLConnection.getResponseCode();
            if (attempt == 0 && (response == 401 || response == 403)) {
                LOGGER.info("Attempting to authenticate");
                SoundCloudIdTracker.invalidate();
                return SoundCloud.get(url, progressListener, proxy, 1, requiresId);
            }
            if (response != 200) {
                throw new IOException(response + " " + httpURLConnection.getResponseMessage());
            }
            return httpURLConnection.getInputStream();
        }
        catch (Throwable e) {
            if (httpURLConnection != null) {
                try {
                    LOGGER.error(IOUtils.toString((InputStream)httpURLConnection.getErrorStream(), (Charset)StandardCharsets.UTF_8));
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            throw new IOException(e);
        }
    }

    private static <T> T resolve(String url, @Nullable DownloadProgressListener progressListener, Proxy proxy, Request<T> function) throws IOException, JsonParseException {
        try (InputStreamReader reader = new InputStreamReader(SoundCloud.get("https://api-v2.soundcloud.com/resolve?url=" + URLEncoder.encode(url, StandardCharsets.UTF_8.toString()) + "&client_id=", progressListener, proxy, 0, true));){
            JsonObject json = new JsonParser().parse((Reader)reader).getAsJsonObject();
            if (!"track".equals(class_3518.method_15265((JsonObject)json, (String)"kind"))) {
                throw new IOException("URL is not a track");
            }
            if (!class_3518.method_15270((JsonObject)json, (String)"streamable")) {
                throw new IOException("URL is not streamable");
            }
            T t = function.process(json);
            return t;
        }
    }

    public static List<URL> resolveUrl(String trackUrl, @Nullable DownloadProgressListener progressListener, Proxy proxy) throws IOException {
        return SoundCloud.resolve(trackUrl, progressListener, proxy, json -> {
            JsonArray media = class_3518.method_15261((JsonObject)class_3518.method_15296((JsonObject)json, (String)"media"), (String)"transcodings");
            int progressiveIndex = -1;
            for (int i = 0; i < media.size(); ++i) {
                JsonObject transcodingJson = class_3518.method_15295((JsonElement)media.get(i), (String)("transcodings[" + i + "]"));
                JsonObject format = transcodingJson.getAsJsonObject("format");
                String protocol = format.get("protocol").getAsString();
                if ("progressive".equals(protocol)) {
                    progressiveIndex = i;
                }
                if (!"hls".equals(protocol)) continue;
                try (InputStreamReader r = new InputStreamReader(SoundCloud.get(class_3518.method_15265((JsonObject)transcodingJson, (String)"url") + "?client_id=", progressListener, proxy, 0, true));){
                    List<URL> list;
                    try (InputStreamReader reader = new InputStreamReader(SoundCloud.get(class_3518.method_15265((JsonObject)new JsonParser().parse((Reader)r).getAsJsonObject(), (String)"url"), progressListener, proxy, 0, false));){
                        list = M3uParser.parse(reader);
                    }
                    return list;
                }
            }
            if (progressiveIndex == -1) {
                throw new IOException("Could not find an audio source");
            }
            try (InputStreamReader reader = new InputStreamReader(SoundCloud.get(class_3518.method_15265((JsonObject)class_3518.method_15295((JsonElement)media.get(progressiveIndex), (String)("transcodings[" + progressiveIndex + "]")), (String)"url") + "?client_id=", progressListener, proxy, 0, true));){
                List<URL> list = Collections.singletonList(new URL(class_3518.method_15265((JsonObject)new JsonParser().parse((Reader)reader).getAsJsonObject(), (String)"url")));
                return list;
            }
        });
    }

    public static Pair<String, String> resolveTrack(String trackUrl, @Nullable DownloadProgressListener progressListener, Proxy proxy) throws IOException, JsonParseException {
        return SoundCloud.resolve(trackUrl, progressListener, proxy, json -> {
            JsonObject user = class_3518.method_15296((JsonObject)json, (String)"user");
            String artist = class_3518.method_15265((JsonObject)user, (String)"username");
            String title = class_3518.method_15265((JsonObject)json, (String)"title");
            return Pair.of((Object)artist, (Object)title);
        });
    }

    public static boolean isValidUrl(String url) {
        try {
            String host = new URI(url).getHost();
            return "soundcloud.com".equals(host);
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    @FunctionalInterface
    private static interface Request<T> {
        public T process(JsonObject var1) throws IOException, JsonParseException;
    }
}

