/*
 * Decompiled with CFR 0.152.
 */
package me.jaackson.etched.client.sound.format;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class M3uParser {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String EXTENDED_HEADER = "#EXTM3U";
    private static final Pattern INFO_PATTERN = Pattern.compile("#EXTINF:(?<seconds>[-]?\\d+).*,(?<title>.+)");

    public static List<URL> parse(InputStreamReader reader) throws IOException {
        Iterator filtered = IOUtils.readLines((Reader)reader).stream().filter(line -> !line.isEmpty()).map(String::trim).iterator();
        if (!filtered.hasNext()) {
            return Collections.emptyList();
        }
        LinkedList<URL> entries = new LinkedList<URL>();
        while (filtered.hasNext()) {
            String currentLine = (String)filtered.next();
            if (currentLine.equals(EXTENDED_HEADER) || INFO_PATTERN.matcher(currentLine).matches()) continue;
            while (currentLine.startsWith("#")) {
                if (!filtered.hasNext()) {
                    return entries;
                }
                currentLine = (String)filtered.next();
            }
            try {
                entries.add(new URL(currentLine));
            }
            catch (Exception e) {
                LOGGER.warn("Could not parse as location: " + currentLine, (Throwable)e);
            }
        }
        return entries;
    }
}

