/*
 * Decompiled with CFR 0.152.
 */
package me.jaackson.etched.common.item;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Pattern;
import me.jaackson.etched.EtchedRegistry;
import me.jaackson.etched.bridge.NetworkBridge;
import me.jaackson.etched.client.sound.download.SoundCloud;
import me.jaackson.etched.common.network.ClientboundPlayMusicPacket;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1813;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2387;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3468;
import net.minecraft.class_5251;
import org.jetbrains.annotations.Nullable;

public class EtchedMusicDiscItem
extends class_1792 {
    private static final Pattern RESOURCE_LOCATION_PATTERN = Pattern.compile("[a-z0-9_.-]+");

    public EtchedMusicDiscItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public static Optional<MusicInfo> getMusic(class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        if (nbt == null || !nbt.method_10573("Music", 10)) {
            return Optional.empty();
        }
        MusicInfo music = new MusicInfo();
        music.load(nbt.method_10562("Music"));
        return music.getUrl() != null && EtchedMusicDiscItem.isValidURL(music.getUrl()) ? Optional.of(music) : Optional.empty();
    }

    public static LabelPattern getPattern(class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        if (nbt == null || !nbt.method_10573("Pattern", 99)) {
            return LabelPattern.FLAT;
        }
        byte id = nbt.method_10571("Pattern");
        return id < 0 || id >= LabelPattern.values().length ? LabelPattern.FLAT : LabelPattern.values()[id];
    }

    public static int getPrimaryColor(class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        if (nbt == null || !nbt.method_10573("PrimaryColor", 99)) {
            return 0x515151;
        }
        return nbt.method_10550("PrimaryColor");
    }

    public static int getSecondaryColor(class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        if (nbt == null || !nbt.method_10573("SecondaryColor", 99)) {
            return 0xFFFFFF;
        }
        return nbt.method_10550("SecondaryColor");
    }

    public static void setMusic(class_1799 stack, @Nullable MusicInfo musicInfo) {
        if (musicInfo == null) {
            if (stack.method_7969() != null) {
                stack.method_7969().method_10551("Music");
            }
        } else {
            stack.method_7948().method_10566("Music", (class_2520)musicInfo.save(new class_2487()));
        }
    }

    public static void setPattern(class_1799 stack, @Nullable LabelPattern pattern) {
        if (pattern == null) {
            if (stack.method_7969() != null) {
                stack.method_7969().method_10551("Pattern");
            }
        } else {
            stack.method_7948().method_10567("Pattern", (byte)pattern.ordinal());
        }
    }

    public static void setColor(class_1799 stack, int primaryColor, int secondaryColor) {
        stack.method_7948().method_10569("PrimaryColor", primaryColor);
        stack.method_7948().method_10569("SecondaryColor", secondaryColor);
    }

    public static boolean isValidURL(String url) {
        if (EtchedMusicDiscItem.isLocalSound(url)) {
            return true;
        }
        try {
            String scheme = new URI(url).getScheme();
            return "http".equals(scheme) || "https".equals(scheme);
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    public static boolean isLocalSound(String url) {
        String[] parts = url.split(":");
        if (parts.length > 2) {
            return false;
        }
        for (String part : parts) {
            if (RESOURCE_LOCATION_PATTERN.matcher(part).matches()) continue;
            return false;
        }
        return true;
    }

    public static boolean isPlayableRecord(class_1799 stack) {
        if (stack.method_7909() instanceof class_1813) {
            return true;
        }
        if (stack.method_7909() == EtchedRegistry.ETCHED_MUSIC_DISC.get()) {
            return EtchedMusicDiscItem.getMusic(stack).isPresent();
        }
        return false;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 level, List<class_2561> list, class_1836 tooltipFlag) {
        EtchedMusicDiscItem.getMusic(stack).ifPresent(music -> {
            list.add((class_2561)music.getDisplayName().method_27661().method_27692(class_124.field_1080));
            if (SoundCloud.isValidUrl(music.getUrl())) {
                list.add((class_2561)new class_2588(this.method_7866(stack) + ".sound_cloud").method_27694(style -> style.method_27703(class_5251.method_27717((int)0xFF5500))));
            }
        });
    }

    public class_1269 method_7884(class_1838 ctx) {
        class_2338 pos;
        class_1937 level = ctx.method_8045();
        class_2680 state = level.method_8320(pos = ctx.method_8037());
        if (!state.method_27852(class_2246.field_10223) || ((Boolean)state.method_11654((class_2769)class_2387.field_11180)).booleanValue()) {
            return class_1269.field_5811;
        }
        class_1799 stack = ctx.method_8041();
        Optional<MusicInfo> optional = EtchedMusicDiscItem.getMusic(stack);
        if (!optional.isPresent()) {
            return class_1269.field_5811;
        }
        if (!level.method_8608()) {
            MusicInfo music = optional.get();
            ((class_2387)class_2246.field_10223).method_10276((class_1936)level, pos, state, stack);
            NetworkBridge.sendToNear((class_3218)level, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 64.0, new ClientboundPlayMusicPacket(music.getDisplayName(), music.getUrl(), pos));
            stack.method_7934(1);
            class_1657 player = ctx.method_8036();
            if (player != null) {
                player.method_7281(class_3468.field_15375);
            }
        }
        return class_1269.method_29236((boolean)level.method_8608());
    }

    public static class MusicInfo {
        private String url = null;
        private String title = "Custom Music";
        private String author = "Unknown";

        private class_2487 save(class_2487 nbt) {
            if (this.url != null) {
                nbt.method_10582("Url", this.url);
            }
            if (this.title != null) {
                nbt.method_10582("Title", this.title);
            }
            if (this.author != null) {
                nbt.method_10582("Author", this.author);
            }
            return nbt;
        }

        private void load(class_2487 nbt) {
            this.url = nbt.method_10573("Url", 8) ? nbt.method_10558("Url") : null;
            this.title = nbt.method_10573("Title", 8) ? nbt.method_10558("Title") : "Custom Music";
            this.author = nbt.method_10573("Author", 8) ? nbt.method_10558("Author") : "Unknown";
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getAuthor() {
            return this.author;
        }

        public void setAuthor(String author) {
            this.author = author;
        }

        public class_2561 getDisplayName() {
            return new class_2585(this.author + " - " + this.title);
        }
    }

    public static enum LabelPattern {
        FLAT,
        CROSS,
        EYE,
        PARALLEL,
        STAR,
        GOLD;

        private final class_2960 texture = new class_2960("etched", "textures/item/" + this.name().toLowerCase(Locale.ROOT) + "_etched_music_disc_label.png");

        @Environment(value=EnvType.CLIENT)
        public class_2960 getTexture() {
            return this.texture;
        }

        @Environment(value=EnvType.CLIENT)
        public boolean isColorable() {
            return this != GOLD;
        }
    }
}

