/*
 * Decompiled with CFR 0.152.
 */
package me.jaackson.etched.common.menu;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import me.jaackson.etched.EtchedRegistry;
import me.jaackson.etched.bridge.NetworkBridge;
import me.jaackson.etched.client.sound.download.SoundCloud;
import me.jaackson.etched.common.item.BlankMusicDiscItem;
import me.jaackson.etched.common.item.EtchedMusicDiscItem;
import me.jaackson.etched.common.item.MusicLabelItem;
import me.jaackson.etched.common.network.ClientboundInvalidEtchUrlPacket;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_155;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3521;
import net.minecraft.class_3914;
import net.minecraft.class_3915;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EtchingMenu
extends class_1703 {
    public static final class_2960 EMPTY_SLOT_MUSIC_DISC = new class_2960("etched", "item/empty_etching_table_slot_music_disc");
    public static final class_2960 EMPTY_SLOT_MUSIC_LABEL = new class_2960("etched", "item/empty_etching_table_slot_music_label");
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Set<String> VALID_FORMATS;
    private final class_3914 access;
    private final class_3915 labelIndex;
    private final class_1735 discSlot;
    private final class_1735 labelSlot;
    private final class_1735 resultSlot;
    private final class_1263 input;
    private final class_1263 result;
    private final class_1657 player;
    private String url;
    private String cachedAuthor;
    private String cachedTitle;
    private int urlId;
    private long lastSoundTime;

    public EtchingMenu(int id, class_1661 inventory) {
        this(id, inventory, class_3914.field_17304);
    }

    public EtchingMenu(int id, class_1661 inventory, final class_3914 containerLevelAccess) {
        super(EtchedRegistry.ETCHING_MENU.get(), id);
        this.player = inventory.field_7546;
        this.labelIndex = class_3915.method_17403();
        this.input = new class_1277(2){

            public void method_5431() {
                super.method_5431();
                EtchingMenu.this.method_7609((class_1263)this);
            }
        };
        this.result = new class_1277(1){

            public void method_5431() {
                super.method_5431();
            }
        };
        this.access = containerLevelAccess;
        this.discSlot = this.method_7621(new class_1735(this.input, 0, 44, 43){

            public boolean method_7680(class_1799 stack) {
                return stack.method_7909() == EtchedRegistry.BLANK_MUSIC_DISC.get() || stack.method_7909() == EtchedRegistry.ETCHED_MUSIC_DISC.get();
            }

            @Environment(value=EnvType.CLIENT)
            public Pair<class_2960, class_2960> method_7679() {
                return Pair.of((Object)class_1723.field_21668, (Object)EMPTY_SLOT_MUSIC_DISC);
            }
        });
        this.labelSlot = this.method_7621(new class_1735(this.input, 1, 62, 43){

            public boolean method_7680(class_1799 stack) {
                return stack.method_7909() instanceof MusicLabelItem;
            }

            @Environment(value=EnvType.CLIENT)
            public Pair<class_2960, class_2960> method_7679() {
                return Pair.of((Object)class_1723.field_21668, (Object)EMPTY_SLOT_MUSIC_LABEL);
            }
        });
        this.resultSlot = this.method_7621(new class_1735(this.result, 0, 116, 43){

            public boolean method_7680(class_1799 stack) {
                return false;
            }

            public class_1799 method_7667(class_1657 player, class_1799 stack) {
                EtchingMenu.this.discSlot.method_7671(1);
                EtchingMenu.this.labelSlot.method_7671(1);
                if (!EtchingMenu.this.discSlot.method_7681() || !EtchingMenu.this.labelSlot.method_7681()) {
                    EtchingMenu.this.labelIndex.method_17404(0);
                }
                EtchingMenu.this.setupResultSlot();
                EtchingMenu.this.method_7623();
                containerLevelAccess.method_17393((level, pos) -> {
                    long l = level.method_8510();
                    if (EtchingMenu.this.lastSoundTime != l) {
                        level.method_8396(null, pos, EtchedRegistry.UI_ETCHER_TAKE_RESULT.get(), class_3419.field_15245, 1.0f, 1.0f);
                        EtchingMenu.this.lastSoundTime = l;
                    }
                });
                return super.method_7667(player, stack);
            }
        });
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.method_7621(new class_1735((class_1263)inventory, x + y * 9 + 9, 8 + x * 18, 98 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.method_7621(new class_1735((class_1263)inventory, x, 8 + x * 18, 156));
        }
        this.method_17362(this.labelIndex);
    }

    private static Map<String, String> getDownloadHeaders() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("X-Minecraft-Version", class_155.method_16673().getName());
        map.put("X-Minecraft-Version-ID", class_155.method_16673().getId());
        map.put("User-Agent", "Minecraft Java/" + class_155.method_16673().getName());
        return map;
    }

    private static void checkStatus(String url) throws IOException {
        HttpURLConnection httpURLConnection = null;
        try {
            URL uRL = new URL(url);
            httpURLConnection = (HttpURLConnection)uRL.openConnection(Proxy.NO_PROXY);
            httpURLConnection.setInstanceFollowRedirects(true);
            Map<String, String> map = EtchingMenu.getDownloadHeaders();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                httpURLConnection.setRequestProperty(entry.getKey(), entry.getValue());
            }
            if (httpURLConnection.getResponseCode() != 200) {
                IOUtils.closeQuietly((InputStream)httpURLConnection.getInputStream());
                throw new IOException(httpURLConnection.getResponseCode() + " " + httpURLConnection.getResponseMessage());
            }
            String contentType = httpURLConnection.getContentType();
            if (!VALID_FORMATS.contains(contentType)) {
                throw new IOException("Unsupported Content-Type: " + contentType);
            }
        }
        catch (Throwable e) {
            if (httpURLConnection != null) {
                try {
                    LOGGER.error(IOUtils.toString((InputStream)httpURLConnection.getErrorStream(), (Charset)StandardCharsets.UTF_8));
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            throw new IOException(e);
        }
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.access.method_17393((level, pos) -> this.method_7607(player, (class_1937)level, this.input));
    }

    public boolean method_7597(class_1657 player) {
        return EtchingMenu.method_17695((class_3914)this.access, (class_1657)player, (class_2248)EtchedRegistry.ETCHING_TABLE.get());
    }

    public boolean method_7604(class_1657 player, int index) {
        if (index >= 0 && index < EtchedMusicDiscItem.LabelPattern.values().length) {
            this.labelIndex.method_17404(index);
            this.setupResultSlot();
            return true;
        }
        return false;
    }

    public class_1799 method_7601(class_1657 player, int index) {
        class_1799 itemStack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (slot != null && slot.method_7681()) {
            class_1799 itemStack2 = slot.method_7677();
            itemStack = itemStack2.method_7972();
            if (index < 3 ? !this.method_7616(itemStack2, 3, this.field_7761.size(), true) : !this.method_7616(itemStack2, 0, 3, false)) {
                return class_1799.field_8037;
            }
            if (itemStack2.method_7960()) {
                slot.method_7673(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
            if (itemStack2.method_7947() == itemStack.method_7947()) {
                return class_1799.field_8037;
            }
            slot.method_7667(player, itemStack2);
        }
        return itemStack;
    }

    public void method_7609(class_1263 container) {
        class_1799 discStack = this.discSlot.method_7677();
        class_1799 labelStack = this.labelSlot.method_7677();
        class_1799 resultStack = this.resultSlot.method_7677();
        if (resultStack.method_7960() && labelStack.method_7960()) {
            if (!discStack.method_7960() && discStack.method_7909() == EtchedRegistry.ETCHED_MUSIC_DISC.get()) {
                this.labelIndex.method_17404(EtchedMusicDiscItem.getPattern(discStack).ordinal());
            } else {
                this.labelIndex.method_17404(0);
            }
        }
        this.setupResultSlot();
        this.method_7623();
    }

    private void setupResultSlot() {
        if (!this.player.field_6002.method_8608()) {
            NetworkBridge.sendToPlayer((class_3222)this.player, new ClientboundInvalidEtchUrlPacket(""));
        }
        this.resultSlot.method_7673(class_1799.field_8037);
        if (this.labelIndex.method_17407() >= 0 && this.labelIndex.method_17407() < EtchedMusicDiscItem.LabelPattern.values().length && this.url != null && EtchedMusicDiscItem.isValidURL(this.url)) {
            class_1799 discStack = this.discSlot.method_7677();
            class_1799 labelStack = this.labelSlot.method_7677();
            if (discStack.method_7909() == EtchedRegistry.ETCHED_MUSIC_DISC.get() || !discStack.method_7960() && !labelStack.method_7960()) {
                int currentId = this.urlId;
                ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
                    class_1799 resultStack = new class_1799((class_1935)EtchedRegistry.ETCHED_MUSIC_DISC.get());
                    resultStack.method_7939(1);
                    int discColor = 0x515151;
                    int labelColor = 0xFFFFFF;
                    String author = this.player.method_5476().getString();
                    String title = null;
                    if (discStack.method_7909() == EtchedRegistry.ETCHED_MUSIC_DISC.get()) {
                        discColor = EtchedMusicDiscItem.getPrimaryColor(discStack);
                        labelColor = EtchedMusicDiscItem.getSecondaryColor(discStack);
                        author = EtchedMusicDiscItem.getMusic(discStack).map(EtchedMusicDiscItem.MusicInfo::getAuthor).orElse(null);
                        title = EtchedMusicDiscItem.getMusic(discStack).map(EtchedMusicDiscItem.MusicInfo::getTitle).orElse(null);
                    }
                    if (!labelStack.method_7960() && labelStack.method_7938()) {
                        title = labelStack.method_7964().getString();
                    }
                    if (SoundCloud.isValidUrl(this.url)) {
                        if (this.cachedAuthor == null || this.cachedTitle == null) {
                            try {
                                Pair<String, String> track = SoundCloud.resolveTrack(this.url, null, Proxy.NO_PROXY);
                                this.cachedAuthor = (String)track.getFirst();
                                this.cachedTitle = (String)track.getSecond();
                            }
                            catch (Exception e) {
                                this.cachedAuthor = null;
                                this.cachedTitle = null;
                                if (!this.player.field_6002.method_8608()) {
                                    NetworkBridge.sendToPlayer((class_3222)this.player, new ClientboundInvalidEtchUrlPacket(e.getMessage()));
                                }
                                throw new CompletionException("Failed to connect to SoundCloud API", e);
                            }
                        }
                        author = this.cachedAuthor;
                        title = this.cachedTitle;
                    } else if (!EtchedMusicDiscItem.isLocalSound(this.url)) {
                        try {
                            EtchingMenu.checkStatus(this.url);
                        }
                        catch (UnknownHostException e) {
                            if (!this.player.field_6002.method_8608()) {
                                NetworkBridge.sendToPlayer((class_3222)this.player, new ClientboundInvalidEtchUrlPacket("Unknown host: " + this.url));
                            }
                            throw new CompletionException("Invalid URL", e);
                        }
                        catch (Exception e) {
                            if (!this.player.field_6002.method_8608()) {
                                NetworkBridge.sendToPlayer((class_3222)this.player, new ClientboundInvalidEtchUrlPacket(e.getLocalizedMessage()));
                            }
                            throw new CompletionException("Invalid URL", e);
                        }
                    }
                    if (discStack.method_7909() instanceof BlankMusicDiscItem) {
                        discColor = ((BlankMusicDiscItem)discStack.method_7909()).method_7800(discStack);
                    }
                    if (labelStack.method_7909() instanceof MusicLabelItem) {
                        labelColor = ((MusicLabelItem)labelStack.method_7909()).method_7800(labelStack);
                    }
                    EtchedMusicDiscItem.MusicInfo info = new EtchedMusicDiscItem.MusicInfo();
                    info.setAuthor(author != null ? author : this.player.method_5476().getString());
                    if (title != null) {
                        info.setTitle(title);
                    }
                    info.setUrl(EtchedMusicDiscItem.isLocalSound(this.url) ? new class_2960(this.url).toString() : this.url);
                    EtchedMusicDiscItem.setMusic(resultStack, info);
                    EtchedMusicDiscItem.setColor(resultStack, discColor, labelColor);
                    EtchedMusicDiscItem.setPattern(resultStack, EtchedMusicDiscItem.LabelPattern.values()[this.labelIndex.method_17407()]);
                    return resultStack;
                }, (Executor)class_3521.field_15664).thenAcceptAsync(resultStack -> {
                    if (this.urlId == currentId && !class_1799.method_7973((class_1799)resultStack, (class_1799)this.resultSlot.method_7677()) && !class_1799.method_7973((class_1799)resultStack, (class_1799)this.discSlot.method_7677())) {
                        this.resultSlot.method_7673(resultStack);
                    }
                })).exceptionally(e -> {
                    e.printStackTrace();
                    return null;
                });
            }
        }
    }

    public int getLabelIndex() {
        return this.labelIndex.method_17407();
    }

    public void setUrl(String string) {
        if (!Objects.equals(this.url, string)) {
            this.url = string;
            ++this.urlId;
            this.urlId %= 1000;
            this.cachedAuthor = null;
            this.cachedTitle = null;
            this.setupResultSlot();
        }
    }

    static {
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        builder.add((Object[])new String[]{"audio/wav", "audio/opus", "application/ogg", "audio/ogg", "audio/mpeg", "application/octet-stream"});
        VALID_FORMATS = builder.build();
    }
}

