/*
 * Decompiled with CFR 0.152.
 */
package me.jaackson.etched.common.network.handler;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.DoubleSupplier;
import me.jaackson.etched.EtchedRegistry;
import me.jaackson.etched.client.screen.EtchingScreen;
import me.jaackson.etched.client.sound.JukeboxMinecartSoundInstance;
import me.jaackson.etched.client.sound.OnlineRecordSoundInstance;
import me.jaackson.etched.client.sound.StopListeningSound;
import me.jaackson.etched.client.sound.download.DownloadProgressListener;
import me.jaackson.etched.common.block.AlbumJukeboxBlock;
import me.jaackson.etched.common.blockentity.AlbumJukeboxBlockEntity;
import me.jaackson.etched.common.entity.MinecartJukebox;
import me.jaackson.etched.common.item.EtchedMusicDiscItem;
import me.jaackson.etched.common.network.ClientboundAddMinecartJukeboxPacket;
import me.jaackson.etched.common.network.ClientboundInvalidEtchUrlPacket;
import me.jaackson.etched.common.network.ClientboundPlayMinecartJukeboxMusicPacket;
import me.jaackson.etched.common.network.ClientboundPlayMusicPacket;
import me.jaackson.etched.mixin.client.GuiAccessor;
import me.jaackson.etched.mixin.client.LevelRendererAccessor;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1108;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1688;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1813;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2477;
import net.minecraft.class_2554;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EtchedClientPlayHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Int2ObjectArrayMap<class_1113> ENTITY_PLAYING_SOUNDS = new Int2ObjectArrayMap();

    public static void handlePlayMusicPacket(ClientboundPlayMusicPacket pkt) {
        class_2338 pos;
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        class_1144 soundManager = class_310.method_1551().method_1483();
        Map<class_2338, class_1113> playingRecords = ((LevelRendererAccessor)class_310.method_1551().field_1769).getPlayingRecords();
        class_1113 soundInstance = playingRecords.get(pos = pkt.getPos());
        if (soundInstance != null) {
            soundManager.method_4870(soundInstance);
            playingRecords.remove(pos);
        }
        if (!EtchedMusicDiscItem.isValidURL(pkt.getUrl())) {
            LOGGER.error("Server sent invalid music URL: " + pkt.getUrl());
            return;
        }
        EtchedClientPlayHandler.playRecord(pos, new StopListeningSound(EtchedClientPlayHandler.getEtchedRecord(pkt.getUrl(), pkt.getTitle(), level, pos), () -> class_310.method_1551().method_18858(() -> {
            if (level.method_8320(pos).method_27852(class_2246.field_10223)) {
                for (class_1309 livingEntity : level.method_18467(class_1309.class, new class_238(pos).method_1014(3.0))) {
                    livingEntity.method_6006(pos, false);
                }
            }
        })));
    }

    public static void handleAddMinecartJukeboxPacket(ClientboundAddMinecartJukeboxPacket pkt) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        MinecartJukebox entity = new MinecartJukebox((class_1937)level, pkt.getX(), pkt.getY(), pkt.getZ());
        int i = pkt.getId();
        entity.method_18003(pkt.getX(), pkt.getY(), pkt.getZ());
        entity.method_24203(pkt.getX(), pkt.getY(), pkt.getZ());
        entity.field_5965 = (float)(pkt.getxRot() * 360) / 256.0f;
        entity.field_6031 = (float)(pkt.getyRot() * 360) / 256.0f;
        entity.method_5838(i);
        entity.method_5826(pkt.getUUID());
        level.method_2942(i, (class_1297)entity);
        class_310.method_1551().method_1483().method_4873((class_1113)new class_1108((class_1688)entity));
    }

    public static void handlePlayMinecartJukeboxPacket(ClientboundPlayMinecartJukeboxMusicPacket pkt) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        int entityId = pkt.getEntityId();
        class_1144 soundManager = class_310.method_1551().method_1483();
        class_1113 soundInstance = (class_1113)ENTITY_PLAYING_SOUNDS.get(entityId);
        if (soundInstance != null) {
            if (soundInstance instanceof StopListeningSound) {
                ((StopListeningSound)soundInstance).stopListening();
            }
            if (pkt.getAction() == ClientboundPlayMinecartJukeboxMusicPacket.Action.RESTART && soundManager.method_4877(soundInstance)) {
                return;
            }
            soundManager.method_4870(soundInstance);
            ENTITY_PLAYING_SOUNDS.remove(entityId);
        }
        if (pkt.getAction() == ClientboundPlayMinecartJukeboxMusicPacket.Action.STOP) {
            return;
        }
        class_1297 entity = level.method_8469(pkt.getEntityId());
        if (!(entity instanceof MinecartJukebox)) {
            return;
        }
        if (pkt.getUrl() != null) {
            if (!EtchedMusicDiscItem.isValidURL(pkt.getUrl())) {
                LOGGER.error("Server sent invalid music URL: " + pkt.getUrl());
                return;
            }
            class_1113 sound = EtchedClientPlayHandler.getEtchedRecord(pkt.getUrl(), pkt.getTitle(), (MinecartJukebox)entity);
            ENTITY_PLAYING_SOUNDS.put(entityId, (Object)sound);
            soundManager.method_4873(sound);
        } else {
            class_1792 record = (class_1792)class_2378.field_11142.method_10200(pkt.getRecordId());
            if (!(record instanceof class_1813)) {
                LOGGER.error("Server sent invalid music disc: " + record);
                return;
            }
            if (EtchedClientPlayHandler.canShowMessage(entity.method_23317(), entity.method_23318(), entity.method_23321())) {
                class_310.method_1551().field_1705.method_1732((class_2561)((class_1813)record).method_8011());
            }
            JukeboxMinecartSoundInstance sound = new JukeboxMinecartSoundInstance(((class_1813)record).method_8009(), (MinecartJukebox)entity);
            ENTITY_PLAYING_SOUNDS.put(entityId, (Object)sound);
            soundManager.method_4873((class_1113)sound);
        }
    }

    public static void handleSetInvalidEtch(ClientboundInvalidEtchUrlPacket pkt) {
        if (class_310.method_1551().field_1755 instanceof EtchingScreen) {
            EtchingScreen screen = (EtchingScreen)class_310.method_1551().field_1755;
            screen.setReason(pkt.getException());
        }
    }

    private static boolean canShowMessage(double x, double y, double z) {
        class_746 player = class_310.method_1551().field_1724;
        return player == null || player.method_5649(x, y, z) <= 4096.0;
    }

    private static class_1113 getEtchedRecord(String url, final class_2561 title, final MinecartJukebox jukebox) {
        return new OnlineRecordSoundInstance(url, jukebox, new MusicDownloadListener(title, () -> ((MinecartJukebox)jukebox).method_23317(), () -> ((MinecartJukebox)jukebox).method_23318(), () -> ((MinecartJukebox)jukebox).method_23321()){

            @Override
            public void onSuccess() {
                if (!jukebox.method_5805() || !ENTITY_PLAYING_SOUNDS.containsKey(jukebox.method_5628())) {
                    this.clearComponent();
                } else if (EtchedClientPlayHandler.canShowMessage(jukebox.method_23317(), jukebox.method_23318(), jukebox.method_23321())) {
                    class_310.method_1551().field_1705.method_1732(title);
                }
            }
        });
    }

    private static class_1113 getEtchedRecord(String url, final class_2561 title, final class_638 level, final class_2338 pos) {
        final Map<class_2338, class_1113> playingRecords = ((LevelRendererAccessor)class_310.method_1551().field_1769).getPlayingRecords();
        return new OnlineRecordSoundInstance(url, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, (DownloadProgressListener)new MusicDownloadListener(title, () -> (double)pos.method_10263() + 0.5, () -> (double)pos.method_10264() + 0.5, () -> (double)pos.method_10260() + 0.5){

            @Override
            public void onSuccess() {
                if (!playingRecords.containsKey(pos)) {
                    this.clearComponent();
                } else {
                    if (EtchedClientPlayHandler.canShowMessage((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5)) {
                        class_310.method_1551().field_1705.method_1732(title);
                    }
                    if (level.method_8320(pos).method_27852(class_2246.field_10223)) {
                        for (class_1309 livingEntity : level.method_18467(class_1309.class, new class_238(pos).method_1014(3.0))) {
                            livingEntity.method_6006(pos, true);
                        }
                    }
                }
            }
        });
    }

    private static void playRecord(class_2338 pos, class_1113 sound) {
        class_1144 soundManager = class_310.method_1551().method_1483();
        Map<class_2338, class_1113> playingRecords = ((LevelRendererAccessor)class_310.method_1551().field_1769).getPlayingRecords();
        playingRecords.put(pos, sound);
        soundManager.method_4873(sound);
    }

    private static void playNextRecord(class_638 level, class_2338 pos) {
        class_2586 blockEntity = level.method_8321(pos);
        if (!(blockEntity instanceof AlbumJukeboxBlockEntity)) {
            return;
        }
        AlbumJukeboxBlockEntity jukebox = (AlbumJukeboxBlockEntity)blockEntity;
        jukebox.next();
        EtchedClientPlayHandler.playAlbum((AlbumJukeboxBlockEntity)blockEntity, level, pos, true);
    }

    public static void playAlbum(AlbumJukeboxBlockEntity jukebox, class_638 level, class_2338 pos, boolean force) {
        EtchedMusicDiscItem.MusicInfo music;
        Optional<EtchedMusicDiscItem.MusicInfo> optional;
        class_1144 soundManager = class_310.method_1551().method_1483();
        Map<class_2338, class_1113> playingRecords = ((LevelRendererAccessor)class_310.method_1551().field_1769).getPlayingRecords();
        if (!(((Boolean)level.method_8320(pos).method_11654((class_2769)AlbumJukeboxBlock.POWERED)).booleanValue() || jukebox.recalculatePlayingIndex() || force)) {
            return;
        }
        class_1113 soundInstance = playingRecords.get(pos);
        if (soundInstance != null) {
            if (soundInstance instanceof StopListeningSound) {
                ((StopListeningSound)soundInstance).stopListening();
            }
            soundManager.method_4870(soundInstance);
            playingRecords.remove(pos);
        }
        if (((Boolean)level.method_8320(pos).method_11654((class_2769)AlbumJukeboxBlock.POWERED)).booleanValue()) {
            jukebox.stopPlaying();
        }
        if (jukebox.getPlayingIndex() < 0) {
            return;
        }
        class_1799 disc = jukebox.method_5438(jukebox.getPlayingIndex());
        StopListeningSound sound = null;
        if (disc.method_7909() == EtchedRegistry.ETCHED_MUSIC_DISC.get() && (optional = EtchedMusicDiscItem.getMusic(disc)).isPresent() && EtchedMusicDiscItem.isValidURL((music = optional.get()).getUrl())) {
            sound = new StopListeningSound(EtchedClientPlayHandler.getEtchedRecord(music.getUrl(), music.getDisplayName(), level, pos), () -> class_310.method_1551().method_18858(() -> EtchedClientPlayHandler.playNextRecord(level, pos)));
        }
        if (disc.method_7909() instanceof class_1813) {
            if (EtchedClientPlayHandler.canShowMessage((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5)) {
                class_310.method_1551().field_1705.method_1732((class_2561)((class_1813)disc.method_7909()).method_8011());
            }
            sound = new StopListeningSound((class_1113)class_1109.method_4760((class_3414)((class_1813)disc.method_7909()).method_8009(), (double)((double)pos.method_10263() + 0.5), (double)((double)pos.method_10264() + 0.5), (double)((double)pos.method_10260() + 0.5)), () -> class_310.method_1551().method_18858(() -> EtchedClientPlayHandler.playNextRecord(level, pos)));
        }
        if (sound == null) {
            return;
        }
        EtchedClientPlayHandler.playRecord(pos, sound);
        if (disc.method_7909() instanceof class_1813 && level.method_8320(pos).method_27852(class_2246.field_10223)) {
            for (class_1309 livingEntity : level.method_18467(class_1309.class, new class_238(pos).method_1014(3.0))) {
                livingEntity.method_6006(pos, true);
            }
        }
    }

    private static abstract class MusicDownloadListener
    implements DownloadProgressListener {
        private final class_2561 title;
        private final DoubleSupplier x;
        private final DoubleSupplier y;
        private final DoubleSupplier z;
        private float size;
        private class_2561 requesting;
        private DownloadTextComponent component;

        protected MusicDownloadListener(class_2561 title, DoubleSupplier x, DoubleSupplier y, DoubleSupplier z) {
            this.title = title;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        private void setComponent(class_2561 text) {
            if (!EtchedClientPlayHandler.canShowMessage(this.x.getAsDouble(), this.y.getAsDouble(), this.z.getAsDouble())) {
                return;
            }
            if (this.component == null) {
                this.component = new DownloadTextComponent();
                class_310.method_1551().field_1705.method_1758((class_2561)this.component, true);
                ((GuiAccessor)class_310.method_1551().field_1705).setOverlayMessageTime(Short.MAX_VALUE);
            }
            this.component.setText(text.getString());
        }

        protected void clearComponent() {
            if (((GuiAccessor)class_310.method_1551().field_1705).getOverlayMessageString() == this.component) {
                ((GuiAccessor)class_310.method_1551().field_1705).setOverlayMessageTime(60);
                this.component = null;
            }
        }

        @Override
        public void progressStartRequest(class_2561 component) {
            this.requesting = component;
            this.setComponent(component);
        }

        @Override
        public void progressStartDownload(float size) {
            this.size = size;
            this.requesting = null;
            this.progressStagePercentage(0);
        }

        @Override
        public void progressStagePercentage(int percentage) {
            if (this.requesting != null) {
                this.setComponent((class_2561)this.requesting.method_27661().method_27693(" " + percentage + "%"));
            } else if (this.size != 0.0f) {
                this.setComponent((class_2561)new class_2588("record.etched.downloadProgress", new Object[]{String.format(Locale.ROOT, "%.2f", Float.valueOf((float)percentage / 100.0f * this.size)), String.format(Locale.ROOT, "%.2f", Float.valueOf(this.size)), this.title}));
            }
        }

        @Override
        public void progressStartLoading() {
            this.requesting = null;
            this.setComponent((class_2561)new class_2588("record.etched.loading", new Object[]{this.title}));
        }

        @Override
        public void onFail() {
            if (EtchedClientPlayHandler.canShowMessage(this.x.getAsDouble(), this.y.getAsDouble(), this.z.getAsDouble())) {
                class_310.method_1551().field_1705.method_1758((class_2561)new class_2588("record.etched.downloadFail", new Object[]{this.title}), true);
            }
        }
    }

    public static class DownloadTextComponent
    extends class_2554 {
        private String text = "";
        private class_5481 visualOrderText;
        private class_2477 decomposedWith;

        public String method_10851() {
            return this.text;
        }

        public class_2585 plainCopy() {
            return new class_2585(this.text);
        }

        @Environment(value=EnvType.CLIENT)
        public class_5481 method_30937() {
            class_2477 language = class_2477.method_10517();
            if (this.decomposedWith != language) {
                this.visualOrderText = language.method_30934((class_5348)this);
                this.decomposedWith = language;
            }
            return this.visualOrderText;
        }

        public String toString() {
            return "TextComponent{text='" + this.text + '\'' + ", siblings=" + this.field_11729 + ", style=" + this.method_10866() + '}';
        }

        public void setText(String text) {
            this.text = text;
            this.decomposedWith = null;
        }
    }
}

