/*
 * Decompiled with CFR 0.152.
 */
package me.jaackson.etched.mixin.client;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import me.jaackson.etched.client.sound.AbstractOnlineSoundInstance;
import me.jaackson.etched.client.sound.SoundStopListener;
import me.jaackson.etched.client.sound.download.EmptyAudioStream;
import me.jaackson.etched.client.sound.download.RawAudioStream;
import me.jaackson.etched.client.sound.download.SoundCache;
import me.jaackson.etched.client.sound.format.MonoWrapper;
import me.jaackson.etched.client.sound.format.SeekingStream;
import me.jaackson.etched.client.sound.format.WaveDataReader;
import me.jaackson.etched.client.sound.source.AudioSource;
import me.jaackson.etched.common.item.EtchedMusicDiscItem;
import me.jaackson.etched.lib.javamp3.Sound;
import net.minecraft.class_1111;
import net.minecraft.class_1113;
import net.minecraft.class_1140;
import net.minecraft.class_1146;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4228;
import net.minecraft.class_4234;
import net.minecraft.class_4235;
import net.minecraft.class_4237;
import net.minecraft.class_4856;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_1140.class})
public abstract class SoundEngineMixin {
    @Shadow
    @Final
    private static Logger field_5559;
    @Unique
    private class_1111 sound;

    @Inject(method={"tickNonPaused"}, at={@At(value="INVOKE", target="Ljava/util/Map;remove(Ljava/lang/Object;)Ljava/lang/Object;", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILHARD)
    public void onSoundRemoved(CallbackInfo ci, Iterator<?> iterator, Map.Entry<?, ?> entry, class_4235.class_4236 channelHandle2, class_1113 soundInstance) {
        if (soundInstance instanceof SoundStopListener) {
            ((SoundStopListener)soundInstance).onStop();
        }
    }

    @Inject(method={"play"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/sounds/SoundBufferLibrary;getStream(Lnet/minecraft/resources/ResourceLocation;Z)Ljava/util/concurrent/CompletableFuture;", shift=At.Shift.BEFORE)}, locals=LocalCapture.CAPTURE_FAILHARD)
    public void captureSound(class_1113 soundInstance, CallbackInfo ci, class_1146 weighedSoundEvents, class_2960 resourceLocation, class_1111 sound) {
        this.sound = sound;
    }

    @Redirect(method={"play"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/sounds/SoundBufferLibrary;getStream(Lnet/minecraft/resources/ResourceLocation;Z)Ljava/util/concurrent/CompletableFuture;"))
    public CompletableFuture<class_4234> redirectSoundStream(class_4237 soundBufferLibrary, class_2960 resourceLocation, boolean loop) {
        if (!(this.sound instanceof AbstractOnlineSoundInstance.OnlineSound)) {
            return soundBufferLibrary.method_19744(resourceLocation, loop);
        }
        AbstractOnlineSoundInstance.OnlineSound onlineSound = (AbstractOnlineSoundInstance.OnlineSound)this.sound;
        if (EtchedMusicDiscItem.isLocalSound(onlineSound.getURL())) {
            class_1146 weighedSoundEvents = class_310.method_1551().method_1483().method_4869(new class_2960(onlineSound.getURL()));
            if (weighedSoundEvents == null) {
                throw new CompletionException(new FileNotFoundException("Unable to play unknown soundEvent: " + resourceLocation));
            }
            return ((CompletableFuture)soundBufferLibrary.method_19744(weighedSoundEvents.method_4887().method_4766(), loop).thenApplyAsync(MonoWrapper::new, class_156.method_18349())).handleAsync((stream, e) -> {
                if (e != null) {
                    e.printStackTrace();
                    onlineSound.getProgressListener().onFail();
                    return EmptyAudioStream.INSTANCE;
                }
                onlineSound.getProgressListener().onSuccess();
                return stream;
            }, class_156.method_18349());
        }
        return ((CompletableFuture)((CompletableFuture)SoundCache.getAudioStream(onlineSound.getURL(), onlineSound.getProgressListener()).thenComposeAsync(AudioSource::openStream)).thenApplyAsync(is -> {
            onlineSound.getProgressListener().progressStartLoading();
            try {
                try {
                    return new MonoWrapper((class_4234)(loop ? new class_4856(class_4228::new, is) : new class_4228(is)));
                }
                catch (Exception e) {
                    field_5559.debug("Failed to load as OGG", (Throwable)e);
                    ((SeekingStream)((Object)is)).beginning();
                    try {
                        AudioInputStream ais = WaveDataReader.getAudioInputStream(is);
                        AudioFormat format = ais.getFormat();
                        return new MonoWrapper((class_4234)(loop ? new class_4856(input -> new RawAudioStream(format, input), (InputStream)ais) : new RawAudioStream(format, ais)));
                    }
                    catch (Exception e1) {
                        field_5559.debug("Failed to load as WAV", (Throwable)e1);
                        ((SeekingStream)((Object)is)).beginning();
                        try {
                            Sound sound = new Sound(new BufferedInputStream((InputStream)is));
                            AudioFormat format = sound.getAudioFormat();
                            return new MonoWrapper((class_4234)(loop ? new class_4856(input -> new RawAudioStream(format, input), (InputStream)sound) : new RawAudioStream(format, sound)));
                        }
                        catch (Exception e2) {
                            field_5559.debug("Failed to load as MP3", (Throwable)e2);
                            IOUtils.closeQuietly((InputStream)is);
                            e.printStackTrace();
                            e1.printStackTrace();
                            e2.printStackTrace();
                            throw new CompletionException(new UnsupportedAudioFileException("Could not load as OGG, WAV, OR MP3"));
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new CompletionException(e);
            }
        }, class_156.method_18349())).handleAsync((stream, e) -> {
            if (e != null) {
                e.printStackTrace();
                onlineSound.getProgressListener().onFail();
                return EmptyAudioStream.INSTANCE;
            }
            onlineSound.getProgressListener().onSuccess();
            return stream;
        }, class_156.method_18349());
    }
}

