/*
 * Decompiled with CFR 0.152.
 */
package me.jaackson.etched;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Random;
import java.util.function.Supplier;
import me.jaackson.etched.EtchedRegistry;
import me.jaackson.etched.bridge.NetworkBridge;
import me.jaackson.etched.bridge.RegistryBridge;
import me.jaackson.etched.client.screen.AlbumJukeboxScreen;
import me.jaackson.etched.client.screen.EtchingScreen;
import me.jaackson.etched.common.item.EtchedMusicDiscItem;
import me.jaackson.etched.common.network.ClientboundAddMinecartJukeboxPacket;
import me.jaackson.etched.common.network.ClientboundInvalidEtchUrlPacket;
import me.jaackson.etched.common.network.ClientboundPlayMinecartJukeboxMusicPacket;
import me.jaackson.etched.common.network.ClientboundPlayMusicPacket;
import me.jaackson.etched.common.network.ServerboundSetEtchingUrlPacket;
import me.jaackson.etched.common.network.handler.EtchedClientPlayHandler;
import me.jaackson.etched.common.network.handler.EtchedServerPlayHandler;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.MinecartRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;

public class Etched {
    public static final String MOD_ID = "etched";

    public static void commonInit() {
        EtchedRegistry.register();
        RegistryBridge.registerVillagerTrades(EtchedRegistry.BARD, () -> (Int2ObjectMap)Util.func_200696_a((Object)new Int2ObjectOpenHashMap(), map -> {
            map.put(1, (Object)new VillagerTrades.ITrade[]{new ItemTrade(() -> Items.field_196156_dS, 8, 1, 16, 2, true), new ItemTrade(() -> Items.field_221664_at, 12, 2, 16, 2, true), new ItemTrade(() -> Items.field_221664_at, 8, 1, 12, 1), new ItemTrade(EtchedRegistry.MUSIC_LABEL, 4, 2, 12, 1)});
            map.put(2, (Object)new VillagerTrades.ITrade[]{new ItemTrade(EtchedRegistry.BLANK_MUSIC_DISC, 28, 2, 12, 5), new ItemTrade(() -> EtchedRegistry.ETCHING_TABLE.get().func_199767_j(), 32, 1, 12, 5)});
            map.put(3, (Object)new VillagerTrades.ITrade[]{new ItemTrade(() -> Items.field_221778_cy, 26, 1, 12, 10), new ItemTrade(() -> Items.field_196158_dT, 24, 1, 16, 20, true)});
            ArrayList<ItemTrade> tier4 = new ArrayList<ItemTrade>();
            for (Item item : ItemTags.field_219774_K.func_230236_b_()) {
                tier4.add(new ItemTrade(() -> item, 48, 1, 8, 30, true));
            }
            tier4.add(new ItemTrade(() -> Items.field_221778_cy, 20, 1, 16, 30, true));
            tier4.add(new ItemTrade(EtchedRegistry.JUKEBOX_MINECART, 24, 1, 16, 30, true));
            tier4.add(new ItemTrade(() -> EtchedRegistry.ALBUM_JUKEBOX.get().func_199767_j(), 30, 1, 12, 15));
            map.put(4, (Object)tier4.toArray(new VillagerTrades.ITrade[0]));
            map.put(5, (Object)new VillagerTrades.ITrade[]{new ItemTrade(EtchedRegistry.BLANK_MUSIC_DISC, 14, 1, 16, 40, true), new ItemTrade(EtchedRegistry.MUSIC_LABEL, 1, 1, 16, 40, true), new ItemTrade(() -> EtchedRegistry.ETCHING_TABLE.get().func_199767_j(), 22, 1, 16, 40, true)});
        }));
    }

    public static void clientInit() {
        RegistryBridge.registerSprite(new ResourceLocation(MOD_ID, "item/empty_etching_table_slot_music_disc"), PlayerContainer.field_226615_c_);
        RegistryBridge.registerSprite(new ResourceLocation(MOD_ID, "item/empty_etching_table_slot_music_label"), PlayerContainer.field_226615_c_);
        RegistryBridge.registerItemColor((stack, index) -> index > 0 ? -1 : ((IDyeableArmorItem)stack.func_77973_b()).func_200886_f(stack), EtchedRegistry.BLANK_MUSIC_DISC, EtchedRegistry.MUSIC_LABEL);
        RegistryBridge.registerItemColor((stack, index) -> index == 0 ? EtchedMusicDiscItem.getPrimaryColor(stack) : (index == 1 && EtchedMusicDiscItem.getPattern(stack).isColorable() ? EtchedMusicDiscItem.getSecondaryColor(stack) : -1), EtchedRegistry.ETCHED_MUSIC_DISC);
    }

    public static void commonPostInit() {
        EtchedRegistry.registerVillages();
    }

    public static void clientPostInit() {
        RegistryBridge.registerScreenFactory(EtchedRegistry.ETCHING_MENU.get(), EtchingScreen::new);
        RegistryBridge.registerScreenFactory(EtchedRegistry.ALBUM_JUKEBOX_MENU.get(), AlbumJukeboxScreen::new);
        RegistryBridge.registerBlockRenderType(EtchedRegistry.ETCHING_TABLE.get(), RenderType.func_228643_e_());
        RegistryBridge.registerItemOverride(EtchedRegistry.ETCHED_MUSIC_DISC.get(), new ResourceLocation(MOD_ID, "pattern"), (stack, level, livingEntity) -> EtchedMusicDiscItem.getPattern(stack).ordinal());
        RegistryBridge.registerEntityRenderer(EtchedRegistry.JUKEBOX_MINECART_ENTITY.get(), MinecartRenderer::new);
    }

    public static void commonNetworkingInit() {
        NetworkBridge.registerPlayToServer(ServerboundSetEtchingUrlPacket.CHANNEL, ServerboundSetEtchingUrlPacket.class, ServerboundSetEtchingUrlPacket::new, EtchedServerPlayHandler::handleSetEtcherUrl);
    }

    public static void clientNetworkingInit() {
        NetworkBridge.registerPlayToClient(ClientboundPlayMusicPacket.CHANNEL, ClientboundPlayMusicPacket.class, ClientboundPlayMusicPacket::new, () -> EtchedClientPlayHandler::handlePlayMusicPacket);
        NetworkBridge.registerPlayToClient(ClientboundAddMinecartJukeboxPacket.CHANNEL, ClientboundAddMinecartJukeboxPacket.class, ClientboundAddMinecartJukeboxPacket::new, () -> EtchedClientPlayHandler::handleAddMinecartJukeboxPacket);
        NetworkBridge.registerPlayToClient(ClientboundPlayMinecartJukeboxMusicPacket.CHANNEL, ClientboundPlayMinecartJukeboxMusicPacket.class, ClientboundPlayMinecartJukeboxMusicPacket::new, () -> EtchedClientPlayHandler::handlePlayMinecartJukeboxPacket);
        NetworkBridge.registerPlayToClient(ClientboundInvalidEtchUrlPacket.CHANNEL, ClientboundInvalidEtchUrlPacket.class, ClientboundInvalidEtchUrlPacket::new, () -> EtchedClientPlayHandler::handleSetInvalidEtch);
    }

    static class ItemTrade
    implements VillagerTrades.ITrade {
        private final Supplier<Item> item;
        private final int emeralds;
        private final int itemCount;
        private final int maxUses;
        private final int xpGain;
        private final float priceMultiplier;
        private final boolean sellToVillager;

        public ItemTrade(Supplier<Item> Item2, int emeralds, int itemCount, int maxUses, int xpGain) {
            this(Item2, emeralds, itemCount, maxUses, xpGain, 0.05f, false);
        }

        public ItemTrade(Supplier<Item> Item2, int emeralds, int itemCount, int maxUses, int xpGain, boolean sellToVillager) {
            this(Item2, emeralds, itemCount, maxUses, xpGain, 0.05f, sellToVillager);
        }

        public ItemTrade(Supplier<Item> Item2, int emeralds, int itemCount, int maxUses, int xpGain, float priceMultiplier, boolean sellToVillager) {
            this.item = Item2;
            this.emeralds = emeralds;
            this.itemCount = itemCount;
            this.maxUses = maxUses;
            this.xpGain = xpGain;
            this.priceMultiplier = priceMultiplier;
            this.sellToVillager = sellToVillager;
        }

        public MerchantOffer func_221182_a(Entity entity, Random random) {
            ItemStack emeralds = new ItemStack((IItemProvider)Items.field_151166_bC, this.emeralds);
            ItemStack item = new ItemStack((IItemProvider)this.item.get(), this.itemCount);
            return new MerchantOffer(this.sellToVillager ? item : emeralds, this.sellToVillager ? emeralds : item, this.maxUses, this.xpGain, this.priceMultiplier);
        }
    }
}

