/*
 * Decompiled with CFR 0.152.
 */
package me.jaackson.etched.client.sound.source;

import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import me.jaackson.etched.client.sound.download.SoundCache;
import me.jaackson.etched.client.sound.format.FileChannelInputStream;
import me.jaackson.etched.client.sound.source.AudioSource;
import net.minecraft.util.HTTPUtil;
import net.minecraft.util.Util;

public class RawAudioSource
implements AudioSource {
    private final Path location;
    private final CompletableFuture<?> downloadFuture;
    private CompletableFuture<InputStream> stream;

    public RawAudioSource(Proxy proxy, String hash, URL url, boolean temporary) throws IOException {
        this.location = SoundCache.resolveFilePath(hash, temporary);
        this.downloadFuture = CompletableFuture.runAsync(() -> AudioSource.downloadTo(this.location.toFile(), url, null, proxy, temporary), (Executor)HTTPUtil.field_180193_a);
    }

    @Override
    public CompletableFuture<InputStream> openStream() {
        if (this.stream != null) {
            return this.stream;
        }
        this.stream = this.downloadFuture.thenApplyAsync(__ -> {
            try {
                return new FileChannelInputStream(FileChannel.open(this.location, StandardOpenOption.READ));
            }
            catch (Exception e) {
                throw new CompletionException("Failed to open channel", e);
            }
        }, Util.func_240992_g_());
        return this.stream;
    }
}

