/*
 * Decompiled with CFR 0.152.
 */
package me.jaackson.etched.client.sound.source;

import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.stream.IntStream;
import me.jaackson.etched.client.sound.download.AccumulatingDownloadProgressListener;
import me.jaackson.etched.client.sound.download.DownloadProgressListener;
import me.jaackson.etched.client.sound.download.SoundCache;
import me.jaackson.etched.client.sound.format.FileChannelInputStream;
import me.jaackson.etched.client.sound.format.StreamingInputStream;
import me.jaackson.etched.client.sound.source.AudioSource;
import net.minecraft.util.HTTPUtil;
import net.minecraft.util.Util;
import org.apache.commons.codec.digest.DigestUtils;
import org.jetbrains.annotations.Nullable;

public class StreamingAudioSource
implements AudioSource {
    private final Proxy proxy;
    private final boolean temporary;
    private final Path[] locations;
    private final URL[] urls;
    private final CompletableFuture<?> downloadFuture;
    private CompletableFuture<InputStream> stream;

    public StreamingAudioSource(Proxy proxy, String hash, URL[] urls, @Nullable DownloadProgressListener progressListener, boolean temporary) throws IOException {
        this.proxy = proxy;
        this.temporary = temporary;
        this.locations = new Path[urls.length];
        for (int i2 = 0; i2 < urls.length; ++i2) {
            this.locations[i2] = SoundCache.resolveFilePath(DigestUtils.sha1Hex((String)(hash + i2)), temporary);
        }
        this.urls = urls;
        int files = Math.min(urls.length, 3);
        AccumulatingDownloadProgressListener accumulatingListener = progressListener != null ? new AccumulatingDownloadProgressListener(progressListener, files) : null;
        this.downloadFuture = CompletableFuture.allOf((CompletableFuture[])IntStream.range(0, files).mapToObj(i -> CompletableFuture.runAsync(() -> AudioSource.downloadTo(this.locations[i].toFile(), urls[i], accumulatingListener, proxy, temporary), (Executor)HTTPUtil.field_180193_a)).toArray(CompletableFuture[]::new));
    }

    @Override
    public CompletableFuture<InputStream> openStream() {
        if (this.stream != null) {
            return this.stream;
        }
        this.stream = this.downloadFuture.thenApplyAsync(__ -> {
            try {
                return new StreamingInputStream(this.urls, i -> CompletableFuture.runAsync(() -> AudioSource.downloadTo(this.locations[i].toFile(), this.urls[i], null, this.proxy, this.temporary), (Executor)HTTPUtil.field_180193_a).thenApplyAsync(___ -> {
                    try {
                        return new FileChannelInputStream(FileChannel.open(this.locations[i], StandardOpenOption.READ));
                    }
                    catch (Exception e) {
                        throw new CompletionException("Failed to open channel", e);
                    }
                }, Util.func_240992_g_()));
            }
            catch (Exception e) {
                throw new CompletionException("Failed to open channel", e);
            }
        }, Util.func_240992_g_());
        return this.stream;
    }
}

