/*
 * Decompiled with CFR 0.152.
 */
package me.jaackson.etched.common.blockentity;

import me.jaackson.etched.EtchedRegistry;
import me.jaackson.etched.common.item.EtchedMusicDiscItem;
import me.jaackson.etched.common.menu.AlbumJukeboxMenu;
import me.jaackson.etched.common.network.handler.EtchedClientPlayHandler;
import me.shedaniel.architectury.annotations.PlatformOnly;
import net.minecraft.block.BlockState;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class AlbumJukeboxBlockEntity
extends LockableLootTileEntity
implements ISidedInventory {
    private static final int[] SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    private NonNullList<ItemStack> items = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
    private int playingIndex = -1;
    private ItemStack playingStack = ItemStack.field_190927_a;

    public AlbumJukeboxBlockEntity() {
        super(EtchedRegistry.ALBUM_JUKEBOX_BE.get());
    }

    private void updatePlaying() {
        if (this.field_145850_b == null) {
            return;
        }
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
    }

    public void func_230337_a_(BlockState state, CompoundNBT hbt) {
        super.func_230337_a_(state, hbt);
        this.items = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        if (!this.func_184283_b(hbt)) {
            ItemStackHelper.func_191283_b((CompoundNBT)hbt, this.items);
        }
        if (this.field_145850_b != null && this.field_145850_b.func_201670_d()) {
            EtchedClientPlayHandler.playAlbum(this, (ClientWorld)this.field_145850_b, this.func_174877_v(), false);
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT hbt) {
        super.func_189515_b(hbt);
        if (!this.func_184282_c(hbt)) {
            ItemStackHelper.func_191282_a((CompoundNBT)hbt, this.items);
        }
        return hbt;
    }

    @PlatformOnly(value={"forge"})
    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public int[] func_180463_a(Direction direction) {
        return SLOTS;
    }

    public boolean func_180462_a(int index, ItemStack stack, @Nullable Direction direction) {
        return EtchedMusicDiscItem.isPlayableRecord(stack);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return true;
    }

    public int func_70302_i_() {
        return 9;
    }

    public ItemStack func_70298_a(int index, int amount) {
        ItemStack stack = super.func_70298_a(index, amount);
        if (!stack.func_190926_b()) {
            this.updatePlaying();
        }
        return stack;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = super.func_70304_b(index);
        if (!stack.func_190926_b()) {
            this.updatePlaying();
        }
        return stack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        super.func_70299_a(index, stack);
        this.updatePlaying();
    }

    public void func_174888_l() {
        super.func_174888_l();
        this.updatePlaying();
    }

    protected NonNullList<ItemStack> func_190576_q() {
        return this.items;
    }

    protected void func_199721_a(NonNullList<ItemStack> nonNullList) {
        this.items = nonNullList;
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.etched.album_jukebox");
    }

    protected Container func_213906_a(int menuId, PlayerInventory inventory) {
        return new AlbumJukeboxMenu(menuId, inventory, (IInventory)this, this.func_174877_v());
    }

    public int func_70297_j_() {
        return 1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getPlayingIndex() {
        return this.playingIndex;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void stopPlaying() {
        this.playingIndex = -1;
        this.playingStack = ItemStack.field_190927_a;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void next() {
        ++this.playingIndex;
        this.playingIndex %= this.func_70302_i_();
        this.playingStack = ItemStack.field_190927_a;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void nextPlayingIndex() {
        boolean wrap = false;
        if (this.playingIndex < 0) {
            this.playingIndex = 0;
        }
        while (!EtchedMusicDiscItem.isPlayableRecord(this.func_70301_a(this.playingIndex))) {
            ++this.playingIndex;
            if (this.playingIndex < this.func_70302_i_()) continue;
            this.playingIndex = 0;
            if (wrap) {
                this.playingIndex = -1;
                this.playingStack = ItemStack.field_190927_a;
                return;
            }
            wrap = true;
        }
        this.playingStack = this.func_70301_a(this.playingIndex).func_77946_l();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean recalculatePlayingIndex() {
        if (this.func_191420_l()) {
            if (this.playingIndex == -1) {
                return false;
            }
            this.playingIndex = -1;
            return true;
        }
        int oldIndex = this.playingIndex;
        ItemStack oldStack = this.playingStack.func_77946_l();
        this.nextPlayingIndex();
        return oldIndex != this.playingIndex || !ItemStack.func_77989_b((ItemStack)oldStack, (ItemStack)this.playingStack);
    }
}

