/*
 * Decompiled with CFR 0.152.
 */
package me.jaackson.etched.common.item;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Pattern;
import me.jaackson.etched.EtchedRegistry;
import me.jaackson.etched.bridge.NetworkBridge;
import me.jaackson.etched.client.sound.download.SoundCloud;
import me.jaackson.etched.common.network.ClientboundPlayMusicPacket;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.JukeboxBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.MusicDiscItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class EtchedMusicDiscItem
extends Item {
    private static final Pattern RESOURCE_LOCATION_PATTERN = Pattern.compile("[a-z0-9_.-]+");

    public EtchedMusicDiscItem(Item.Properties properties) {
        super(properties);
    }

    public static Optional<MusicInfo> getMusic(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt == null || !nbt.func_150297_b("Music", 10)) {
            return Optional.empty();
        }
        MusicInfo music = new MusicInfo();
        music.load(nbt.func_74775_l("Music"));
        return music.getUrl() != null && EtchedMusicDiscItem.isValidURL(music.getUrl()) ? Optional.of(music) : Optional.empty();
    }

    public static LabelPattern getPattern(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt == null || !nbt.func_150297_b("Pattern", 99)) {
            return LabelPattern.FLAT;
        }
        byte id = nbt.func_74771_c("Pattern");
        return id < 0 || id >= LabelPattern.values().length ? LabelPattern.FLAT : LabelPattern.values()[id];
    }

    public static int getPrimaryColor(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt == null || !nbt.func_150297_b("PrimaryColor", 99)) {
            return 0x515151;
        }
        return nbt.func_74762_e("PrimaryColor");
    }

    public static int getSecondaryColor(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt == null || !nbt.func_150297_b("SecondaryColor", 99)) {
            return 0xFFFFFF;
        }
        return nbt.func_74762_e("SecondaryColor");
    }

    public static void setMusic(ItemStack stack, @Nullable MusicInfo musicInfo) {
        if (musicInfo == null) {
            if (stack.func_77978_p() != null) {
                stack.func_77978_p().func_82580_o("Music");
            }
        } else {
            stack.func_196082_o().func_218657_a("Music", (INBT)musicInfo.save(new CompoundNBT()));
        }
    }

    public static void setPattern(ItemStack stack, @Nullable LabelPattern pattern) {
        if (pattern == null) {
            if (stack.func_77978_p() != null) {
                stack.func_77978_p().func_82580_o("Pattern");
            }
        } else {
            stack.func_196082_o().func_74774_a("Pattern", (byte)pattern.ordinal());
        }
    }

    public static void setColor(ItemStack stack, int primaryColor, int secondaryColor) {
        stack.func_196082_o().func_74768_a("PrimaryColor", primaryColor);
        stack.func_196082_o().func_74768_a("SecondaryColor", secondaryColor);
    }

    public static boolean isValidURL(String url) {
        if (EtchedMusicDiscItem.isLocalSound(url)) {
            return true;
        }
        try {
            String scheme = new URI(url).getScheme();
            return "http".equals(scheme) || "https".equals(scheme);
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    public static boolean isLocalSound(String url) {
        String[] parts = url.split(":");
        if (parts.length > 2) {
            return false;
        }
        for (String part : parts) {
            if (RESOURCE_LOCATION_PATTERN.matcher(part).matches()) continue;
            return false;
        }
        return true;
    }

    public static boolean isPlayableRecord(ItemStack stack) {
        if (stack.func_77973_b() instanceof MusicDiscItem) {
            return true;
        }
        if (stack.func_77973_b() == EtchedRegistry.ETCHED_MUSIC_DISC.get()) {
            return EtchedMusicDiscItem.getMusic(stack).isPresent();
        }
        return false;
    }

    public void func_77624_a(ItemStack stack, @Nullable World level, List<ITextComponent> list, ITooltipFlag tooltipFlag) {
        EtchedMusicDiscItem.getMusic(stack).ifPresent(music -> {
            list.add((ITextComponent)music.getDisplayName().func_230532_e_().func_240699_a_(TextFormatting.GRAY));
            if (SoundCloud.isValidUrl(music.getUrl())) {
                list.add((ITextComponent)new TranslationTextComponent(this.func_77667_c(stack) + ".sound_cloud").func_240700_a_(style -> style.func_240718_a_(Color.func_240743_a_((int)0xFF5500))));
            }
        });
    }

    public ActionResultType func_195939_a(ItemUseContext ctx) {
        BlockPos pos;
        World level = ctx.func_195991_k();
        BlockState state = level.func_180495_p(pos = ctx.func_195995_a());
        if (!state.func_203425_a(Blocks.field_150421_aI) || ((Boolean)state.func_177229_b((Property)JukeboxBlock.field_176432_a)).booleanValue()) {
            return ActionResultType.PASS;
        }
        ItemStack stack = ctx.func_195996_i();
        Optional<MusicInfo> optional = EtchedMusicDiscItem.getMusic(stack);
        if (!optional.isPresent()) {
            return ActionResultType.PASS;
        }
        if (!level.func_201670_d()) {
            MusicInfo music = optional.get();
            ((JukeboxBlock)Blocks.field_150421_aI).func_176431_a((IWorld)level, pos, state, stack);
            NetworkBridge.sendToNear((ServerWorld)level, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 64.0, new ClientboundPlayMusicPacket(music.getDisplayName(), music.getUrl(), pos));
            stack.func_190918_g(1);
            PlayerEntity player = ctx.func_195999_j();
            if (player != null) {
                player.func_195066_a(Stats.field_188092_Z);
            }
        }
        return ActionResultType.func_233537_a_((boolean)level.func_201670_d());
    }

    public static class MusicInfo {
        private String url = null;
        private String title = "Custom Music";
        private String author = "Unknown";

        private CompoundNBT save(CompoundNBT nbt) {
            if (this.url != null) {
                nbt.func_74778_a("Url", this.url);
            }
            if (this.title != null) {
                nbt.func_74778_a("Title", this.title);
            }
            if (this.author != null) {
                nbt.func_74778_a("Author", this.author);
            }
            return nbt;
        }

        private void load(CompoundNBT nbt) {
            this.url = nbt.func_150297_b("Url", 8) ? nbt.func_74779_i("Url") : null;
            this.title = nbt.func_150297_b("Title", 8) ? nbt.func_74779_i("Title") : "Custom Music";
            this.author = nbt.func_150297_b("Author", 8) ? nbt.func_74779_i("Author") : "Unknown";
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getAuthor() {
            return this.author;
        }

        public void setAuthor(String author) {
            this.author = author;
        }

        public ITextComponent getDisplayName() {
            return new StringTextComponent(this.author + " - " + this.title);
        }
    }

    public static enum LabelPattern {
        FLAT,
        CROSS,
        EYE,
        PARALLEL,
        STAR,
        GOLD;

        private final ResourceLocation texture = new ResourceLocation("etched", "textures/item/" + this.name().toLowerCase(Locale.ROOT) + "_etched_music_disc_label.png");

        @OnlyIn(value=Dist.CLIENT)
        public ResourceLocation getTexture() {
            return this.texture;
        }

        @OnlyIn(value=Dist.CLIENT)
        public boolean isColorable() {
            return this != GOLD;
        }
    }
}

